/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references;

import com.intellij.gwt.references.GwtToCssClassReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GwtToCssClassReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiLiteralExpression literalExpression;
        Object value;
        if (element == null) {
            GwtToCssClassReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GwtToCssClassReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiLiteralExpression && (value = (literalExpression = (PsiLiteralExpression)element).getValue()) instanceof String) {
            String text = (String)value;
            List<TextRange> ranges = GwtToCssClassReferenceProvider.getWordRanges(text, 1);
            PsiReference[] references = new PsiReference[ranges.size()];
            for (int i = 0; i < ranges.size(); ++i) {
                TextRange rangeInElement = ranges.get(i);
                references[i] = new GwtToCssClassReference<PsiLiteralExpression>(literalExpression, rangeInElement);
            }
            if (references == null) {
                GwtToCssClassReferenceProvider.$$$reportNull$$$0(2);
            }
            return references;
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)element;
            String attributeText = attributeValue.getValue();
            List<TextRange> ranges = GwtToCssClassReferenceProvider.getWordRanges(attributeText, 1);
            ArrayList<GwtToCssClassReference<XmlAttributeValue>> references = new ArrayList<GwtToCssClassReference<XmlAttributeValue>>();
            for (TextRange range : ranges) {
                String refText = range.shiftRight(-1).substring(attributeText);
                if (refText.startsWith("{")) continue;
                references.add(new GwtToCssClassReference<XmlAttributeValue>(attributeValue, range));
            }
            PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
            if (psiReferenceArray == null) {
                GwtToCssClassReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            GwtToCssClassReferenceProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static List<TextRange> getWordRanges(String text, int shift) {
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int start = 0;
        while (true) {
            int end;
            if ((end = text.indexOf(32, start)) == -1) {
                if (start >= text.length()) break;
                ranges.add(new TextRange(shift + start, shift + text.length()));
                break;
            }
            if (start < end) {
                ranges.add(new TextRange(shift + start, shift + end));
            }
            start = end + 1;
        }
        return ranges;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/references/GwtToCssClassReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/references/GwtToCssClassReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

