/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references;

import com.intellij.gwt.codeInsight.GwtReferenceUtil;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGwtReference<T extends PsiElement>
extends PsiReferenceBase<T> {
    protected final GwtModulesManager myGwtModulesManager;

    protected BaseGwtReference(T element, boolean soft) {
        super(element, soft);
        this.myGwtModulesManager = GwtModulesManager.getInstance(this.myElement.getProject());
    }

    protected BaseGwtReference(T element) {
        this(element, false);
    }

    @NotNull
    protected XmlFile[] getHtmlFilesForModule() {
        GwtModule module = this.findGwtModule();
        if (module == null) {
            if (XmlFile.EMPTY_ARRAY == null) {
                BaseGwtReference.$$$reportNull$$$0(0);
            }
            return XmlFile.EMPTY_ARRAY;
        }
        XmlFile[] xmlFileArray = this.myGwtModulesManager.findHtmlFilesByModule(module);
        if (xmlFileArray == null) {
            BaseGwtReference.$$$reportNull$$$0(1);
        }
        return xmlFileArray;
    }

    @Nullable
    protected static GwtVersion getGwtVersion(@NotNull GwtModule gwtModule) {
        GwtFacet facet;
        if (gwtModule == null) {
            BaseGwtReference.$$$reportNull$$$0(2);
        }
        return (facet = GwtFacet.getInstance(gwtModule)) != null ? facet.getSdkVersion() : null;
    }

    @Nullable
    public GwtModule findGwtModule() {
        return GwtReferenceUtil.findGwtModule(this.myElement, this.myGwtModulesManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/references/BaseGwtReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlFilesForModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/references/BaseGwtReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGwtVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

