/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.psi;

import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.psi.GwtSourcePathsRefresherProjectComponent;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtLanguageLevelPusher
extends JavaLanguageLevelPusher {
    public static void pushGwtLanguageLevel(@NotNull Project project) {
        if (project == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{new GwtLanguageLevelPusher()});
    }

    public static void updateConfigurationAndPush(Project project, boolean forcePush) {
        GwtSourcePathsRefresherProjectComponent.getInstance(project).enqueueRefreshSourcePathsTask(forcePush);
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        return GwtFacet.isInModuleWithGwtFacet(project, file) && super.acceptsDirectory(file, project);
    }

    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        GwtFacet gwtFacet;
        Module module;
        if (project == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        if (file != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null && (gwtFacet = GwtFacet.getInstance(module)) != null) {
            GwtSourcePathsRefresherProjectComponent component;
            LanguageLevel clientLanguageLevel;
            GwtFacetConfiguration configuration = (GwtFacetConfiguration)gwtFacet.getConfiguration();
            LanguageLevel moduleLanguageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
            if (moduleLanguageLevel != (clientLanguageLevel = configuration.getClientLanguageLevel()) && ((component = GwtSourcePathsRefresherProjectComponent.getInstance(project)).isSourceFile(file) || component.isSuperSourceFile(file))) {
                return clientLanguageLevel;
            }
        }
        return super.getImmediateValue(project, file);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        super.afterRootsChanged(project);
        GwtLanguageLevelPusher.updateConfigurationAndPush(project, false);
    }

    @Nullable
    public String getInconsistencyLanguageLevelMessage(@NotNull String message, @NotNull PsiElement element, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        GwtSourcePathsRefresherProjectComponent sourcePathsComponent;
        VirtualFile virtualFile;
        Project project;
        if (message == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        if (level == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GwtLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        if (GwtFacet.isInModuleWithGwtFacet(project = file.getProject(), virtualFile = file.getVirtualFile()) && ((sourcePathsComponent = GwtSourcePathsRefresherProjectComponent.getInstance(project)).isSourceFile(virtualFile) || sourcePathsComponent.isSuperSourceFile(virtualFile))) {
            return GwtBundle.message("gwt.insufficient.language.level", message);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gwt/psi/GwtLanguageLevelPusher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "pushGwtLanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getImmediateValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "afterRootsChanged";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getInconsistencyLanguageLevelMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

