/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make.report;

import com.intellij.CommonBundle;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.make.report.GenerateCompilerReportDialog;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import icons.GwtStudioIcons;
import java.util.ArrayList;
import java.util.List;

public class GenerateCompileReportAction
extends AnAction {
    public GenerateCompileReportAction() {
        super("Generate GWT Compile Report...", "Run GWT Compiler to produce the Compile Report and open the result in browser", GwtStudioIcons.Google_small);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setVisible(project != null && !ProjectFacetManager.getInstance((Project)project).getFacets(GwtFacetType.ID).isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ArrayList<GwtModule> modules = new ArrayList<GwtModule>();
        for (Module module : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GwtFacetType.ID)) {
            List<GwtModule> gwtModules = GwtModulesManager.getInstance(project).getGwtModules(module, false);
            ContainerUtil.addAll(modules, gwtModules);
        }
        if (modules.isEmpty()) {
            Messages.showErrorDialog((String)"No GWT Modules found in the project", (String)CommonBundle.getErrorTitle());
            return;
        }
        new GenerateCompilerReportDialog(project, modules).show();
    }
}

