/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.jsinject;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.jsinject.JsInjector;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class GwtJsniSmartEnterProcessor
extends SmartEnterProcessor {
    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            GwtJsniSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GwtJsniSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            GwtJsniSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (!(psiFile instanceof PsiJavaFile) || !ProjectFacetManager.getInstance((Project)project).hasFacets(GwtFacetType.ID)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || GwtModulesManager.getInstance(project).findGwtModulesByClientSourceFile(virtualFile).isEmpty()) {
            return false;
        }
        PsiElement element = this.getStatementAtCaret(editor, psiFile);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (method == null || !method.hasModifierProperty("native")) {
            return false;
        }
        if (JsInjector.isJsniMethod(method)) {
            return false;
        }
        Document document = editor.getDocument();
        int endOffset = method.getTextRange().getEndOffset();
        if (StringUtil.endsWithChar((CharSequence)method.getText(), (char)';')) {
            document.deleteString(endOffset - 1, endOffset);
            --endOffset;
        } else {
            PsiElement lastChild = method.getLastChild();
            if (lastChild instanceof PsiComment) {
                String commentText = lastChild.getText();
                for (int i = "/*-{".length(); i >= 1; --i) {
                    if (!commentText.substring(0, i).equals("/*-{".substring(0, i))) continue;
                    endOffset = lastChild.getTextRange().getStartOffset();
                    document.deleteString(endOffset, endOffset + i);
                    break;
                }
            }
        }
        if (document.getCharsSequence().charAt(endOffset - 1) == ' ') {
            document.deleteString(endOffset - 1, endOffset);
            --endOffset;
        }
        String beforeCaret = " /*-{";
        String afterCaret = "\n}-*/;";
        document.insertString(endOffset, (CharSequence)" /*-{\n}-*/;");
        editor.getCaretModel().moveToOffset(endOffset + " /*-{".length());
        this.commit(editor);
        PsiElement newElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        PsiMethod newMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)newElement, PsiMethod.class);
        if (newMethod != null) {
            this.reformat((PsiElement)newMethod);
        }
        EditorActionManager.getInstance().getActionHandler("EditorStartNewLine").execute(editor, ((EditorEx)editor).getDataContext());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/gwt/jsinject/GwtJsniSmartEnterProcessor";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

