/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections.eventListeners;

import com.intellij.gwt.inspections.eventListeners.DeprecatedListener;
import com.intellij.openapi.components.ServiceManager;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DeprecatedEventListenersRegistry {
    private Map<String, DeprecatedListener> myListenersClass2Info;
    private Map<String, DeprecatedListener> myListenerHolder2Info;
    private Set<String> myAddRemoveMethodNames;
    private Set<String> myEventMethodNames;

    public static DeprecatedEventListenersRegistry getInstance() {
        return (DeprecatedEventListenersRegistry)ServiceManager.getService(DeprecatedEventListenersRegistry.class);
    }

    public DeprecatedEventListenersRegistry() {
        DeprecatedListener[] deprecatedListeners = new DeprecatedListener[]{new DeprecatedListener("Click").handler("Click"), new DeprecatedListener("Scroll").handler("Scroll"), new DeprecatedListener("MouseWheel").handler("MouseWheel"), new DeprecatedListener("Focus", "com.google.gwt.user.client.ui.FocusListenerAdapter").handler("Focus").handler("onLostFocus", "onBlur", "com.google.gwt.event.dom.client.BlurHandler", "addBlurHandler"), new DeprecatedListener("Keyboard", "com.google.gwt.user.client.ui.KeyboardListenerAdapter").handler("KeyDown").handler("KeyPress").handler("KeyUp"), new DeprecatedListener("Mouse", "com.google.gwt.user.client.ui.MouseListenerAdapter").handler("MouseDown").handler("MouseUp").handler("MouseMove").handler("MouseEnter").handler("MouseMove")};
        this.myListenersClass2Info = new THashMap();
        this.myListenerHolder2Info = new THashMap();
        this.myAddRemoveMethodNames = new THashSet();
        this.myEventMethodNames = new THashSet();
        for (DeprecatedListener info : deprecatedListeners) {
            this.myListenersClass2Info.put(info.getListenerClass(), info);
            String adapterClass = info.getAdapterClass();
            if (adapterClass != null) {
                this.myListenersClass2Info.put(adapterClass, info);
            }
            this.myListenerHolder2Info.put(info.getListenersHolderClass(), info);
            this.myAddRemoveMethodNames.add(info.getAddListenerMethod());
            this.myAddRemoveMethodNames.add(info.getRemoveListenerMethod());
            this.myEventMethodNames.addAll(info.getMethodNames());
        }
    }

    public boolean isDeprecatedListener(@Nullable String className) {
        return className != null && this.myListenersClass2Info.containsKey(className);
    }

    @Nullable
    public DeprecatedListener findByListenerClass(@Nullable String className) {
        return className != null ? this.myListenersClass2Info.get(className) : null;
    }

    public boolean isAddOrRemoveListenerMethodName(String name) {
        return name != null && this.myAddRemoveMethodNames.contains(name);
    }

    @Nullable
    public DeprecatedListener findByHolderClass(String className) {
        return this.myListenerHolder2Info.get(className);
    }

    public boolean isEventMethodName(@Nullable String name) {
        return name != null && this.myEventMethodNames.contains(name);
    }
}

