/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CreateCssClassLocalQuickFix
extends BaseGwtLocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.CreateCssClassLocalQuickFix");
    private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.css.class", new Object[0]);
    private final SmartPsiElementPointer<PsiElement> myPsiElementPointer;
    private final String myClassName;

    public CreateCssClassLocalQuickFix(@NotNull StylesheetFile stylesheetFile, String className) {
        if (stylesheetFile == null) {
            CreateCssClassLocalQuickFix.$$$reportNull$$$0(0);
        }
        this((PsiElement)stylesheetFile, className);
    }

    public CreateCssClassLocalQuickFix(@NotNull XmlTag xmlTag, String className) {
        if (xmlTag == null) {
            CreateCssClassLocalQuickFix.$$$reportNull$$$0(1);
        }
        this((PsiElement)xmlTag, className);
    }

    private CreateCssClassLocalQuickFix(@NotNull PsiElement psiElement, String className) {
        if (psiElement == null) {
            CreateCssClassLocalQuickFix.$$$reportNull$$$0(2);
        }
        super(GwtBundle.message("quickfix.name.create.css.class.0", className));
        this.myPsiElementPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement);
        this.myClassName = className;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = FAMILY_NAME;
        if (string == null) {
            CreateCssClassLocalQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement;
        if (project == null) {
            CreateCssClassLocalQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            CreateCssClassLocalQuickFix.$$$reportNull$$$0(5);
        }
        if ((psiElement = this.myPsiElementPointer.getElement()) == null) {
            return;
        }
        if (psiElement instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)psiElement;
            List<StylesheetFile> stylesheetFiles = new UiStyleElement(xmlTag).getStylesheetFiles();
            if (stylesheetFiles.isEmpty()) {
                return;
            }
            if (stylesheetFiles.size() == 1) {
                this.applyFix(stylesheetFiles.get(0), project);
            } else {
                Editor editor = PsiUtilBase.findEditor((PsiElement)xmlTag);
                if (editor != null) {
                    StylesheetFile[] cssFilesArray = stylesheetFiles.toArray(StylesheetFile.EMPTY_ARRAY);
                    NavigationUtil.getPsiElementPopup((PsiElement[])cssFilesArray, (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)"Choose CSS file", element -> {
                        if (project == null) {
                            CreateCssClassLocalQuickFix.$$$reportNull$$$0(8);
                        }
                        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                            if (project == null) {
                                CreateCssClassLocalQuickFix.$$$reportNull$$$0(9);
                            }
                            this.applyFix((StylesheetFile)element, project);
                        });
                        return true;
                    }).showInBestPositionFor(editor);
                }
            }
        } else if (psiElement instanceof StylesheetFile) {
            this.applyFix((StylesheetFile)psiElement, project);
        } else {
            LOG.error("StylesheetFile or XmlTag expected. Found: " + psiElement);
        }
    }

    private void applyFix(@NotNull StylesheetFile cssFile, @NotNull Project project) {
        VirtualFile virtualFile;
        if (cssFile == null) {
            CreateCssClassLocalQuickFix.$$$reportNull$$$0(6);
        }
        if (project == null) {
            CreateCssClassLocalQuickFix.$$$reportNull$$$0(7);
        }
        if ((virtualFile = cssFile.getOriginalFile().getVirtualFile()) == null) {
            return;
        }
        if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles()) {
            return;
        }
        try {
            CssStylesheet stylesheet = cssFile.getStylesheet();
            CssRuleset cssRuleset = CssElementFactory.getInstance((Project)project).createRuleset("." + this.myClassName + "{\n\n}\n", cssFile.getLanguage());
            stylesheet.addRuleset(cssRuleset);
            CssRuleset[] rulesets = stylesheet.getRulesets();
            CssRuleset added = rulesets[rulesets.length - 1];
            OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, virtualFile, added.getBlock().getTextOffset());
            FileEditorManager.getInstance((Project)project).openEditor(fileDescriptor, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheetFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$1";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

