/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.i18n;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtI18nManagerImpl
extends GwtI18nManager {
    private static final IProperty[] EMPTY_PROPERTIES_ARRAY = new IProperty[0];
    private static final PropertiesFile[] EMPTY_PROPERTIES_FILE_ARRAY = new PropertiesFile[0];
    private final PsiManager myPsiManager;
    private final Project myProject;

    public GwtI18nManagerImpl(PsiManager psiManager, Project project) {
        this.myProject = project;
        this.myPsiManager = psiManager;
    }

    private boolean isConstantsOrMessagesInterface(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(0);
        }
        if (!GwtFacet.isInModuleWithGwtFacet(this.myProject, GwtI18nManagerImpl.getOriginalContainingFile(aClass).getVirtualFile()) || !aClass.isInterface()) {
            return false;
        }
        return this.isConstantsInterface(aClass) || GwtI18nManagerImpl.isExtendingInterface(aClass, "com.google.gwt.i18n.client.Messages");
    }

    private static boolean isExtendingInterface(PsiClass aClass, String superInterfaceName) {
        return aClass.isInterface() && InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)superInterfaceName);
    }

    @Override
    public boolean isConstantsInterface(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(1);
        }
        return GwtI18nManagerImpl.isExtendingInterface(aClass, "com.google.gwt.i18n.client.Constants");
    }

    @Override
    public boolean isLocalizableInterface(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(2);
        }
        return GwtI18nManagerImpl.isExtendingInterface(aClass, "com.google.gwt.i18n.client.LocalizableResource");
    }

    @Override
    @NotNull
    public PropertiesFile[] getPropertiesFiles(@NotNull PsiClass anInterface) {
        PsiFile containingFile;
        PsiDirectory mainDirectory;
        if (anInterface == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(3);
        }
        if ((mainDirectory = (containingFile = GwtI18nManagerImpl.getOriginalContainingFile(anInterface)).getContainingDirectory()) == null || !this.isConstantsOrMessagesInterface(anInterface)) {
            if (EMPTY_PROPERTIES_FILE_ARRAY == null) {
                GwtI18nManagerImpl.$$$reportNull$$$0(4);
            }
            return EMPTY_PROPERTIES_FILE_ARRAY;
        }
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(mainDirectory);
        if (psiPackage == null) {
            if (EMPTY_PROPERTIES_FILE_ARRAY == null) {
                GwtI18nManagerImpl.$$$reportNull$$$0(5);
            }
            return EMPTY_PROPERTIES_FILE_ARRAY;
        }
        PsiDirectory[] directories = psiPackage.getDirectories(anInterface.getResolveScope());
        ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>();
        for (PsiDirectory directory : directories) {
            for (PsiFile psiFile : directory.getFiles()) {
                String interfaceName;
                PropertiesFile propertiesFile;
                String fileName;
                if (!(psiFile instanceof PropertiesFile) || !GwtI18nManagerImpl.isFileNameForInterfaceName(fileName = (propertiesFile = (PropertiesFile)psiFile).getName(), interfaceName = anInterface.getName())) continue;
                files.add(propertiesFile);
            }
        }
        PropertiesFile[] propertiesFileArray = files.toArray(new PropertiesFile[files.size()]);
        if (propertiesFileArray == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(6);
        }
        return propertiesFileArray;
    }

    private static PsiFile getOriginalContainingFile(PsiClass anInterface) {
        return anInterface.getContainingFile().getOriginalFile();
    }

    private static boolean isFileNameForInterfaceName(@Nullable String fileName, @Nullable String interfaceName) {
        return fileName != null && interfaceName != null && (fileName.equals(interfaceName + "." + StdFileTypes.PROPERTIES.getDefaultExtension()) || StringUtil.startsWithConcatenation((String)fileName, (String[])new String[]{interfaceName, "_"}));
    }

    @Override
    @Nullable
    public PsiClass getPropertiesInterface(@NotNull PropertiesFile file) {
        if (file == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(7);
        }
        String fileName = file.getName();
        PsiDirectory directory = file.getParent();
        GwtFacet facet = GwtFacet.findFacetBySourceFile(this.myProject, file.getVirtualFile());
        if (directory == null || facet == null) {
            return null;
        }
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (psiPackage == null) {
            return null;
        }
        for (PsiClass psiClass : psiPackage.getClasses(GlobalSearchScope.moduleWithDependenciesScope((Module)facet.getModule()))) {
            if (!GwtI18nManagerImpl.isFileNameForInterfaceName(fileName, psiClass.getName()) || !this.isConstantsOrMessagesInterface(psiClass)) continue;
            return psiClass;
        }
        return null;
    }

    @Override
    @NotNull
    public IProperty[] getProperties(@NotNull PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(8);
        }
        if ((aClass = method.getContainingClass()) == null) {
            if (EMPTY_PROPERTIES_ARRAY == null) {
                GwtI18nManagerImpl.$$$reportNull$$$0(9);
            }
            return EMPTY_PROPERTIES_ARRAY;
        }
        PropertiesFile[] files = (PropertiesFile[])ReadAction.compute(() -> this.getPropertiesFiles(aClass));
        if (files.length == 0) {
            if (EMPTY_PROPERTIES_ARRAY == null) {
                GwtI18nManagerImpl.$$$reportNull$$$0(10);
            }
            return EMPTY_PROPERTIES_ARRAY;
        }
        String propertyName = GwtI18nUtil.getPropertyName(method);
        ArrayList<IProperty> properties = new ArrayList<IProperty>();
        for (PropertiesFile file : files) {
            IProperty property = file.findPropertyByKey(propertyName);
            if (property == null) continue;
            properties.add(property);
        }
        IProperty[] iPropertyArray = properties.toArray(new IProperty[properties.size()]);
        if (iPropertyArray == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(11);
        }
        return iPropertyArray;
    }

    @Override
    @Nullable
    public PsiMethod getMethod(@NotNull IProperty property) {
        PsiMethod[] psiMethods;
        PsiClass psiClass;
        if (property == null) {
            GwtI18nManagerImpl.$$$reportNull$$$0(12);
        }
        if ((psiClass = this.getPropertiesInterface(property.getPropertiesFile())) == null) {
            return null;
        }
        String baseName = GwtI18nManagerImpl.getBaseName(property);
        for (PsiMethod psiMethod : psiMethods = psiClass.getMethods()) {
            String propertyName = GwtI18nUtil.getPropertyName(psiMethod);
            if (propertyName == null || !propertyName.equals(baseName)) continue;
            return psiMethod;
        }
        return null;
    }

    @Nullable
    private static String getBaseName(IProperty property) {
        String key = property.getUnescapedKey();
        if (key == null) {
            return null;
        }
        int i = key.indexOf(91);
        return i != -1 ? key.substring(0, i) : key;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/i18n/GwtI18nManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/i18n/GwtI18nManagerImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFiles";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConstantsOrMessagesInterface";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isConstantsInterface";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isLocalizableInterface";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesFiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesInterface";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

