/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class GwtSdkPathEditor {
    private final ComboboxWithBrowseButton myPathEditor = new ComboboxWithBrowseButton();

    public GwtSdkPathEditor(@Nullable Project project) {
        this.myPathEditor.addBrowseFolderListener(GwtBundle.message("gwt.installation.chooser.title", new Object[0]), GwtBundle.message("gwt.installation.chooser.description", new Object[0]), project, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        JComboBox comboBox = this.myPathEditor.getComboBox();
        comboBox.setEditable(true);
        GwtSdkManager.getInstance().removeInvalidSdk();
        for (String path : GwtSdkManager.getInstance().getAllSdkPaths()) {
            comboBox.addItem(path);
        }
    }

    public ComboboxWithBrowseButton getMainComponent() {
        return this.myPathEditor;
    }

    public JComboBox getComboBox() {
        return this.myPathEditor.getComboBox();
    }

    public String getPath() {
        return (String)this.myPathEditor.getComboBox().getEditor().getItem();
    }

    @Nullable
    public GwtSdk getSelectedSdk() {
        if (StringUtil.isEmpty((String)this.getPath())) {
            return null;
        }
        return GwtSdkManager.getInstance().getGwtSdk(this.getUrl());
    }

    public void setPath(String path) {
        this.myPathEditor.getComboBox().setSelectedItem(path);
    }

    public String getUrl() {
        return VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.getPath()));
    }

    public JTextField getPathTextField() {
        return (JTextField)this.getComboBox().getEditor().getEditorComponent();
    }
}

