/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class GwtLibrarySearchingPolicy
extends RootPolicy<Boolean> {
    private final VirtualFile myUserJar;
    private final List<LibraryOrderEntry> myGwtLibraries = new ArrayList<LibraryOrderEntry>();
    private final FacetEditorContext myEditorContext;

    public GwtLibrarySearchingPolicy(FacetEditorContext editorContext, VirtualFile userJar) {
        this.myUserJar = userJar;
        this.myEditorContext = editorContext;
    }

    @Nullable
    public LibraryOrderEntry getGwtLibrary() {
        return this.myGwtLibraries.size() == 1 ? this.myGwtLibraries.get(0) : null;
    }

    public boolean containsLibrary(ModuleRootModel rootModel) {
        Ref contains = Ref.create((Object)false);
        rootModel.orderEntries().using((RootModelProvider)this.myEditorContext.getModulesProvider()).recursively().librariesOnly().forEach(orderEntry -> {
            LibraryOrderEntry libraryOrderEntry;
            Library library;
            if (orderEntry instanceof LibraryOrderEntry && (library = (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getLibrary()) != null) {
                VirtualFile[] files;
                for (VirtualFile file : files = this.myEditorContext.getLibraryFiles(library, OrderRootType.CLASSES)) {
                    if (!file.equals(this.myUserJar)) continue;
                    contains.set((Object)true);
                    return false;
                }
                if (files.length == 1 && LibraryUtil.isClassAvailableInLibrary((VirtualFile[])new VirtualFile[]{files[0]}, (String)"com.google.gwt.core.client.GWT")) {
                    this.myGwtLibraries.add(libraryOrderEntry);
                }
            }
            return true;
        });
        return (Boolean)contains.get();
    }
}

