/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.facet.GwtSampleApplicationCreator;
import com.intellij.gwt.facet.GwtSdkPathEditor;
import com.intellij.gwt.packaging.GwtCompileOutputRelativePathSuggester;
import com.intellij.gwt.packaging.GwtCompilerOutputElement;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.run.GwtRunConfigurationFactory;
import com.intellij.gwt.run.GwtRunConfigurationType;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.framework.JavaeeProjectCategory;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import icons.GwtStudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtFacetFrameworkSupportProvider
extends FrameworkSupportProvider {
    public GwtFacetFrameworkSupportProvider() {
        super(FacetBasedFrameworkSupportProvider.getProviderId(GwtFacetType.ID), GwtBundle.message("framework.title.google.web.toolkit", new Object[0]));
    }

    public String[] getPrecedingFrameworkProviderIds() {
        return new String[]{FacetBasedFrameworkSupportProvider.getProviderId((FacetTypeId)WebFacet.ID)};
    }

    @NotNull
    public FrameworkSupportConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            GwtFacetFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        GwtFrameworkSupportConfigurable gwtFrameworkSupportConfigurable = new GwtFrameworkSupportConfigurable(model);
        if (gwtFrameworkSupportConfigurable == null) {
            GwtFacetFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return gwtFrameworkSupportConfigurable;
    }

    public Icon getIcon() {
        return GwtStudioIcons.Google_small;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            GwtFacetFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        if (facetsProvider == null) {
            GwtFacetFrameworkSupportProvider.$$$reportNull$$$0(3);
        }
        return !facetsProvider.getFacetsByType(module, GwtFacetType.ID).isEmpty();
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            GwtFacetFrameworkSupportProvider.$$$reportNull$$$0(4);
        }
        return moduleType instanceof JavaModuleType;
    }

    public FrameworkRole[] getRoles() {
        return new FrameworkRole[]{JavaeeProjectCategory.ROLE};
    }

    public static void addServletJarToArtifact(ArtifactManager artifactManager, Artifact artifact, GwtSdk gwtSdk) {
        PackagingElement element = PackagingElementFactory.getInstance().createFileCopyWithParentDirectories(FileUtil.toSystemIndependentName((String)gwtSdk.getServletJarPath()), "/");
        artifactManager.addElementsToDirectory(artifact, "/WEB-INF/lib", element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/facet/GwtFacetFrameworkSupportProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/facet/GwtFacetFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportAlreadyAdded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForModuleType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GwtFrameworkSupportConfigurable
    extends FrameworkSupportConfigurable {
        private final GwtSdkPathEditor mySdkPathEditor;
        private JComponent myMainPanel;
        private JPanel mySdkEditorPlace;
        private JCheckBox myCreateSampleAppCheckBox;
        private JTextField myAppNameField;
        private HyperlinkLabel myErrorLabel;
        private final FrameworkSupportModel myModel;

        private GwtFrameworkSupportConfigurable(FrameworkSupportModel model) {
            GwtSdk sdk;
            this.myModel = model;
            this.$$$setupUI$$$();
            this.mySdkPathEditor = new GwtSdkPathEditor(null);
            this.myErrorLabel.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
            this.myErrorLabel.setHyperlinkTarget("http://code.google.com/webtoolkit/download.html");
            Project defaultProject = ProjectManager.getInstance().getDefaultProject();
            String path = ((GwtFacetConfiguration)ProjectFacetManager.getInstance((Project)defaultProject).createDefaultConfiguration((FacetType)GwtFacetType.getInstance())).getGwtSdkPath();
            if (StringUtil.isEmpty((String)path) && (sdk = GwtSdkManager.getInstance().suggestGwtSdk()) != null) {
                path = VfsUtil.urlToPath((String)sdk.getHomeDirectoryUrl());
            }
            this.mySdkPathEditor.setPath(path);
            this.mySdkEditorPlace.add("Center", (Component)this.mySdkPathEditor.getMainComponent());
            this.myCreateSampleAppCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    myAppNameField.setEnabled(myCreateSampleAppCheckBox.isSelected());
                }
            });
            this.mySdkPathEditor.getPathTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    this.checkSdk();
                }
            });
            this.checkSdk();
        }

        public GwtSdkPathEditor getSdkPathEditor() {
            return this.mySdkPathEditor;
        }

        private void checkSdk() {
            String path = this.mySdkPathEditor.getPath();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                this.myErrorLabel.setVisible(true);
                this.myErrorLabel.setHyperlinkText("GWT SDK path not specified. ", "Download GWT", "");
            } else {
                this.myErrorLabel.setVisible(false);
            }
            this.myMainPanel.repaint();
        }

        public void onFrameworkSelectionChanged(boolean selected) {
            this.myAppNameField.setEnabled(selected && this.myCreateSampleAppCheckBox.isSelected());
        }

        public JComponent getComponent() {
            return this.myMainPanel;
        }

        /*
         * WARNING - void declaration
         */
        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
            void var14_17;
            if (module == null) {
                GwtFrameworkSupportConfigurable.$$$reportNull$$$0(0);
            }
            if (rootModel == null) {
                GwtFrameworkSupportConfigurable.$$$reportNull$$$0(1);
            }
            FacetManager facetManager = FacetManager.getInstance((Module)module);
            ModifiableFacetModel facetModel = facetManager.createModifiableModel();
            GwtFacet facet = (GwtFacet)facetManager.createFacet((FacetType)GwtFacetType.getInstance(), GwtFacetType.getInstance().getDefaultFacetName(), null);
            Collection facets = WebFacet.getInstances((Module)facet.getModule());
            WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)facets, null);
            Project project = module.getProject();
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
            Collection<Object> artifacts = Collections.emptyList();
            if (webFacet != null) {
                ((GwtFacetConfiguration)facet.getConfiguration()).setWebFacetName(webFacet.getName());
                PackagingElementResolvingContext context = artifactManager.getResolvingContext();
                artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, context, WebArtifactUtil.getInstance().getWebArtifactTypes(), false);
                for (Artifact artifact : artifacts) {
                    String path = GwtCompileOutputRelativePathSuggester.suggestRelativeOutputPath(this.myModel);
                    artifactManager.addElementsToDirectory(artifact, path, (PackagingElement)new GwtCompilerOutputElement(project, facet));
                }
            }
            facetModel.addFacet((Facet)facet);
            facetModel.commit();
            String sdkUrl = VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.mySdkPathEditor.getPath()));
            GwtSdk gwtSdk = GwtSdkManager.getInstance().getGwtSdk(sdkUrl);
            GwtSdkManager.getInstance().moveToTop(gwtSdk);
            LibrariesContainer librariesContainer = ((FrameworkSupportModelBase)this.myModel).getLibrariesContainer();
            if (!librariesContainer.canCreateLibrary(LibrariesContainer.LibraryLevel.PROJECT)) {
                LibrariesContainer librariesContainer2 = LibrariesContainerFactory.createContainer((Project)module.getProject());
            }
            GwtFacet.setupGwtSdkAndLibraries((GwtFacetConfiguration)facet.getConfiguration(), rootModel, gwtSdk, (LibrariesContainer)var14_17);
            if (this.myCreateSampleAppCheckBox.isSelected()) {
                GwtSampleApplicationCreator creator = new GwtSampleApplicationCreator(facet, this.myAppNameField.getText(), rootModel, this.myModel);
                for (Artifact artifact : artifacts) {
                    GwtFacetFrameworkSupportProvider.addServletJarToArtifact(artifactManager, artifact, gwtSdk);
                }
                GwtRunConfigurationFactory factory = GwtRunConfigurationType.getFactory();
                RunManager runManager = RunManager.getInstance((Project)module.getProject());
                RunnerAndConfigurationSettings runSettings = runManager.createRunConfiguration(creator.getAppName(), (ConfigurationFactory)factory);
                GwtRunConfiguration configuration = (GwtRunConfiguration)runSettings.getConfiguration();
                configuration.setModule(module);
                configuration.setPage(creator.getAppName() + ".html");
                if (gwtSdk.getVersion().isSuperDevModeUsedByDefault()) {
                    configuration.getState().USE_SUPER_DEV_MODE = true;
                }
                runManager.addConfiguration(runSettings, false);
                runManager.setSelectedConfiguration(runSettings);
                creator.create();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootModel";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/facet/GwtFacetFrameworkSupportProvider$GwtFrameworkSupportConfigurable";
            objectArray[2] = "addSupport";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            HyperlinkLabel hyperlinkLabel;
            JTextField jTextField;
            JCheckBox jCheckBox;
            JPanel jPanel;
            JPanel jPanel2 = new JPanel();
            this.myMainPanel = jPanel2;
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            jLabel.setText("GWT SDK:");
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.mySdkEditorPlace = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myCreateSampleAppCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Create sample application");
            jCheckBox.setMnemonic('C');
            jCheckBox.setDisplayedMnemonicIndex(0);
            jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAppNameField = jTextField = new JTextField();
            ((Component)jTextField).setEnabled(true);
            jTextField.setText("com.MySampleApplication");
            jPanel2.add((Component)jTextField, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
            this.myErrorLabel = hyperlinkLabel = new HyperlinkLabel();
            jPanel2.add((Component)hyperlinkLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }
    }
}

