/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.ui.DefaultFacetSettingsEditor;
import com.intellij.gwt.facet.GwtFacetCommonSettingsPanel;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.GwtJavaScriptOutputStyle;

public class DefaultGwtFacetSettingsEditor
extends DefaultFacetSettingsEditor {
    private final GwtFacetConfiguration myConfiguration;
    private final GwtFacetCommonSettingsPanel myPanel;

    public DefaultGwtFacetSettingsEditor(@NotNull Project project, @NotNull GwtFacetConfiguration configuration) {
        if (project == null) {
            DefaultGwtFacetSettingsEditor.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            DefaultGwtFacetSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myConfiguration = configuration;
        this.myPanel = new GwtFacetCommonSettingsPanel(project);
    }

    public JComponent createComponent() {
        return this.myPanel.getMainPanel();
    }

    public void disposeUIResources() {
    }

    public void reset() {
        this.myPanel.getSdkPathEditor().setPath(this.myConfiguration.getGwtSdkPath());
        this.myPanel.getOutputStyleComboBox().setSelectedItem(this.myConfiguration.getOutputStyle());
        this.myPanel.getCompilerHeapSizeField().setText(String.valueOf(this.myConfiguration.getCompilerMaxHeapSize()));
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.setGwtSdkUrlAndType(this.myPanel.getSdkPathEditor().getUrl());
        this.myConfiguration.setOutputStyle(this.getOutputStyle());
        try {
            this.myConfiguration.setCompilerMaxHeapSize(Integer.parseInt(this.myPanel.getCompilerHeapSizeField().getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isModified() {
        return !this.myConfiguration.getGwtSdkPath().equals(this.myPanel.getSdkPathEditor().getPath()) || !this.myConfiguration.getOutputStyle().equals((Object)this.getOutputStyle()) || !String.valueOf(this.myConfiguration.getCompilerMaxHeapSize()).equals(this.myPanel.getCompilerHeapSizeField().getText());
    }

    private GwtJavaScriptOutputStyle getOutputStyle() {
        return (GwtJavaScriptOutputStyle)this.myPanel.getOutputStyleComboBox().getSelectedItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "com/intellij/gwt/facet/DefaultGwtFacetSettingsEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

