/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.codeInsight;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nullable;

public class GwtPatterns {
    private GwtPatterns() {
    }

    public static <T extends PsiElement> ElementPattern<T> inModuleWithGwtFacet(Class<T> aClass) {
        return new ObjectPattern.Capture(new InitialPatternCondition<T>(aClass){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof PsiElement && GwtFacet.findFacetByPsiElement((PsiElement)o) != null;
            }
        });
    }

    public static <T extends PsiElement> ElementPattern<T> inProjectWithGwtFacet(Class<T> aClass) {
        return new ObjectPattern.Capture(new InitialPatternCondition<T>(aClass){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof PsiElement)) {
                    return false;
                }
                PsiElement element = (PsiElement)o;
                return ProjectFacetManager.getInstance((Project)element.getProject()).hasFacets(GwtFacetType.ID);
            }
        });
    }
}

