/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.css;

import com.intellij.gwt.clientBundle.css.language.psi.GwtCssDef;
import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GwtCssDeclarationsManager {
    private static final Key<ParameterizedCachedValue<MultiMap<String, CssElement>, StylesheetFile>> GWT_CSS_DECLARATIONS_KEY = Key.create((String)"GWT_CSS_DECLARATIONS");
    private static final GwtCssDeclarationsProvider DECLARATIONS_PROVIDER = new GwtCssDeclarationsProvider();

    private GwtCssDeclarationsManager() {
    }

    public static void collectCssClasses(CssRuleset cssRuleset, MultiMap<String, ? super CssClass> cssClass2Declaration) {
        for (CssSelector selector : cssRuleset.getSelectors()) {
            for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
                CssSelectorSuffix[] selectorSuffixes;
                for (CssSelectorSuffix suffix : selectorSuffixes = simpleSelector.getSelectorSuffixes()) {
                    if (!(suffix instanceof CssClass)) continue;
                    CssClass cssClass = (CssClass)suffix;
                    cssClass2Declaration.putValue((Object)cssClass.getName(), (Object)cssClass);
                }
            }
        }
    }

    @NotNull
    public static Collection<CssElement> findDeclarations(@NotNull StylesheetFile file, @NotNull String name) {
        if (file == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(1);
        }
        Collection collection = GwtCssDeclarationsManager.getOrCreateDeclarationsMap(file).get((Object)name);
        if (collection == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static <T extends CssElement> Collection<T> findDeclarations(@NotNull StylesheetFile file, @NotNull String name, @NotNull Class<T> aClass) {
        if (file == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(3);
        }
        if (name == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(4);
        }
        if (aClass == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.findAll((Collection)GwtCssDeclarationsManager.getOrCreateDeclarationsMap(file).get((Object)name), aClass);
        if (list == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static <T extends CssElement> void collectDeclarations(@NotNull StylesheetFile file, @NotNull Class<T> aClass, @NotNull MultiMap<String, T> result) {
        if (file == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(7);
        }
        if (aClass == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(8);
        }
        if (result == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(9);
        }
        MultiMap<String, CssElement> declarations = GwtCssDeclarationsManager.getOrCreateDeclarationsMap(file);
        for (String name : declarations.keySet()) {
            for (CssElement element : declarations.get((Object)name)) {
                if (!aClass.isInstance(element)) continue;
                result.putValue((Object)name, aClass.cast(element));
            }
        }
    }

    private static MultiMap<String, CssElement> getOrCreateDeclarationsMap(@NotNull StylesheetFile file) {
        if (file == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(10);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        List<StylesheetFile> stylesheetFiles = GwtCssDeclarationsManager.getAllSourceFiles(file);
        if (stylesheetFiles.size() == 1) {
            return (MultiMap)manager.getParameterizedCachedValue((UserDataHolder)file, GWT_CSS_DECLARATIONS_KEY, (ParameterizedCachedValueProvider)DECLARATIONS_PROVIDER, false, (Object)file);
        }
        MultiMap result = new MultiMap();
        for (StylesheetFile stylesheetFile : stylesheetFiles) {
            result.putAllValues((MultiMap)manager.getParameterizedCachedValue((UserDataHolder)stylesheetFile, GWT_CSS_DECLARATIONS_KEY, (ParameterizedCachedValueProvider)DECLARATIONS_PROVIDER, false, (Object)stylesheetFile));
        }
        return result;
    }

    @NotNull
    private static List<StylesheetFile> getAllSourceFiles(StylesheetFile file) {
        XmlTag styleTag;
        PsiElement context;
        if (file.getVirtualFile() instanceof VirtualFileWindow && (context = file.getContext()) != null && (styleTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class)) != null) {
            List<StylesheetFile> list = new UiStyleElement(styleTag).getStylesheetFiles();
            if (list == null) {
                GwtCssDeclarationsManager.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<StylesheetFile> list = Collections.singletonList(file);
        if (list == null) {
            GwtCssDeclarationsManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclarations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSourceFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarations";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectDeclarations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDeclarationsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GwtCssDeclarationsProvider
    implements ParameterizedCachedValueProvider<MultiMap<String, CssElement>, StylesheetFile> {
        private GwtCssDeclarationsProvider() {
        }

        public CachedValueProvider.Result<MultiMap<String, CssElement>> compute(StylesheetFile param) {
            final MultiMap result = new MultiMap();
            param.accept((PsiElementVisitor)new CssElementVisitor(){

                public void visitCssRuleset(CssRuleset ruleset) {
                    GwtCssDeclarationsManager.collectCssClasses(ruleset, (MultiMap<String, ? super CssClass>)result);
                }

                public void visitElement(PsiElement element) {
                    if (element instanceof GwtCssDef) {
                        GwtCssDef cssDef = (GwtCssDef)element;
                        result.putValue((Object)cssDef.getName(), (Object)cssDef);
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{param});
        }
    }
}

