/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.clientBundle.jam.ClientBundleMethodJamElement;
import com.intellij.gwt.clientBundle.jam.CssResourceClassJamElement;
import com.intellij.gwt.clientBundle.jam.CssResourceMethodJamElement;
import com.intellij.gwt.codeInsight.navigation.GutterIconMultipleNavigationHandler;
import com.intellij.gwt.codeInsight.navigation.MultipleNavigationLineMarkerFactory;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.StylesheetFile;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClientBundleLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public static final GutterIconMultipleNavigationHandler<PsiMethod> RES_METHOD_NAV_HANDLER = new GutterIconMultipleNavigationHandler<PsiMethod>(){

        @Override
        @NotNull
        public String getPopupChooserTitle(PsiMethod source, List<? extends GotoRelatedItem> targets) {
            String string = GwtBundle.message("popup.title.resource.method.goto", source.getName(), targets.size());
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public String getGutterTooltip(PsiMethod source, List<? extends GotoRelatedItem> targets) {
            return GwtBundle.message("tooltip.text.resource.method.gutter", targets.size());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/ClientBundleLineMarkerProvider$1", "getPopupChooserTitle"));
        }
    };
    private static final GutterIconMultipleNavigationHandler<PsiMethod> CSS_METHOD_NAV_HANDLER = new GutterIconMultipleNavigationHandler<PsiMethod>(){

        @Override
        @NotNull
        public String getPopupChooserTitle(PsiMethod source, List<? extends GotoRelatedItem> targets) {
            String string = GwtBundle.message("popup.title.css.class.method.goto", source.getName(), targets.size());
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public String getGutterTooltip(PsiMethod source, List<? extends GotoRelatedItem> targets) {
            if (this.cssClassesOnly(targets)) {
                return GwtBundle.message("tooltip.text.css.class.method.gutter", targets.size());
            }
            return GwtBundle.message("tooltip.text.css.declaration.method.gutter", targets.size());
        }

        private boolean cssClassesOnly(List<? extends GotoRelatedItem> targets) {
            for (GotoRelatedItem gotoRelatedItem : targets) {
                if (gotoRelatedItem.getElement() instanceof CssClass) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/ClientBundleLineMarkerProvider$2", "getPopupChooserTitle"));
        }
    };
    private static final GutterIconMultipleNavigationHandler<PsiClass> CSS_CLASS_NAV_HANDLER = new GutterIconMultipleNavigationHandler<PsiClass>(){

        @Override
        @NotNull
        public String getPopupChooserTitle(PsiClass source, List<? extends GotoRelatedItem> targets) {
            String string = GwtBundle.message("popup.title.css.file.goto", source.getName(), targets.size());
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public String getGutterTooltip(PsiClass source, List<? extends GotoRelatedItem> targets) {
            return GwtBundle.message("tooltip.text.css.file.gutter", targets.size());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/ClientBundleLineMarkerProvider$3", "getPopupChooserTitle"));
        }
    };

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        if (elements == null) {
            ClientBundleLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ClientBundleLineMarkerProvider.$$$reportNull$$$0(1);
        }
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            PsiElement parent = element.getParent();
            if (parent instanceof PsiClass && ((PsiClass)parent).getNameIdentifier() == element) {
                ClientBundleLineMarkerProvider.processClass((PsiClass)parent, (PsiIdentifier)element, result);
                continue;
            }
            if (!(parent instanceof PsiMethod) || ((PsiMethod)parent).getNameIdentifier() != element) continue;
            ClientBundleLineMarkerProvider.processMethod((PsiMethod)parent, (PsiIdentifier)element, result);
        }
    }

    private static void processMethod(PsiMethod method, PsiIdentifier identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
        List<CssElement> declarations;
        CssResourceMethodJamElement methodElement;
        List<PsiFile> files;
        if (identifier == null) {
            return;
        }
        ClientBundleMethodJamElement jamElement = ClientBundleMethodJamElement.getElement(method);
        if (jamElement != null && !(files = jamElement.getSourceFiles(true)).isEmpty()) {
            Icon icon = files.get(0).getIcon(0);
            result.add(MultipleNavigationLineMarkerFactory.create(method, identifier, icon, GotoRelatedItem.createItems(files), RES_METHOD_NAV_HANDLER, 11, false));
        }
        if ((methodElement = CssResourceMethodJamElement.getJamElement(method)) != null && !(declarations = methodElement.findCssElements()).isEmpty()) {
            result.add(MultipleNavigationLineMarkerFactory.create(method, identifier, AllIcons.FileTypes.Css, GotoRelatedItem.createItems(declarations), CSS_METHOD_NAV_HANDLER, 11, true));
        }
    }

    private static void processClass(PsiClass psiClass, PsiIdentifier identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
        Set<StylesheetFile> files;
        CssResourceClassJamElement element = CssResourceClassJamElement.getJamElement(psiClass);
        if (element != null && !(files = element.findStylesheetFiles(true, true)).isEmpty() && identifier != null) {
            result.add(MultipleNavigationLineMarkerFactory.create(psiClass, identifier, AllIcons.FileTypes.Css, GotoRelatedItem.createItems(files), CSS_CLASS_NAV_HANDLER, 11, true));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/gwt/clientBundle/ClientBundleLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

