/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.CommonBundle;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.actions.CreateGwtEventWithHandlerDialog;
import com.intellij.gwt.actions.GwtCreateActionBase;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateGwtEventWithHandlerAction
extends GwtCreateActionBase {
    private final Ref<String> myHandlerClassName = Ref.create(null);
    private final Ref<String> myHandleMethodName = Ref.create(null);

    public CreateGwtEventWithHandlerAction() {
        super(GwtBundle.message("create.gwt.event.with.handler.action.name", new Object[0]), GwtBundle.message("create.gwt.event.with.handler.action.description", new Object[0]));
    }

    @Override
    protected void doCheckBeforeCreate(String newName, PsiDirectory directory) throws IncorrectOperationException {
        super.doCheckBeforeCreate(newName, directory);
        JavaDirectoryService.getInstance().checkCreateClass(directory, (String)this.myHandlerClassName.get());
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)((String)this.myHandleMethodName.get()));
    }

    @Override
    protected void showDialog(@NotNull GwtFacet facet, @NotNull PsiDirectory directory, @NotNull CreateElementActionBase.MyInputValidator validator) {
        if (facet == null) {
            CreateGwtEventWithHandlerAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            CreateGwtEventWithHandlerAction.$$$reportNull$$$0(1);
        }
        if (validator == null) {
            CreateGwtEventWithHandlerAction.$$$reportNull$$$0(2);
        }
        Project project = facet.getModule().getProject();
        if (!facet.getSdkVersion().isEventHandlersSupported()) {
            Messages.showErrorDialog((Project)project, (String)GwtBundle.message("error.message.gwt.event.not.supported", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        CreateGwtEventWithHandlerDialog dialog = new CreateGwtEventWithHandlerDialog(project, this.getDialogTitle(), (InputValidator)validator, this.myHandlerClassName, this.myHandleMethodName);
        dialog.show();
    }

    @Override
    @NotNull
    protected PsiElement[] doCreate(String eventClassName, PsiDirectory directory, GwtModule gwtModule) throws Exception {
        String handlerClassName = (String)this.myHandlerClassName.get();
        String handleMethodName = (String)this.myHandleMethodName.get();
        PsiClass eventClass = CreateGwtEventWithHandlerAction.createClassFromTemplate(directory, eventClassName, (FileType)StdFileTypes.JAVA, "GwtEvent.java", "HANDLER_NAME", handlerClassName, "METHOD_NAME", handleMethodName);
        PsiClass handlerClass = CreateGwtEventWithHandlerAction.createClassFromTemplate(directory, handlerClassName, (FileType)StdFileTypes.JAVA, "GwtEventHandler.java", "EVENT_NAME", eventClassName, "METHOD_NAME", handleMethodName);
        PsiElement[] psiElementArray = new PsiElement[]{eventClass, handlerClass};
        if (psiElementArray == null) {
            CreateGwtEventWithHandlerAction.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    @Override
    protected boolean requireGwtModule() {
        return true;
    }

    @Override
    protected String getDialogPrompt() {
        return GwtBundle.message("label.text.event.class.name", new Object[0]);
    }

    @Override
    protected String getDialogTitle() {
        return GwtBundle.message("dialog.title.create.gwt.event.with.handler", new Object[0]);
    }

    protected String getCommandName() {
        return GwtBundle.message("create.gwt.event.with.handler.command.name", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return GwtBundle.message("action.name.create.gwt.event.with.handler", newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/actions/CreateGwtEventWithHandlerAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/actions/CreateGwtEventWithHandlerAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

