/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.util.repository;

import aQute.bnd.service.RepositoryPlugin;
import aQute.libg.reporter.slf4j.Slf4jReporter;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.nio.file.Files;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Success;

public class DownloadListenerPromise
implements Success<File, Void>,
Failure {
    RepositoryPlugin.DownloadListener[] dls;
    Promise<File> promise;
    private Reporter reporter;
    private String task;
    private File linked;

    public DownloadListenerPromise(Reporter reporter, String task, Promise<File> promise, RepositoryPlugin.DownloadListener ... downloadListeners) {
        this.reporter = Slf4jReporter.getAlternative(DownloadListenerPromise.class, reporter);
        this.task = task;
        this.promise = promise;
        this.dls = downloadListeners;
        reporter.trace("%s: starting", task);
        promise.then(this, this);
    }

    @Override
    public Promise<Void> call(Promise<File> resolved) throws Exception {
        this.reporter.trace("%s: success", this);
        File file = resolved.getValue();
        if (this.linked != null) {
            Files.createLink(this.linked.toPath(), file.toPath());
        }
        for (RepositoryPlugin.DownloadListener dl : this.dls) {
            try {
                dl.success(resolved.getValue());
            }
            catch (Throwable e) {
                this.reporter.warning("%s: Success callback failed to %s: %s", this, dl, e);
            }
        }
        return null;
    }

    @Override
    public void fail(Promise<?> resolved) throws Exception {
        this.reporter.trace("%s: fail: %s", this, resolved.getFailure());
        for (RepositoryPlugin.DownloadListener dl : this.dls) {
            try {
                dl.failure(null, resolved.getFailure().toString());
            }
            catch (Throwable e) {
                this.reporter.warning("%s: Fail callback failed to %s: %s", this, dl, e);
            }
        }
    }

    public String toString() {
        return this.task;
    }

    public void linkTo(File linked) {
        this.linked = linked;
    }
}

