/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.eclipse;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.service.lifecycle.LifeCyclePlugin;
import aQute.lib.io.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@BndPlugin(name="eclipse")
public class EclipsePlugin
extends LifeCyclePlugin {
    @Override
    public void created(Project p) throws IOException {
        Workspace workspace = p.getWorkspace();
        this.copy("project", ".project", p);
        this.copy("classpath", ".classpath", p);
    }

    private void copy(String source, String dest, Project p) throws IOException {
        InputStream in;
        File d = p.getFile(dest);
        if (d.isFile()) {
            return;
        }
        File f = p.getWorkspace().getFile("eclipse/" + source + ".tmpl");
        if (f.isFile()) {
            in = new FileInputStream(f);
        } else {
            in = EclipsePlugin.class.getResourceAsStream(source);
            if (in == null) {
                p.error("Cannot find Eclipse default for %s", source);
                return;
            }
        }
        String s = IO.collect(in);
        String process = p.getReplacer().process(s);
        d.getParentFile().mkdirs();
        IO.store((Object)process, d);
    }

    public String toString() {
        return "EclipsePlugin";
    }

    @Override
    public void init(Workspace ws) throws Exception {
        Project p = new Project(ws, ws.getFile("cnf"));
        this.created(p);
        for (Project pp : ws.getAllProjects()) {
            this.created(pp);
        }
    }
}

