/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.lib.io.IO;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class FileResource
implements Resource,
Closeable {
    static final int BUFFER_SIZE = 65536;
    File file;
    String extra;
    boolean deleteOnClose;

    public FileResource(File file) {
        this.file = file;
    }

    public FileResource(Resource r) throws Exception {
        this.file = File.createTempFile("fileresource", ".resource");
        this.deleteOnClose(true);
        this.file.deleteOnExit();
        IO.copy(r.openInputStream(), this.file);
    }

    @Override
    public InputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public static void build(Jar jar, File directory, Pattern doNotCopy) {
        FileResource.traverse(jar, directory.getAbsolutePath().length(), directory, doNotCopy);
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void write(OutputStream out) throws Exception {
        FileResource.copy(this, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void copy(Resource resource, OutputStream out) throws Exception {
        try (InputStream in = resource.openInputStream();){
            byte[] buffer = new byte[65536];
            int size = in.read(buffer);
            while (size > 0) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
        }
    }

    static void traverse(Jar jar, int rootlength, File directory, Pattern doNotCopy) {
        if (doNotCopy != null && doNotCopy.matcher(directory.getName()).matches()) {
            return;
        }
        jar.updateModified(directory.lastModified(), "Dir change " + directory);
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileResource.traverse(jar, rootlength, files[i], doNotCopy);
                continue;
            }
            String path = files[i].getAbsolutePath().substring(rootlength + 1);
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            jar.putResource(path, new FileResource(files[i]), true);
        }
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public String getExtra() {
        return this.extra;
    }

    @Override
    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public long size() {
        return (int)this.file.length();
    }

    @Override
    public void close() throws IOException {
        if (this.deleteOnClose) {
            this.file.delete();
        }
    }

    public void deleteOnClose(boolean b) {
        this.deleteOnClose = b;
    }

    public File getFile() {
        return this.file;
    }

    protected void finalize() throws Throwable {
        if (this.deleteOnClose) {
            this.file.delete();
        }
        super.finalize();
    }
}

