/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractResource
implements Resource {
    String extra;
    byte[] calculated;
    long lastModified;

    protected AbstractResource(long modified) {
        this.lastModified = modified;
    }

    @Override
    public String getExtra() {
        return this.extra;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.getLocalBytes());
    }

    private byte[] getLocalBytes() throws IOException {
        try {
            if (this.calculated != null) {
                return this.calculated;
            }
            this.calculated = this.getBytes();
            return this.calculated;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ee = new IOException("Opening resource");
            ee.initCause(e);
            throw ee;
        }
    }

    @Override
    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        out.write(this.getLocalBytes());
    }

    protected abstract byte[] getBytes() throws Exception;

    @Override
    public long size() throws IOException {
        return this.getLocalBytes().length;
    }
}

