/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.CircularDependencyException;
import aQute.bnd.build.Container;
import aQute.bnd.build.DownloadBlocker;
import aQute.bnd.build.JUnitLauncher;
import aQute.bnd.build.Makefile;
import aQute.bnd.build.PackageInfo;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.ProjectMessages;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.build.ReflectAction;
import aQute.bnd.build.Run;
import aQute.bnd.build.ScriptAction;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.help.Syntax;
import aQute.bnd.maven.support.Pom;
import aQute.bnd.maven.support.ProjectPom;
import aQute.bnd.osgi.About;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.osgi.eclipse.EclipseClasspath;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.CommandPlugin;
import aQute.bnd.service.DependencyContributor;
import aQute.bnd.service.Deploy;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.Scripter;
import aQute.bnd.service.Strategy;
import aQute.bnd.service.action.Action;
import aQute.bnd.service.action.NamedAction;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.collections.ExtList;
import aQute.lib.converter.Converter;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.command.Command;
import aQute.libg.generics.Create;
import aQute.libg.glob.Glob;
import aQute.libg.qtokens.QuotedTokenizer;
import aQute.libg.reporter.ReporterMessages;
import aQute.libg.sed.Replacer;
import aQute.libg.sed.Sed;
import aQute.libg.tuple.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public class Project
extends Processor {
    static final String DEFAULT_ACTIONS = "build; label='Build', test; label='Test', run; label='Run', clean; label='Clean', release; label='Release', refreshAll; label=Refresh, deploy;label=Deploy";
    public static final String BNDFILE = "bnd.bnd";
    public static final String BNDCNF = "cnf";
    public static final String SHA_256 = "SHA-256";
    final Workspace workspace;
    private final AtomicBoolean preparedPaths = new AtomicBoolean();
    final Collection<Project> dependson = new LinkedHashSet<Project>();
    final Collection<Container> classpath = new LinkedHashSet<Container>();
    final Collection<Container> buildpath = new LinkedHashSet<Container>();
    final Collection<Container> testpath = new LinkedHashSet<Container>();
    final Collection<Container> runpath = new LinkedHashSet<Container>();
    final Collection<Container> runbundles = new LinkedHashSet<Container>();
    final Collection<Container> runfw = new LinkedHashSet<Container>();
    File runstorage;
    final Map<File, Attrs> sourcepath = new LinkedHashMap<File, Attrs>();
    final Collection<File> allsourcepath = new LinkedHashSet<File>();
    final Collection<Container> bootclasspath = new LinkedHashSet<Container>();
    final Map<String, Version> versionMap = new LinkedHashMap<String, Version>();
    File output;
    File target;
    private final AtomicInteger revision = new AtomicInteger();
    File[] files;
    boolean delayRunDependencies = true;
    final ProjectMessages msgs = ReporterMessages.base(this, ProjectMessages.class);
    private Properties ide;
    final Packages exportedPackages = new Packages();
    final Packages importedPackages = new Packages();
    final Packages containedPackages = new Packages();
    final PackageInfo packageInfo = new PackageInfo(this);
    private Makefile makefile;
    private volatile RefreshData data = new RefreshData();
    public Map<String, Container> unreferencedClasspathEntries = new HashMap<String, Container>();
    static String _repoHelp = "${repo ';'<bsn> [ ; <version> [; ('HIGHEST'|'LOWEST')]}";
    static List<String> ignore = new ExtList<String>(BUNDLE_SPECIFIC_HEADERS);

    public Project(Workspace workspace, File unused, File buildFile) throws Exception {
        super(workspace);
        this.workspace = workspace;
        this.setFileMustExist(false);
        if (buildFile != null) {
            this.setProperties(buildFile);
        }
        assert (workspace != null);
        this.readBuildProperties();
    }

    public Project(Workspace workspace, File buildDir) throws Exception {
        this(workspace, buildDir, new File(buildDir, BNDFILE));
    }

    private void readBuildProperties() throws Exception {
        try {
            File f = this.getFile("build.properties");
            if (f.isFile()) {
                Properties p = this.loadProperties(f);
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key;
                    String newkey = key = (String)e.nextElement();
                    if (key.indexOf(36) >= 0) {
                        newkey = this.getReplacer().process(key);
                    }
                    this.setProperty(newkey, p.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Project getUnparented(File propertiesFile) throws Exception {
        propertiesFile = propertiesFile.getAbsoluteFile();
        Workspace workspace = new Workspace(propertiesFile.getParentFile());
        Project project = new Project(workspace, propertiesFile.getParentFile());
        project.setProperties(propertiesFile);
        project.setFileMustExist(true);
        return project;
    }

    public boolean isValid() {
        if (this.getBase() == null || !this.getBase().isDirectory()) {
            return false;
        }
        return this.getPropertiesFile() == null || this.getPropertiesFile().isFile();
    }

    public ProjectBuilder getBuilder(ProjectBuilder parent) throws Exception {
        ProjectBuilder builder = parent == null ? new ProjectBuilder(this) : new ProjectBuilder(parent);
        builder.setBase(this.getBase());
        builder.use(this);
        return builder;
    }

    public int getChanged() {
        return this.revision.get();
    }

    public void setChanged() {
        this.preparedPaths.set(false);
        this.files = null;
        this.revision.getAndIncrement();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public String toString() {
        return this.getBase().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        if (!this.isValid()) {
            this.warning("Invalid project attempts to prepare: %s", this);
            return;
        }
        AtomicBoolean atomicBoolean = this.preparedPaths;
        synchronized (atomicBoolean) {
            if (this.preparedPaths.get()) {
                return;
            }
            if (!this.workspace.trail.add(this)) {
                throw new CircularDependencyException(this.workspace.trail.toString() + "," + this);
            }
            try {
                Parameters srces;
                String prefix = this.getBase().getAbsolutePath();
                this.dependson.clear();
                this.buildpath.clear();
                this.sourcepath.clear();
                this.allsourcepath.clear();
                this.bootclasspath.clear();
                this.testpath.clear();
                this.runpath.clear();
                this.runbundles.clear();
                this.runfw.clear();
                this.setProperty("basedir", this.getBase().getAbsolutePath());
                if (!this.getPropertiesFile().isFile() && new File(this.getBase(), ".classpath").isFile()) {
                    this.doEclipseClasspath();
                }
                if ((srces = new Parameters(this.mergeProperties("src"))).isEmpty()) {
                    srces.add("src", new Attrs());
                }
                for (Map.Entry<String, Attrs> e : srces.entrySet()) {
                    File dir = this.getFile(Project.removeDuplicateMarker(e.getKey()));
                    if (!dir.getAbsolutePath().startsWith(prefix)) {
                        this.error("The source directory lies outside the project %s directory: %s", this, dir).header("src").context(e.getKey());
                        continue;
                    }
                    if (!dir.isDirectory()) {
                        dir.mkdirs();
                    }
                    if (dir.isDirectory()) {
                        this.sourcepath.put(dir, new Attrs(e.getValue()));
                        this.allsourcepath.add(dir);
                        continue;
                    }
                    this.error("the src path (src property) contains an entry that is not a directory %s", dir).header("src").context(e.getKey());
                }
                this.output = this.getSrcOutput().getAbsoluteFile();
                if (!this.output.exists()) {
                    if (!this.output.mkdirs()) {
                        throw new IOException("Could not create directory " + this.output);
                    }
                    this.getWorkspace().changedFile(this.output);
                }
                if (!this.output.isDirectory()) {
                    this.msgs.NoOutputDirectory_(this.output);
                } else {
                    Container c = new Container(this, this.output);
                    if (!this.buildpath.contains(c)) {
                        this.buildpath.add(c);
                    }
                }
                this.target = this.getTarget0();
                String runStorageStr = this.getProperty("-runstorage");
                this.runstorage = runStorageStr != null ? this.getFile(runStorageStr) : null;
                LinkedHashSet<String> requiredProjectNames = new LinkedHashSet<String>(this.getMergedParameters("-dependson").keySet());
                List<DependencyContributor> dcs = this.getPlugins(DependencyContributor.class);
                for (DependencyContributor dc : dcs) {
                    dc.addDependencies(this, requiredProjectNames);
                }
                Instructions is = new Instructions(requiredProjectNames);
                HashSet<Instruction> unused = new HashSet<Instruction>();
                Collection<Project> projects = this.getWorkspace().getAllProjects();
                Collection<Project> dependencies = is.select(projects, unused, false);
                for (Instruction u : unused) {
                    this.msgs.MissingDependson_(u.getInput());
                }
                this.doPath(this.buildpath, dependencies, this.parseBuildpath(), this.bootclasspath, false, "-buildpath");
                this.doPath(this.testpath, dependencies, this.parseTestpath(), this.bootclasspath, false, "-testpath");
                if (!this.delayRunDependencies) {
                    this.doPath(this.runfw, dependencies, this.parseRunFw(), null, false, "-runfw");
                    this.doPath(this.runpath, dependencies, this.parseRunpath(), null, false, "-runpath");
                    this.doPath(this.runbundles, dependencies, this.parseRunbundles(), null, true, "-runbundles");
                }
                HashSet<Project> done = new HashSet<Project>();
                done.add(this);
                for (Project project : dependencies) {
                    project.traverse(this.dependson, done);
                }
                for (Project project : this.dependson) {
                    this.allsourcepath.addAll(project.getSourcePath());
                }
                this.preparedPaths.set(true);
            }
            finally {
                this.workspace.trail.remove(this);
            }
        }
    }

    private File getTarget0() throws IOException {
        File target = this.getTargetDir();
        if (!target.exists()) {
            if (!target.mkdirs()) {
                throw new IOException("Could not create directory " + target);
            }
            this.getWorkspace().changedFile(target);
        }
        return target;
    }

    @Deprecated
    public File getSrc() throws Exception {
        this.prepare();
        if (this.sourcepath.isEmpty()) {
            return this.getFile("src");
        }
        return this.sourcepath.keySet().iterator().next();
    }

    public File getSrcOutput() {
        return this.getFile(this.getProperty("bin"));
    }

    public File getTestSrc() {
        return this.getFile(this.getProperty("testsrc"));
    }

    public File getTestOutput() {
        return this.getFile(this.getProperty("testbin"));
    }

    public File getTargetDir() {
        return this.getFile(this.getProperty("target-dir"));
    }

    private void traverse(Collection<Project> dependencies, Set<Project> visited) throws Exception {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        for (Project project : this.getDependson()) {
            project.traverse(dependencies, visited);
        }
        dependencies.add(this);
    }

    private void doPath(Collection<Container> resultpath, Collection<Project> projects, Collection<Container> entries, Collection<Container> bootclasspath, boolean noproject, String name) {
        for (Container cpe : entries) {
            if (cpe.getError() != null) {
                this.error("%s", cpe.getError()).header(name).context(cpe.getBundleSymbolicName());
                continue;
            }
            if (cpe.getType() == Container.TYPE.PROJECT) {
                projects.add(cpe.getProject());
                if (noproject && this.since(About._2_3) && "project".equals(cpe.getAttributes().get("version"))) {
                    this.error("%s is specified with version=project on %s. This version uses the project's output directory, which is not allowed since it must be an actual JAR file for this list.", cpe.getBundleSymbolicName(), name).header(name).context(cpe.getBundleSymbolicName());
                }
            }
            if (bootclasspath != null && (cpe.getBundleSymbolicName().startsWith("ee.") || cpe.getAttributes().containsKey("boot"))) {
                bootclasspath.add(cpe);
                continue;
            }
            resultpath.add(cpe);
        }
    }

    private List<Container> parseBuildpath() throws Exception {
        List<Container> bundles = this.getBundles(Strategy.LOWEST, this.mergeProperties("-buildpath"), "-buildpath");
        return bundles;
    }

    private List<Container> parseRunpath() throws Exception {
        return this.getBundles(Strategy.HIGHEST, this.mergeProperties("-runpath"), "-runpath");
    }

    private List<Container> parseRunbundles() throws Exception {
        return this.getBundles(Strategy.HIGHEST, this.mergeProperties("-runbundles"), "-runbundles");
    }

    private List<Container> parseRunFw() throws Exception {
        return this.getBundles(Strategy.HIGHEST, this.getProperty("-runfw"), "-runfw");
    }

    private List<Container> parseTestpath() throws Exception {
        return this.getBundles(Strategy.HIGHEST, this.mergeProperties("-testpath"), "-testpath");
    }

    /*
     * Unable to fully structure code
     */
    public List<Container> getBundles(Strategy strategyx, String spec, String source) throws Exception {
        result = new ArrayList<Container>();
        bundles = new Parameters(spec);
        try {
            for (Map.Entry<String, Attrs> entry : bundles.entrySet()) {
                block17: {
                    bsn = Project.removeDuplicateMarker(entry.getKey());
                    attrs = entry.getValue();
                    found = null;
                    versionRange = (String)attrs.get("version");
                    triedGetBundle = false;
                    if (bsn.indexOf(42) >= 0) {
                        return this.getBundlesWildcard(bsn, versionRange, strategyx, attrs);
                    }
                    if (versionRange != null && (versionRange.equals("latest") || versionRange.equals("snapshot"))) {
                        found = this.getBundle(bsn, versionRange, strategyx, attrs);
                        triedGetBundle = true;
                    }
                    if (found != null) break block17;
                    if (versionRange == null || !versionRange.equals("project") && !versionRange.equals("latest")) ** GOTO lbl25
                    project = this.getWorkspace().getProject(bsn);
                    if (project != null && project.exists()) {
                        f = project.getOutput();
                        found = new Container(project, bsn, versionRange, Container.TYPE.PROJECT, f, null, attrs, null);
                    } else {
                        this.msgs.NoSuchProject(bsn, spec).context(bsn).header(source);
                        continue;
lbl25:
                        // 1 sources

                        if (versionRange != null && versionRange.equals("file")) {
                            f = this.getFile(bsn);
                            error = null;
                            if (!f.exists()) {
                                error = "File does not exist: " + f.getAbsolutePath();
                            }
                            found = f.getName().endsWith(".lib") ? new Container(this, bsn, "file", Container.TYPE.LIBRARY, f, error, attrs, null) : new Container(this, bsn, "file", Container.TYPE.EXTERNAL, f, error, attrs, null);
                        } else if (!triedGetBundle) {
                            found = this.getBundle(bsn, versionRange, strategyx, attrs);
                        }
                    }
                }
                if (found != null) {
                    libs = found.getMembers();
                    for (Container cc : libs) {
                        if (result.contains(cc)) {
                            if (!this.isPedantic()) continue;
                            this.warning("Multiple bundles with the same final URL: %s, dropped duplicate", new Object[]{cc});
                            continue;
                        }
                        if (cc.getError() != null) {
                            this.error("Cannot find %s", new Object[]{cc}).context(bsn).header(source);
                        }
                        result.add(cc);
                    }
                    continue;
                }
                x = new Container(this, bsn, versionRange, Container.TYPE.ERROR, null, bsn + ";version=" + versionRange + " not found", attrs, null);
                result.add(x);
                this.error("Can not find URL for bsn %s", new Object[]{bsn}).context(bsn).header(source);
            }
        }
        catch (CircularDependencyException e) {
            message = e.getMessage();
            if (source != null) {
                message = String.format("%s (from property: %s)", new Object[]{message, source});
            }
            this.msgs.CircularDependencyContext_Message_(this.getName(), message);
        }
        catch (Exception e) {
            this.msgs.Unexpected_Error_(spec, e);
        }
        return result;
    }

    Collection<Container> getBundles(Strategy strategy, String spec) throws Exception {
        return this.getBundles(strategy, spec, null);
    }

    public List<Container> getBundlesWildcard(String bsnPattern, String range, Strategy strategyx, Map<String, String> attrs) throws Exception {
        if ("snapshot".equals(range) || "project".equals(range)) {
            return Collections.singletonList(new Container(this, bsnPattern, range, Container.TYPE.ERROR, null, "Cannot use snapshot or project version with wildcard matches", null, null));
        }
        if (strategyx == Strategy.EXACT) {
            return Collections.singletonList(new Container(this, bsnPattern, range, Container.TYPE.ERROR, null, "Cannot use exact version strategy with wildcard matches", null, null));
        }
        VersionRange versionRange = range == null || "latest".equals(range) ? new VersionRange("0") : new VersionRange(range);
        RepoFilter repoFilter = this.parseRepoFilter(attrs);
        if (bsnPattern != null) {
            bsnPattern = bsnPattern.trim();
        }
        if (bsnPattern.length() == 0 || bsnPattern.equals("*")) {
            bsnPattern = null;
        }
        TreeMap<String, Pair<Version, RepositoryPlugin>> providerMap = new TreeMap<String, Pair<Version, RepositoryPlugin>>();
        List<RepositoryPlugin> plugins = this.workspace.getRepositories();
        for (RepositoryPlugin plugin : plugins) {
            List<String> bsns;
            if (repoFilter != null && !repoFilter.match(plugin) || (bsns = plugin.list(bsnPattern)) == null) continue;
            block5: for (String bsn : bsns) {
                SortedSet<Version> versions = plugin.versions(bsn);
                if (versions == null || versions.isEmpty()) continue;
                Pair currentProvider = (Pair)providerMap.get(bsn);
                switch (strategyx) {
                    case HIGHEST: {
                        Version candidate = versions.last();
                        if (currentProvider != null && candidate.compareTo((Version)currentProvider.getFirst()) <= 0) continue block5;
                        providerMap.put(bsn, new Pair<Version, RepositoryPlugin>(candidate, plugin));
                        continue block5;
                    }
                    case LOWEST: {
                        Version candidate = versions.first();
                        if (currentProvider != null && candidate.compareTo((Version)currentProvider.getFirst()) >= 0) continue block5;
                        providerMap.put(bsn, new Pair<Version, RepositoryPlugin>(candidate, plugin));
                        continue block5;
                    }
                }
                throw new IllegalStateException("Cannot use exact version strategy with wildcard matches");
            }
        }
        ArrayList<Container> containers = new ArrayList<Container>(providerMap.size());
        for (Map.Entry entry : providerMap.entrySet()) {
            DownloadBlocker downloadBlocker;
            String bsn = (String)entry.getKey();
            Version version = (Version)((Pair)entry.getValue()).getFirst();
            RepositoryPlugin repo = (RepositoryPlugin)((Pair)entry.getValue()).getSecond();
            File bundle = repo.get(bsn, version, attrs, downloadBlocker = new DownloadBlocker(this));
            if (bundle == null || bundle.getName().endsWith(".lib")) continue;
            containers.add(new Container(this, bsn, range, Container.TYPE.REPO, bundle, null, attrs, downloadBlocker));
        }
        return containers;
    }

    static void mergeNames(String names, Set<String> set) {
        StringTokenizer tokenizer = new StringTokenizer(names, ",");
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken().trim());
        }
    }

    static String flatten(Set<String> names) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (!first) {
                builder.append(',');
            }
            builder.append(name);
            first = false;
        }
        return builder.toString();
    }

    static void addToPackageList(Container container, String newPackageNames) {
        HashSet<String> merged = new HashSet<String>();
        String packageListStr = container.getAttributes().get("packages");
        if (packageListStr != null) {
            Project.mergeNames(packageListStr, merged);
        }
        if (newPackageNames != null) {
            Project.mergeNames(newPackageNames, merged);
        }
        container.putAttribute("packages", Project.flatten(merged));
    }

    public void doMavenPom(Strategy strategyx, List<Container> result, String action) throws Exception {
        File pomFile = this.getFile("pom.xml");
        if (!pomFile.isFile()) {
            this.msgs.MissingPom();
        } else {
            ProjectPom pom = this.getWorkspace().getMaven().createProjectModel(pomFile);
            if (action == null) {
                action = "compile";
            }
            Pom.Scope act = Pom.Scope.valueOf(action);
            Set<Pom> dependencies = pom.getDependencies(act);
            for (Pom sub : dependencies) {
                File artifact = sub.getArtifact();
                Container container = new Container(artifact, null);
                result.add(container);
            }
        }
    }

    public Collection<Project> getDependson() throws Exception {
        this.prepare();
        return this.dependson;
    }

    public Collection<Container> getBuildpath() throws Exception {
        this.prepare();
        return this.buildpath;
    }

    public Collection<Container> getTestpath() throws Exception {
        this.prepare();
        this.justInTime(this.testpath, this.parseTestpath(), false, "-testpath");
        return this.testpath;
    }

    private void justInTime(Collection<Container> path, List<Container> entries, boolean noproject, String name) {
        if (this.delayRunDependencies && path.isEmpty()) {
            this.doPath(path, this.dependson, entries, null, noproject, name);
        }
    }

    public Collection<Container> getRunpath() throws Exception {
        this.prepare();
        this.justInTime(this.runpath, this.parseRunpath(), false, "-runpath");
        return this.runpath;
    }

    public Collection<Container> getRunbundles() throws Exception {
        this.prepare();
        this.justInTime(this.runbundles, this.parseRunbundles(), true, "-runbundles");
        return this.runbundles;
    }

    public Collection<Container> getRunFw() throws Exception {
        this.prepare();
        this.justInTime(this.runfw, this.parseRunFw(), false, "-runfw");
        return this.runfw;
    }

    public File getRunStorage() throws Exception {
        this.prepare();
        return this.runstorage;
    }

    public boolean getRunBuilds() {
        String runBuildsStr = this.getProperty("-runbuilds");
        boolean result = runBuildsStr == null ? !this.getPropertiesFile().getName().toLowerCase().endsWith(".bndrun") : Boolean.parseBoolean(runBuildsStr);
        return result;
    }

    public Collection<File> getSourcePath() throws Exception {
        this.prepare();
        return this.sourcepath.keySet();
    }

    public Collection<File> getAllsourcepath() throws Exception {
        this.prepare();
        return this.allsourcepath;
    }

    public Collection<Container> getBootclasspath() throws Exception {
        this.prepare();
        return this.bootclasspath;
    }

    public File getOutput() throws Exception {
        this.prepare();
        return this.output;
    }

    private void doEclipseClasspath() throws Exception {
        EclipseClasspath eclipse = new EclipseClasspath(this, this.getWorkspace().getBase(), this.getBase());
        eclipse.setRecurse(false);
        for (File dependent : eclipse.getDependents()) {
            Project required = this.workspace.getProject(dependent.getName());
            this.dependson.add(required);
        }
        for (File f : eclipse.getClasspath()) {
            this.buildpath.add(new Container(f, null));
        }
        for (File f : eclipse.getBootclasspath()) {
            this.bootclasspath.add(new Container(f, null));
        }
        for (File f : eclipse.getSourcepath()) {
            this.sourcepath.put(f, new Attrs());
        }
        this.allsourcepath.addAll(eclipse.getAllSources());
        this.output = eclipse.getOutput();
    }

    public String _p_dependson(String[] args) throws Exception {
        return this.list(args, this.toFiles(this.getDependson()));
    }

    private Collection<?> toFiles(Collection<Project> projects) {
        ArrayList<File> files = new ArrayList<File>();
        for (Project p : projects) {
            files.add(p.getBase());
        }
        return files;
    }

    public String _p_buildpath(String[] args) throws Exception {
        return this.list(args, this.getBuildpath());
    }

    public String _p_testpath(String[] args) throws Exception {
        return this.list(args, this.getRunpath());
    }

    public String _p_sourcepath(String[] args) throws Exception {
        return this.list(args, this.getSourcePath());
    }

    public String _p_allsourcepath(String[] args) throws Exception {
        return this.list(args, this.getAllsourcepath());
    }

    public String _p_bootclasspath(String[] args) throws Exception {
        return this.list(args, this.getBootclasspath());
    }

    public String _p_output(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("${output} should not have arguments");
        }
        return this.getOutput().getAbsolutePath();
    }

    private String list(String[] args, Collection<?> list) {
        if (args.length > 3) {
            throw new IllegalArgumentException("${" + args[0] + "[;<separator>]} can only take a separator as argument, has " + Arrays.toString(args));
        }
        String separator = ",";
        if (args.length == 2) {
            separator = args[1];
        }
        return Project.join(list, separator);
    }

    @Override
    protected Object[] getMacroDomains() {
        return new Object[]{this.workspace};
    }

    public File release(String jarName, InputStream jarStream) throws Exception {
        String name = this.getReleaseRepoName(null);
        return this.release(name, jarName, jarStream);
    }

    public URI releaseURI(String jarName, InputStream jarStream) throws Exception {
        String name = this.getReleaseRepoName(null);
        return this.releaseURI(name, jarName, jarStream);
    }

    public File release(String name, String jarName, InputStream jarStream) throws Exception {
        URI uri = this.releaseURI(name, jarName, jarStream);
        if (uri != null && uri.getScheme().equals("file")) {
            return new File(uri);
        }
        return null;
    }

    public URI releaseURI(String name, String jarName, InputStream jarStream) throws Exception {
        if ("".equals(name)) {
            return null;
        }
        this.trace("release to %s", name);
        RepositoryPlugin repo = this.getReleaseRepo(name);
        if (repo == null) {
            if (name == null) {
                this.msgs.NoNameForReleaseRepository();
            } else {
                this.msgs.ReleaseRepository_NotFoundIn_(name, this.getPlugins(RepositoryPlugin.class));
            }
            return null;
        }
        try {
            RepositoryPlugin.PutOptions putOptions = new RepositoryPlugin.PutOptions();
            putOptions.context = this;
            RepositoryPlugin.PutResult r = repo.put(jarStream, putOptions);
            this.trace("Released %s to %s in repository %s", jarName, r.artifact, repo);
            return r.artifact;
        }
        catch (Exception e) {
            this.msgs.Release_Into_Exception_(jarName, repo, e);
            return null;
        }
    }

    RepositoryPlugin getReleaseRepo(String releaserepo) {
        String repoName = this.getReleaseRepoName(releaserepo);
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (repoName == null) {
                return plugin;
            }
            if (!repoName.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    private String getReleaseRepoName(String name) {
        String releaseRepo = name == null ? this.getProperty("-releaserepo") : name;
        Parameters p = new Parameters(releaseRepo);
        if (p.isEmpty()) {
            return null;
        }
        return p.entrySet().iterator().next().getKey();
    }

    public void release(boolean test) throws Exception {
        String name = this.getReleaseRepoName(null);
        this.release(name, test);
    }

    public void release(String name, boolean test) throws Exception {
        this.trace("release", new Object[0]);
        Object[] jars = this.build(test);
        if (jars == null) {
            this.trace("no jars being build", new Object[0]);
            return;
        }
        Parameters repos = new Parameters(name);
        this.trace("releasing %s - %s", Arrays.toString(jars), repos);
        for (Map.Entry<String, Attrs> entry : repos.entrySet()) {
            for (Object jar : jars) {
                this.release(entry.getKey(), ((File)jar).getName(), new BufferedInputStream(new FileInputStream((File)jar)));
            }
        }
    }

    public Container getBundle(String bsn, String range, Strategy strategy, Map<String, String> attrs) throws Exception {
        if (range == null) {
            range = "0";
        }
        if ("snapshot".equals(range) || "project".equals(range)) {
            return this.getBundleFromProject(bsn, attrs);
        }
        if ("hash".equals(range)) {
            return this.getBundleByHash(bsn, attrs);
        }
        Strategy useStrategy = strategy;
        if ("latest".equals(range)) {
            Container c = this.getBundleFromProject(bsn, attrs);
            if (c != null) {
                return c;
            }
            useStrategy = Strategy.HIGHEST;
        }
        useStrategy = this.overrideStrategy(attrs, useStrategy);
        RepoFilter repoFilter = this.parseRepoFilter(attrs);
        List<RepositoryPlugin> plugins = this.workspace.getRepositories();
        if (useStrategy == Strategy.EXACT) {
            if (!Verifier.isVersion(range)) {
                return new Container(this, bsn, range, Container.TYPE.ERROR, null, bsn + ";version=" + range + " Invalid version", null, null);
            }
            Version version = new Version(range);
            for (RepositoryPlugin plugin : plugins) {
                DownloadBlocker blocker;
                File result = plugin.get(bsn, version, attrs, blocker = new DownloadBlocker(this));
                if (result == null) continue;
                return this.toContainer(bsn, range, attrs, result, blocker);
            }
        } else {
            DownloadBlocker blocker;
            Object version;
            VersionRange versionRange = "latest".equals(range) ? new VersionRange("0") : new VersionRange(range);
            TreeMap<Version, RepositoryPlugin> versions = new TreeMap<Version, RepositoryPlugin>();
            for (RepositoryPlugin plugin : plugins) {
                if (repoFilter != null && !repoFilter.match(plugin)) continue;
                try {
                    SortedSet<Version> vs = plugin.versions(bsn);
                    if (vs == null) continue;
                    for (Version v : vs) {
                        if (versions.containsKey(v) || !versionRange.includes(v)) continue;
                        versions.put(v, plugin);
                    }
                }
                catch (UnsupportedOperationException ose) {
                    File file;
                    if (versions.isEmpty() || !Verifier.isVersion(range) || (file = plugin.get(bsn, (Version)(version = new Version(range)), attrs, blocker = new DownloadBlocker(this))) == null) continue;
                    return this.toContainer(bsn, range, attrs, file, blocker);
                }
            }
            SortedSet<Version> localVersions = this.getWorkspace().getWorkspaceRepository().versions(bsn);
            for (Version v : localVersions) {
                if (versions.containsKey(v) || !versionRange.includes(v)) continue;
                versions.put(v, null);
            }
            if (!versions.isEmpty()) {
                Version provider = null;
                switch (useStrategy) {
                    case HIGHEST: {
                        provider = (Version)versions.lastKey();
                        break;
                    }
                    case LOWEST: {
                        provider = (Version)versions.firstKey();
                        break;
                    }
                }
                if (provider != null) {
                    RepositoryPlugin repo = (RepositoryPlugin)versions.get(provider);
                    if (repo == null) {
                        return this.getBundleFromProject(bsn, attrs);
                    }
                    version = provider.toString();
                    blocker = new DownloadBlocker(this);
                    File result = repo.get(bsn, provider, attrs, blocker);
                    if (result != null) {
                        return this.toContainer(bsn, (String)version, attrs, result, blocker);
                    }
                } else {
                    this.msgs.FoundVersions_ForStrategy_ButNoProvider(versions, useStrategy);
                }
            }
        }
        return new Container(this, bsn, range, Container.TYPE.ERROR, null, bsn + ";version=" + range + " Not found in " + plugins, null, null);
    }

    protected Strategy overrideStrategy(Map<String, String> attrs, Strategy useStrategy) {
        String overrideStrategy;
        if (attrs != null && (overrideStrategy = attrs.get("strategy")) != null) {
            if ("highest".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = Strategy.HIGHEST;
            } else if ("lowest".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = Strategy.LOWEST;
            } else if ("exact".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = Strategy.EXACT;
            }
        }
        return useStrategy;
    }

    protected RepoFilter parseRepoFilter(Map<String, String> attrs) {
        if (attrs == null) {
            return null;
        }
        String patternStr = attrs.get("repo");
        if (patternStr == null) {
            return null;
        }
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        QuotedTokenizer tokenize = new QuotedTokenizer(patternStr, ",");
        String token = tokenize.nextToken();
        while (token != null) {
            patterns.add(Glob.toPattern(token));
            token = tokenize.nextToken();
        }
        return new RepoFilter(patterns.toArray(new Pattern[0]));
    }

    protected Container toContainer(String bsn, String range, Map<String, String> attrs, File result, DownloadBlocker db) {
        File f = result;
        if (f == null) {
            this.msgs.ConfusedNoContainerFile();
            f = new File("was null");
        }
        Container container = f.getName().endsWith("lib") ? new Container(this, bsn, range, Container.TYPE.LIBRARY, f, null, attrs, db) : new Container(this, bsn, range, Container.TYPE.REPO, f, null, attrs, db);
        return container;
    }

    private Container getBundleFromProject(String bsn, Map<String, String> attrs) throws Exception {
        String pname = bsn;
        while (true) {
            Project p;
            if ((p = this.getWorkspace().getProject(pname)) != null && p.isValid()) {
                Container c = p.getDeliverable(bsn, attrs);
                return c;
            }
            int n = pname.lastIndexOf(46);
            if (n <= 0) {
                return null;
            }
            pname = pname.substring(0, n);
        }
    }

    private Container getBundleByHash(String bsn, Map<String, String> attrs) throws Exception {
        String hashStr = attrs.get("hash");
        String algo = SHA_256;
        String hash = hashStr;
        int colonIndex = hashStr.indexOf(58);
        if (colonIndex > -1) {
            algo = hashStr.substring(0, colonIndex);
            int afterColon = colonIndex + 1;
            hash = colonIndex < hashStr.length() ? hashStr.substring(afterColon) : "";
        }
        for (RepositoryPlugin plugin : this.workspace.getRepositories()) {
            DownloadBlocker blocker = new DownloadBlocker(this);
            File result = plugin.get(bsn, Version.LOWEST, Collections.unmodifiableMap(attrs), blocker);
            if (result == null && plugin instanceof Repository) {
                Collection<Capability> caps;
                Repository repo = (Repository)((Object)plugin);
                if (!SHA_256.equals(algo)) continue;
                Requirement contentReq = new CapReqBuilder("osgi.content").filter(String.format("(%s=%s)", "osgi.content", hash)).buildSyntheticRequirement();
                Set<Requirement> reqs = Collections.singleton(contentReq);
                Map<Requirement, Collection<Capability>> providers = repo.findProviders(reqs);
                Collection<Capability> collection = caps = providers != null ? providers.get(contentReq) : null;
                if (caps != null && !caps.isEmpty()) {
                    Version bndVersion;
                    Capability cap = caps.iterator().next();
                    ResourceUtils.IdentityCapability idCap = ResourceUtils.getIdentityCapability(cap.getResource());
                    Map<String, Object> idAttrs = idCap.getAttributes();
                    String id = (String)idAttrs.get("osgi.identity");
                    Object version = idAttrs.get("version");
                    Version version2 = bndVersion = version != null ? Version.parseVersion(version.toString()) : Version.LOWEST;
                    if (!bsn.equals(id)) {
                        String error = String.format("Resource with requested hash does not match ID '%s' [hash: %s]", bsn, hashStr);
                        return new Container(this, bsn, "hash", Container.TYPE.ERROR, null, error, null, null);
                    }
                    result = plugin.get(id, bndVersion, null, blocker);
                }
            }
            if (result == null) continue;
            return this.toContainer(bsn, "hash", attrs, result, blocker);
        }
        return new Container(this, bsn, "hash", Container.TYPE.ERROR, null, "Could not find resource by content hash " + hashStr, null, null);
    }

    public void deploy(String name, File file) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        RepositoryPlugin rp = null;
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (name == null) {
                rp = plugin;
                break;
            }
            if (!name.equals(plugin.getName())) continue;
            rp = plugin;
            break;
        }
        if (rp != null) {
            try {
                rp.put(new BufferedInputStream(new FileInputStream(file)), new RepositoryPlugin.PutOptions());
                return;
            }
            catch (Exception e) {
                this.msgs.DeployingFile_On_Exception_(file, rp.getName(), e);
                return;
            }
        }
        this.trace("No repo found %s", file);
        throw new IllegalArgumentException("No repository found for " + file);
    }

    public void deploy(File file) throws Exception {
        String name = this.getProperty("-deployrepo");
        this.deploy(name, file);
    }

    public void deploy() throws Exception {
        File[] outputs;
        Parameters deploy = new Parameters(this.getProperty("-deploy"));
        if (deploy.isEmpty()) {
            this.warning("Deploying but %s is not set to any repo", "-deploy");
            return;
        }
        for (File output : outputs = this.getBuildFiles()) {
            for (Deploy d : this.getPlugins(Deploy.class)) {
                this.trace("Deploying %s to: %s", output.getName(), d);
                try {
                    if (!d.deploy(this, output.getName(), new BufferedInputStream(new FileInputStream(output)))) continue;
                    this.trace("deployed %s successfully to %s", output, d);
                }
                catch (Exception e) {
                    this.msgs.Deploying(e);
                }
            }
        }
    }

    public String _repo(String[] args) throws Exception {
        if (args.length < 2) {
            this.msgs.RepoTooFewArguments(_repoHelp, args);
            return null;
        }
        String bsns = args[1];
        String version = null;
        Strategy strategy = Strategy.HIGHEST;
        if (args.length > 2) {
            version = args[2];
            if (args.length == 4) {
                if (args[3].equalsIgnoreCase("HIGHEST")) {
                    strategy = Strategy.HIGHEST;
                } else if (args[3].equalsIgnoreCase("LOWEST")) {
                    strategy = Strategy.LOWEST;
                } else if (args[3].equalsIgnoreCase("EXACT")) {
                    strategy = Strategy.EXACT;
                } else {
                    this.msgs.InvalidStrategy(_repoHelp, args);
                }
            }
        }
        Collection<String> parts = Project.split(bsns);
        ArrayList<String> paths = new ArrayList<String>();
        for (String bsn : parts) {
            Container container = this.getBundle(bsn, version, strategy, null);
            if (container.getError() != null) {
                this.error("${repo} macro refers to an artifact %s-%s (%s) that has an error: %s", new Object[]{bsn, version, strategy, container.getError()});
                continue;
            }
            this.add(paths, container);
        }
        return Project.join(paths);
    }

    private void add(List<String> paths, Container container) throws Exception {
        if (container.getType() == Container.TYPE.LIBRARY) {
            List<Container> members = container.getMembers();
            for (Container sub : members) {
                this.add(paths, sub);
            }
        } else if (container.getError() == null) {
            paths.add(container.getFile().getAbsolutePath());
        } else {
            paths.add("<<${repo} = " + container.getBundleSymbolicName() + "-" + container.getVersion() + " : " + container.getError() + ">>");
            if (this.isPedantic()) {
                this.warning("Could not expand repo path request: %s ", container);
            }
        }
    }

    public File getTarget() throws Exception {
        this.prepare();
        return this.target;
    }

    public File[] build(boolean underTest) throws Exception {
        if (this.isNoBundles()) {
            return null;
        }
        if (this.getProperty("-nope") != null) {
            this.warning("Please replace -nope with %s", "-nobundles");
            return null;
        }
        if (this.isStale()) {
            this.trace("building %s", this);
            this.files = this.buildLocal(underTest);
            if (this.files != null) {
                this.install(this.files);
            }
        }
        return this.files;
    }

    private void install(File[] files) throws Exception {
        if (files == null) {
            return;
        }
        Parameters p = this.getInstallRepositories();
        for (Map.Entry<String, Attrs> e : p.entrySet()) {
            RepositoryPlugin rp = this.getWorkspace().getRepository(e.getKey());
            if (rp != null) {
                for (File f : files) {
                    this.install(f, rp, e.getValue());
                }
                continue;
            }
            this.warning("No such repository to install into: %s", e.getKey());
        }
    }

    public Parameters getInstallRepositories() {
        if (this.data.installRepositories == null) {
            this.data.installRepositories = new Parameters(this.mergeProperties("-buildrepo"));
        }
        return this.data.installRepositories;
    }

    private void install(File f, RepositoryPlugin repo, Attrs value) throws Exception {
        try (Processor p = new Processor();){
            p.getProperties().putAll((Map<?, ?>)value);
            RepositoryPlugin.PutOptions options = new RepositoryPlugin.PutOptions();
            options.context = p;
            try (FileInputStream in = new FileInputStream(f);){
                repo.put(in, options);
            }
            catch (Exception e) {
                this.exception(e, "Cannot install %s into %s because %s", f, repo.getName(), e);
            }
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public boolean isStale() throws Exception {
        if (this.workspace == null || !this.workspace.hasBndListeners()) {
            this.trace("working %s offline, so always stale", this);
            return true;
        }
        HashSet<Project> visited = new HashSet<Project>();
        return this.isStale(visited);
    }

    boolean isStale(Set<Project> visited) throws Exception {
        if (this.isNoBundles()) {
            return false;
        }
        if (visited.contains(this)) {
            this.msgs.CircularDependencyContext_Message_(this.getName(), visited.toString());
            return false;
        }
        visited.add(this);
        long buildTime = 0L;
        this.files = this.getBuildFiles(false);
        if (this.files == null) {
            return true;
        }
        for (File f : this.files) {
            if (f.lastModified() < this.lastModified()) {
                return true;
            }
            if (buildTime >= f.lastModified()) continue;
            buildTime = f.lastModified();
        }
        for (Project dependency : this.getDependson()) {
            File[] deps;
            if (dependency == this) continue;
            if (dependency.isStale()) {
                return true;
            }
            if (dependency.isNoBundles()) continue;
            for (File f : deps = dependency.getBuildFiles()) {
                if (f.lastModified() < buildTime) continue;
                return true;
            }
        }
        return false;
    }

    public File[] getBuildFiles() throws Exception {
        return this.getBuildFiles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getBuildFiles(boolean buildIfAbsent) throws Exception {
        if (this.files != null) {
            return this.files;
        }
        File f = new File(this.getTarget(), "buildfiles");
        if (f.isFile()) {
            try (BufferedReader rdr = IO.reader(f);){
                List<File> files = this.newList();
                String s = rdr.readLine();
                while (s != null) {
                    File ff = new File(s = s.trim());
                    if (!ff.isFile()) {
                        rdr.close();
                        f.delete();
                        break;
                    }
                    files.add(ff);
                    s = rdr.readLine();
                }
                this.files = files.toArray(new File[0]);
                File[] fileArray = this.files;
                return fileArray;
            }
        }
        if (buildIfAbsent) {
            this.files = this.buildLocal(false);
            return this.files;
        }
        this.files = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] buildLocal(boolean underTest) throws Exception {
        if (this.isNoBundles()) {
            return null;
        }
        this.versionMap.clear();
        this.getMakefile().make();
        boolean tstamp = false;
        if (this.getProperty("_@tstamp") == null) {
            this.setProperty("_@tstamp", Long.toString(System.currentTimeMillis()));
            tstamp = true;
        }
        File bfs = new File(this.getTarget(), "buildfiles");
        bfs.delete();
        this.files = null;
        ProjectBuilder builder = this.getBuilder(null);
        try {
            if (underTest) {
                builder.setProperty("-undertest", "true");
            }
            Jar[] jars = builder.builds();
            File[] files = new File[jars.length];
            this.getInfo(builder);
            if (this.isPedantic() && !this.unreferencedClasspathEntries.isEmpty()) {
                this.warning("Unreferenced class path entries %s", this.unreferencedClasspathEntries.keySet());
            }
            if (this.isOk()) {
                this.files = files;
                for (int i = 0; i < jars.length; ++i) {
                    Jar jar = jars[i];
                    File file = this.saveBuild(jar);
                    if (file == null) {
                        this.getInfo(builder);
                        this.error("Could not save %s", jar.getName());
                        this.files = null;
                        File[] fileArray = null;
                        return fileArray;
                    }
                    this.files[i] = file;
                }
                try (PrintWriter fw = IO.writer(bfs);){
                    for (File f : files) {
                        ((Writer)fw).append(f.getAbsolutePath());
                        ((Writer)fw).append("\n");
                    }
                }
                this.getWorkspace().changedFile(bfs);
                File[] fileArray = files;
                return fileArray;
            }
            File[] fileArray = null;
            return fileArray;
        }
        finally {
            builder.close();
            if (tstamp) {
                this.unsetProperty("_@tstamp");
            }
        }
    }

    public boolean isNoBundles() {
        return Project.isTrue(this.getProperty("-nobundles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveBuild(Jar jar) throws Exception {
        try {
            File f = this.getOutputFile(jar.getBsn(), jar.getVersion());
            String msg = "";
            if (!f.exists() || f.lastModified() < jar.lastModified()) {
                this.reportNewer(f.lastModified(), jar);
                f.delete();
                File fp = f.getParentFile();
                if (!(fp.isDirectory() || fp.exists() || fp.mkdirs())) {
                    throw new IOException("Could not create directory " + fp);
                }
                jar.write(f);
                File canonical = new File(this.getTarget(), jar.getBsn() + ".jar");
                if (!canonical.equals(f)) {
                    IO.delete(canonical);
                    if (!IO.createSymbolicLink(canonical, f)) {
                        IO.copy(f, canonical);
                    }
                    this.getWorkspace().changedFile(canonical);
                }
                this.getWorkspace().changedFile(f);
            } else {
                msg = "(not modified since " + new Date(f.lastModified()) + ")";
            }
            this.trace("%s (%s) %s %s", jar.getName(), f.getName(), jar.getResources().size(), msg);
            File file = f;
            return file;
        }
        finally {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOutputFile(String bsn, String version) throws Exception {
        if (version == null) {
            version = "0";
        }
        try (Processor scoped = new Processor(this);){
            scoped.setProperty("@bsn", bsn);
            scoped.setProperty("@version", version.toString());
            String path = scoped.getProperty("-outputmask", bsn + ".jar");
            File file = IO.getFile(this.getTarget(), path);
            return file;
        }
    }

    public File getOutputFile(String bsn) throws Exception {
        return this.getOutputFile(bsn, "0.0.0");
    }

    private void reportNewer(long lastModified, Jar jar) {
        if (Project.isTrue(this.getProperty("-reportnewer"))) {
            StringBuilder sb = new StringBuilder();
            String del = "Newer than " + new Date(lastModified);
            for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                if (entry.getValue().lastModified() <= lastModified) continue;
                sb.append(del);
                del = ", \n     ";
                sb.append(entry.getKey());
            }
            if (sb.length() > 0) {
                this.warning("%s", sb.toString());
            }
        }
    }

    @Override
    public boolean refresh() {
        this.versionMap.clear();
        this.data = new RefreshData();
        boolean changed = false;
        if (this.isCnf()) {
            changed = this.workspace.refresh();
        }
        return super.refresh() || changed;
    }

    public boolean isCnf() {
        try {
            return this.getBase().getCanonicalPath().equals(this.getWorkspace().getBuildDir().getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void propertiesChanged() {
        super.propertiesChanged();
        this.preparedPaths.set(false);
        this.files = null;
        this.makefile = null;
        this.versionMap.clear();
        this.data = new RefreshData();
    }

    public String getName() {
        return this.getBase().getName();
    }

    public Map<String, Action> getActions() {
        Map<String, Action> all = Project.newMap();
        Map<String, Action> actions = Project.newMap();
        this.fillActions(all);
        this.getWorkspace().fillActions(all);
        for (Map.Entry<String, Action> action : all.entrySet()) {
            String key = this.getReplacer().process(action.getKey());
            if (key == null || key.trim().length() == 0) continue;
            actions.put(key, action.getValue());
        }
        return actions;
    }

    public void fillActions(Map<String, Action> all) {
        List<NamedAction> plugins = this.getPlugins(NamedAction.class);
        for (NamedAction a : plugins) {
            all.put(a.getName(), a);
        }
        Parameters actions = new Parameters(this.getProperty("-actions", DEFAULT_ACTIONS));
        for (Map.Entry<String, Attrs> entry : actions.entrySet()) {
            String key = Processor.removeDuplicateMarker(entry.getKey());
            Action action = entry.getValue().get("script") != null ? new ScriptAction(entry.getValue().get("type"), entry.getValue().get("script")) : new ReflectAction(key);
            String label = entry.getValue().get("label");
            all.put(label.toLowerCase(), action);
        }
    }

    public void release() throws Exception {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String runFilePath, boolean keep, File output) throws Exception {
        this.prepare();
        FileOutputStream outStream = null;
        try {
            Project packageProject;
            if (runFilePath == null || runFilePath.length() == 0 || ".".equals(runFilePath)) {
                packageProject = this;
            } else {
                File runFile = new File(this.getBase(), runFilePath);
                if (!runFile.isFile()) {
                    throw new IOException(String.format("Run file %s does not exist (or is not a file).", runFile.getAbsolutePath()));
                }
                packageProject = new Run(this.getWorkspace(), this.getBase(), runFile);
            }
            packageProject.clear();
            ProjectLauncher launcher = packageProject.getProjectLauncher();
            launcher.setKeep(keep);
            Jar jar = launcher.executable();
            this.getInfo(launcher);
            outStream = new FileOutputStream(output);
            jar.write(outStream);
        }
        catch (Throwable throwable) {
            IO.close(outStream);
            throw throwable;
        }
        IO.close(outStream);
    }

    public void exportRunbundles(String runFilePath, File outputDir) throws Exception {
        Project packageProject;
        this.prepare();
        if (runFilePath == null || runFilePath.length() == 0 || ".".equals(runFilePath)) {
            packageProject = this;
        } else {
            File runFile = new File(this.getBase(), runFilePath);
            if (!runFile.isFile()) {
                throw new IOException(String.format("Run file %s does not exist (or is not a file).", runFile.getAbsolutePath()));
            }
            packageProject = new Run(this.getWorkspace(), this.getBase(), runFile);
        }
        packageProject.clear();
        Collection<Container> runbundles = packageProject.getRunbundles();
        for (Container container : runbundles) {
            File bundle = container.getFile();
            IO.copy(bundle, new File(outputDir, bundle.getName()));
        }
    }

    public void release(String name) throws Exception {
        this.release(name, false);
    }

    public void clean() throws Exception {
        this.clean(this.getTarget(), "target");
        this.clean(this.getSrcOutput(), "source output");
        this.clean(this.getTestOutput(), "test output");
        this.clean(this.getOutput(), "output");
    }

    void clean(File dir, String type) throws IOException {
        if (!dir.exists()) {
            return;
        }
        String basePath = this.getBase().getCanonicalPath();
        String dirPath = dir.getCanonicalPath();
        if (!dirPath.startsWith(basePath)) {
            this.trace("path outside the project dir %s", type);
            return;
        }
        if (dirPath.length() == basePath.length()) {
            this.error("Trying to delete the project directory for %s", type);
            return;
        }
        IO.delete(dir);
        if (dir.exists()) {
            this.error("Trying to delete %s (%s), but failed", dir, type);
            return;
        }
        dir.mkdirs();
    }

    public File[] build() throws Exception {
        return this.build(false);
    }

    private Makefile getMakefile() {
        if (this.makefile == null) {
            this.makefile = new Makefile(this);
        }
        return this.makefile;
    }

    public void run() throws Exception {
        ProjectLauncher pl = this.getProjectLauncher();
        pl.setTrace(this.isTrace() || Project.isTrue(this.getProperty("-runtrace")));
        pl.launch();
    }

    public void runLocal() throws Exception {
        ProjectLauncher pl = this.getProjectLauncher();
        pl.setTrace(this.isTrace() || Project.isTrue(this.getProperty("-runtrace")));
        pl.start(null);
    }

    public void test() throws Exception {
        this.test(null);
    }

    public void test(List<String> tests) throws Exception {
        String testcases = this.getProperties().getProperty("Test-Cases");
        if (testcases == null) {
            this.warning("No %s set", "Test-Cases");
            return;
        }
        this.clear();
        ProjectTester tester = this.getProjectTester();
        if (tests != null) {
            this.trace("Adding tests %s", tests);
            for (String test : tests) {
                tester.addTest(test);
            }
        }
        tester.setContinuous(Project.isTrue(this.getProperty("-testcontinuous")));
        tester.prepare();
        if (!this.isOk()) {
            return;
        }
        int errors = tester.test();
        if (errors == 0) {
            System.err.println("No Errors");
        } else if (errors > 0) {
            System.err.println(errors + " Error(s)");
        } else {
            System.err.println("Error " + errors);
        }
    }

    public void junit() throws Exception {
        JUnitLauncher launcher = new JUnitLauncher(this);
        launcher.launch();
    }

    public Jar getValidJar(File f) throws Exception {
        Jar jar = new Jar(f);
        return this.getValidJar(jar, f.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jar getValidJar(URL url) throws Exception {
        try (InputStream in = url.openStream();){
            Jar jar = new Jar(url.getFile().replace('/', '.'), in, System.currentTimeMillis());
            Jar jar2 = this.getValidJar(jar, url.toString());
            return jar2;
        }
    }

    public Jar getValidJar(Jar jar, String id) throws Exception {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            this.trace("Wrapping with all defaults", new Object[0]);
            Builder b = new Builder(this);
            this.addClose(b);
            b.addClasspath(jar);
            b.setProperty("Bnd-Message", "Wrapped from " + id + "because lacked manifest");
            b.setProperty("Export-Package", "*");
            b.setProperty("Import-Package", "*;resolution:=optional");
            jar = b.build();
        } else if (manifest.getMainAttributes().getValue("Bundle-ManifestVersion") == null) {
            this.trace("Not a release 4 bundle, wrapping with manifest as source", new Object[0]);
            Builder b = new Builder(this);
            this.addClose(b);
            b.addClasspath(jar);
            b.setProperty("Private-Package", "*");
            b.mergeManifest(manifest);
            String imprts = manifest.getMainAttributes().getValue("Import-Package");
            imprts = imprts == null ? "" : imprts + ",";
            imprts = imprts + "*;resolution=optional";
            b.setProperty("Import-Package", imprts);
            b.setProperty("Bnd-Message", "Wrapped from " + id + "because had incomplete manifest");
            jar = b.build();
        }
        return jar;
    }

    public String _project(String[] args) {
        return this.getBase().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bump(String mask) throws Exception {
        String pattern = "(Bundle-Version\\s*(:|=)\\s*)(([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?))";
        String replace = "$1${version;" + mask + ";$3}";
        try {
            if (this.replace(this.getPropertiesFile(), pattern, replace)) {
                return;
            }
            this.trace("no version in bnd.bnd", new Object[0]);
            List<File> included = this.getIncluded();
            if (included != null) {
                ArrayList<File> copy = new ArrayList<File>(included);
                Collections.reverse(copy);
                for (File file : copy) {
                    if (!this.replace(file, pattern, replace)) continue;
                    this.trace("replaced version in file %s", file);
                    return;
                }
            }
            this.trace("no version in included files", new Object[0]);
            boolean found = false;
            for (Builder builder : this.getSubBuilders()) {
                found |= this.replace(builder.getPropertiesFile(), pattern, replace);
            }
            if (!found) {
                this.trace("no version in sub builders, add it to bnd.bnd", new Object[0]);
                String bndfile = IO.collect(this.getPropertiesFile());
                bndfile = bndfile + "\n# Added by by bump\nBundle-Version: 0.0.0\n";
                IO.store((Object)bndfile, this.getPropertiesFile());
            }
        }
        finally {
            this.forceRefresh();
        }
    }

    boolean replace(File f, String pattern, String replacement) throws IOException {
        final Macro macro = this.getReplacer();
        Sed sed = new Sed(new Replacer(){

            @Override
            public String process(String line) {
                return macro.process(line);
            }
        }, f);
        sed.replace(pattern, replacement);
        return sed.doIt() > 0;
    }

    public void bump() throws Exception {
        this.bump(this.getProperty("-bumppolicy", "=+0"));
    }

    public void action(String command) throws Exception {
        this.action(command, new Object[0]);
    }

    public void action(String command, Object ... args) throws Exception {
        Map<String, Action> actions = this.getActions();
        Action a = actions.get(command);
        if (a == null) {
            a = new ReflectAction(command);
        }
        this.before(this, command);
        try {
            if (args.length == 0) {
                a.execute(this, command);
            } else {
                a.execute(this, args);
            }
        }
        catch (Exception t) {
            this.after(this, command, t);
            throw t;
        }
    }

    void before(Project p, String a) {
        List<CommandPlugin> testPlugins = this.getPlugins(CommandPlugin.class);
        for (CommandPlugin testPlugin : testPlugins) {
            testPlugin.before(this, a);
        }
    }

    void after(Project p, String a, Throwable t) {
        List<CommandPlugin> testPlugins = this.getPlugins(CommandPlugin.class);
        for (int i = testPlugins.size() - 1; i >= 0; --i) {
            testPlugins.get(i).after(this, a, t);
        }
    }

    public void refreshAll() {
        this.workspace.refresh();
        this.refresh();
    }

    public void script(String type, String script) throws Exception {
        this.script(type, script, new Object[0]);
    }

    public void script(String type, String script, Object ... args) throws Exception {
        List<Scripter> scripters = this.getPlugins(Scripter.class);
        if (scripters.isEmpty()) {
            this.msgs.NoScripters_(script);
            return;
        }
        UTF8Properties p = new UTF8Properties(this.getProperties());
        for (int i = 0; i < args.length; ++i) {
            p.setProperty("" + i, Converter.cnv(String.class, args[i]));
        }
        scripters.get(0).eval(p, new StringReader(script));
    }

    public String _repos(String[] args) throws Exception {
        List<RepositoryPlugin> repos = this.getPlugins(RepositoryPlugin.class);
        ArrayList<String> names = new ArrayList<String>();
        for (RepositoryPlugin rp : repos) {
            names.add(rp.getName());
        }
        return Project.join(names, ", ");
    }

    public String _help(String[] args) throws Exception {
        if (args.length == 1) {
            return "Specify the option or header you want information for";
        }
        Syntax syntax = Syntax.HELP.get(args[1]);
        if (syntax == null) {
            return "No help for " + args[1];
        }
        String what = null;
        if (args.length > 2) {
            what = args[2];
        }
        if (what == null || what.equals("lead")) {
            return syntax.getLead();
        }
        if (what.equals("example")) {
            return syntax.getExample();
        }
        if (what.equals("pattern")) {
            return syntax.getPattern();
        }
        if (what.equals("values")) {
            return syntax.getValues();
        }
        return "Invalid type specified for help: lead, example, pattern, values";
    }

    public Collection<Container> getDeliverables() throws Exception {
        ArrayList<Container> result = new ArrayList<Container>();
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            Container c = new Container(this, builder.getBsn(), builder.getVersion(), Container.TYPE.PROJECT, this.getOutputFile(builder.getBsn()), null, null, null);
            result.add(c);
        }
        return result;
    }

    public Builder getSubBuilder(File bndFile) throws Exception {
        bndFile = bndFile.getCanonicalFile();
        File base = this.getBase().getCanonicalFile();
        if (!bndFile.getAbsolutePath().startsWith(base.getAbsolutePath())) {
            return null;
        }
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            File propertiesFile = builder.getPropertiesFile();
            if (propertiesFile == null || !propertiesFile.getCanonicalFile().equals(bndFile)) continue;
            return builder;
        }
        return null;
    }

    public ProjectBuilder getSubBuilder(String string) throws Exception {
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            if (!builder.getBsn().equals(string) && !builder.getBsn().endsWith("." + string)) continue;
            return (ProjectBuilder)builder;
        }
        return null;
    }

    public Container getDeliverable(String bsn, Map<String, String> attrs) throws Exception {
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            if (!builder.getBsn().equals(bsn)) continue;
            return new Container(this, this.getOutputFile(bsn, builder.getVersion()), attrs);
        }
        return null;
    }

    public Collection<? extends Builder> getSubBuilders() throws Exception {
        return this.getBuilder(null).getSubBuilders();
    }

    Collection<File> toFile(Collection<Container> containers) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (Container container : containers) {
            container.contributeFiles(files, this);
        }
        return files;
    }

    public Collection<String> getRunVM() {
        Parameters hdr = this.getMergedParameters("-runvm");
        return hdr.keySet();
    }

    public Collection<String> getRunProgramArgs() {
        Parameters hdr = this.getMergedParameters("-runprogramargs");
        return hdr.keySet();
    }

    public Map<String, String> getRunProperties() {
        return OSGiHeader.parseProperties(this.mergeProperties("-runproperties"));
    }

    public ProjectLauncher getProjectLauncher() throws Exception {
        return this.getHandler(ProjectLauncher.class, this.getRunpath(), "Launcher-Plugin", "biz.aQute.launcher");
    }

    public ProjectTester getProjectTester() throws Exception {
        String defaultDefault = this.since(About._3_0) ? "biz.aQute.tester" : "biz.aQute.junit";
        return this.getHandler(ProjectTester.class, this.getTestpath(), "Tester-Plugin", this.getProperty("-tester", defaultDefault));
    }

    private <T> T getHandler(Class<T> target, Collection<Container> containers, String header, String defaultHandler) throws Exception {
        Class<T> handlerClass = target;
        List<Container> withDefault = Create.list();
        withDefault.addAll(containers);
        withDefault.addAll(this.getBundles(Strategy.HIGHEST, defaultHandler, null));
        this.trace("candidates for handler %s: %s", target, withDefault);
        for (Container c : withDefault) {
            Class<?> clz;
            String launcher;
            Manifest manifest = c.getManifest();
            if (manifest == null || (launcher = manifest.getMainAttributes().getValue(header)) == null || (clz = this.getClass(launcher, c.getFile())) == null) continue;
            if (!target.isAssignableFrom(clz)) {
                this.msgs.IncompatibleHandler_For_(launcher, defaultHandler);
                continue;
            }
            this.trace("found handler %s from %s", defaultHandler, c);
            handlerClass = clz.asSubclass(target);
            try {
                Constructor<T> constructor = handlerClass.getConstructor(Project.class, Container.class);
                return constructor.newInstance(this, c);
            }
            catch (Exception e) {
                Constructor<T> constructor = handlerClass.getConstructor(Project.class);
                return constructor.newInstance(this);
            }
        }
        throw new IllegalArgumentException("Default handler for " + header + " not found in " + defaultHandler);
    }

    public void setDelayRunDependencies(boolean x) {
        this.delayRunDependencies = x;
    }

    public void addClasspath(File f) {
        if (!f.isFile() && !f.isDirectory()) {
            this.msgs.AddingNonExistentFileToClassPath_(f);
        }
        Container container = new Container(f, null);
        this.classpath.add(container);
    }

    public void clearClasspath() {
        this.classpath.clear();
        this.unreferencedClasspathEntries.clear();
    }

    public Collection<Container> getClasspath() {
        return this.classpath;
    }

    public Jar pack(String profile) throws Exception {
        Collection<? extends Builder> subBuilders = this.getSubBuilders();
        if (subBuilders.size() != 1) {
            this.error("Project has multiple bnd files, please select one of the bnd files", new Object[0]).header("-export").context(profile);
            return null;
        }
        Builder b = subBuilders.iterator().next();
        ignore.remove("Bundle-SymbolicName");
        ignore.remove("Bundle-Version");
        ignore.add("Service-Component");
        ProjectLauncher launcher = this.getProjectLauncher();
        launcher.getRunProperties().put("profile", profile);
        launcher.getRunProperties().put("-profile", profile);
        Jar jar = launcher.executable();
        Manifest m = jar.getManifest();
        Attributes main = m.getMainAttributes();
        for (String key : this.getPropertyKeys(true)) {
            if (!Character.isUpperCase(key.charAt(0)) || ignore.contains(key)) continue;
            main.putValue(key, this.getProperty(key));
        }
        if (main.getValue("Bundle-SymbolicName") == null) {
            main.putValue("Bundle-SymbolicName", b.getBsn());
        }
        if (main.getValue("Bundle-SymbolicName") == null) {
            main.putValue("Bundle-SymbolicName", this.getName());
        }
        if (main.getValue("Bundle-Version") == null) {
            main.putValue("Bundle-Version", Version.LOWEST.toString());
            this.warning("No version set, uses 0.0.0", new Object[0]);
        }
        jar.setManifest(m);
        jar.calcChecksums(new String[]{"SHA1", "MD5"});
        return jar;
    }

    public void baseline() throws Exception {
        ProjectBuilder b = this.getBuilder(null);
        for (Builder pb : b.getSubBuilders()) {
            ProjectBuilder ppb = (ProjectBuilder)pb;
            Jar build = ppb.build();
            this.getInfo(ppb);
        }
        this.getInfo(b);
    }

    public void verifyDependencies(boolean test) throws Exception {
        this.verifyDependencies("-runbundles", this.getRunbundles());
        this.verifyDependencies("-runpath", this.getRunpath());
        if (test) {
            this.verifyDependencies("-testpath", this.getTestpath());
        }
        this.verifyDependencies("-buildpath", this.getBuildpath());
    }

    private void verifyDependencies(String title, Collection<Container> path) throws Exception {
        ArrayList<String> msgs = new ArrayList<String>();
        for (Container c : new ArrayList<Container>(path)) {
            for (Container cc : c.getMembers()) {
                if (cc.getError() != null) {
                    msgs.add(cc + " - " + cc.getError());
                    continue;
                }
                if (cc.getFile().isFile() || cc.getFile().equals(cc.getProject().getOutput()) || cc.getFile().equals(cc.getProject().getTestOutput())) continue;
                msgs.add(cc + " file does not exists: " + cc.getFile());
            }
        }
        if (msgs.isEmpty()) {
            return;
        }
        this.error("%s: has errors: %s", title, Strings.join(msgs));
    }

    @Override
    public void report(Map<String, Object> table) throws Exception {
        super.report(table);
        this.report(table, true);
    }

    protected void report(Map<String, Object> table, boolean isProject) throws Exception {
        if (isProject) {
            table.put("Target", this.getTarget());
            table.put("Source", this.getSrc());
            table.put("Output", this.getOutput());
            File[] buildFiles = this.getBuildFiles();
            if (buildFiles != null) {
                table.put("BuildFiles", Arrays.asList(buildFiles));
            }
            table.put("Classpath", this.getClasspath());
            table.put("Actions", this.getActions());
            table.put("AllSourcePath", this.getAllsourcepath());
            table.put("BootClassPath", this.getBootclasspath());
            table.put("BuildPath", this.getBuildpath());
            table.put("Deliverables", this.getDeliverables());
            table.put("DependsOn", this.getDependson());
            table.put("SourcePath", this.getSourcePath());
        }
        table.put("RunPath", this.getRunpath());
        table.put("TestPath", this.getTestpath());
        table.put("RunProgramArgs", this.getRunProgramArgs());
        table.put("RunVM", this.getRunVM());
        table.put("Runfw", this.getRunFw());
        table.put("Runbundles", this.getRunbundles());
    }

    public void compile(boolean test) throws Exception {
        Command javac = this.getCommonJavac(false);
        javac.add("-d", this.getOutput().getAbsolutePath());
        StringBuilder buildpath = new StringBuilder();
        String buildpathDel = "";
        List<Container> bp = Container.flatten(this.getBuildpath());
        this.trace("buildpath %s", this.getBuildpath());
        for (Container c : bp) {
            buildpath.append(buildpathDel).append(c.getFile().getAbsolutePath());
            buildpathDel = File.pathSeparator;
        }
        if (buildpath.length() != 0) {
            javac.add("-classpath", buildpath.toString());
        }
        ArrayList<File> sp = new ArrayList<File>(this.getAllsourcepath());
        StringBuilder sourcepath = new StringBuilder();
        String sourcepathDel = "";
        for (File sourceDir : sp) {
            sourcepath.append(sourcepathDel).append(sourceDir.getAbsolutePath());
            sourcepathDel = File.pathSeparator;
        }
        javac.add("-sourcepath", sourcepath.toString());
        Glob javaFiles = new Glob("*.java");
        List<File> files = javaFiles.getFiles(this.getSrc(), true, false);
        for (File file : files) {
            javac.add(file.getAbsolutePath());
        }
        if (files.isEmpty()) {
            this.trace("Not compiled, no source files", new Object[0]);
        } else {
            this.compile(javac, "src");
        }
        if (test) {
            javac = this.getCommonJavac(true);
            javac.add("-d", this.getTestOutput().getAbsolutePath());
            List<Container> tp = Container.flatten(this.getTestpath());
            for (Container c : tp) {
                buildpath.append(buildpathDel).append(c.getFile().getAbsolutePath());
                buildpathDel = File.pathSeparator;
            }
            if (buildpath.length() != 0) {
                javac.add("-classpath", buildpath.toString());
            }
            sourcepath.append(sourcepathDel).append(this.getTestSrc().getAbsolutePath());
            javac.add("-sourcepath", sourcepath.toString());
            javaFiles.getFiles(this.getTestSrc(), files, true, false);
            for (File file : files) {
                javac.add(file.getAbsolutePath());
            }
            if (files.isEmpty()) {
                this.trace("Not compiled for test, no test src files", new Object[0]);
            } else {
                this.compile(javac, "test");
            }
        }
    }

    private void compile(Command javac, String what) throws Exception {
        this.trace("compile %s %s", what, javac);
        StringBuilder stdout = new StringBuilder();
        StringBuilder stderr = new StringBuilder();
        int n = javac.execute(stdout, stderr);
        this.trace("javac stdout: %s", stdout);
        this.trace("javac stderr: %s", stderr);
        if (n != 0) {
            this.error("javac failed %s", stderr);
        }
    }

    private Command getCommonJavac(boolean test) throws Exception {
        Command javac = new Command();
        javac.add(this.getProperty("javac", "javac"));
        String target = this.getProperty("javac.target", "1.6");
        String profile = this.getProperty("javac.profile", "");
        String source = this.getProperty("javac.source", "1.6");
        String debug = this.getProperty("javac.debug");
        if ("on".equalsIgnoreCase(debug) || "true".equalsIgnoreCase(debug)) {
            debug = "vars,source,lines";
        }
        Parameters options = new Parameters(this.getProperty("java.options"));
        boolean deprecation = Project.isTrue(this.getProperty("java.deprecation"));
        javac.add("-encoding", "UTF-8");
        javac.add("-source", source);
        javac.add("-target", target);
        if (!profile.isEmpty()) {
            javac.add("-profile", profile);
        }
        if (deprecation) {
            javac.add("-deprecation");
        }
        if (test || debug == null) {
            javac.add("-g:source,lines,vars" + debug);
        } else {
            javac.add("-g:" + debug);
        }
        for (String option : options.keySet()) {
            javac.add(option);
        }
        StringBuilder bootclasspath = new StringBuilder();
        String bootclasspathDel = "-Xbootclasspath/p:";
        List<Container> bcp = Container.flatten(this.getBootclasspath());
        for (Container c : bcp) {
            bootclasspath.append(bootclasspathDel).append(c.getFile().getAbsolutePath());
            bootclasspathDel = File.pathSeparator;
        }
        if (bootclasspath.length() != 0) {
            javac.add(bootclasspath.toString());
        }
        return javac;
    }

    public String _ide(String[] args) throws IOException {
        String deflt;
        if (args.length < 2) {
            this.error("The ${ide;<>} macro needs an argument", new Object[0]);
            return null;
        }
        if (this.ide == null) {
            this.ide = new UTF8Properties();
            File file = this.getFile(".settings/org.eclipse.jdt.core.prefs");
            if (!file.isFile()) {
                this.error("The ${ide;<>} macro requires a .settings/org.eclipse.jdt.core.prefs file in the project", new Object[0]);
                return null;
            }
            FileInputStream in = new FileInputStream(file);
            this.ide.load(in);
        }
        String string = deflt = args.length > 2 ? args[2] : null;
        if ("javac.target".equals(args[1])) {
            return this.ide.getProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform", deflt);
        }
        if ("javac.source".equals(args[1])) {
            return this.ide.getProperty("org.eclipse.jdt.core.compiler.source", deflt);
        }
        return null;
    }

    public Map<String, Version> getVersions() throws Exception {
        if (this.versionMap.isEmpty()) {
            for (Builder builder : this.getSubBuilders()) {
                String v = builder.getVersion();
                if (v == null) {
                    v = "0";
                } else if (!Verifier.isVersion(v = Analyzer.cleanupVersion(v))) continue;
                Version version = new Version(v);
                this.versionMap.put(builder.getBsn(), version);
            }
        }
        return new LinkedHashMap<String, Version>(this.versionMap);
    }

    public Collection<String> getBsns() throws Exception {
        return new ArrayList<String>(this.getVersions().keySet());
    }

    public Version getVersion(String bsn) throws Exception {
        Version version = this.getVersions().get(bsn);
        if (version == null) {
            throw new IllegalArgumentException("Bsn " + bsn + " does not exist in project " + this.getName());
        }
        return version;
    }

    public Packages getExports() {
        return this.exportedPackages;
    }

    public Packages getImports() {
        return this.importedPackages;
    }

    public Packages getContained() {
        return this.containedPackages;
    }

    public void remove() throws Exception {
        this.getWorkspace().removeProject(this);
        IO.delete(this.getBase());
    }

    public boolean getRunKeep() {
        return this.is("-runkeep");
    }

    public void setPackageInfo(String packageName, Version newVersion) throws Exception {
        this.packageInfo.setPackageInfo(packageName, newVersion);
    }

    public Version getPackageInfo(String packageName) throws Exception {
        return this.packageInfo.getPackageInfo(packageName);
    }

    private static class RepoFilter {
        private Pattern[] patterns;

        RepoFilter(Pattern[] patterns) {
            this.patterns = patterns;
        }

        boolean match(RepositoryPlugin repo) {
            if (this.patterns == null) {
                return true;
            }
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(repo.getName()).matches()) continue;
                return true;
            }
            return false;
        }
    }

    static class RefreshData {
        Parameters installRepositories;

        RefreshData() {
        }
    }
}

