/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.service.progress.ProgressPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LoggingProgressPlugin
implements ProgressPlugin {
    private static final Logger logger = LoggerFactory.getLogger(LoggingProgressPlugin.class);
    private static final Marker LIFECYCLE;

    @Override
    public ProgressPlugin.Task startTask(String name, int size) {
        if (LIFECYCLE != null) {
            logger.info(LIFECYCLE, name);
        } else {
            logger.info(name);
        }
        return new ProgressPlugin.Task(){

            @Override
            public void done(String message, Throwable e) {
                if (e != null) {
                    logger.error(message, e);
                }
            }

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void worked(int units) {
            }
        };
    }

    static {
        Marker lifecycle = null;
        try {
            Class<?> logging = Class.forName("org.gradle.api.logging.Logging");
            lifecycle = (Marker)logging.getField("LIFECYCLE").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LIFECYCLE = lifecycle;
    }
}

