/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.tools.sherpa.scout.Direction;
import com.android.tools.sherpa.scout.Scout;
import com.android.tools.sherpa.scout.ScoutWidget;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class ScoutArrange {
    static Comparator<ConstraintWidget> sSortY = (w1, w2) -> w1.getY() - w2.getY();
    static Comparator<ConstraintWidget> sSortX = (w1, w2) -> w1.getX() - w2.getX();

    public static void align(Scout.Arrange type, ArrayList<ConstraintWidget> widgetList, boolean applyConstraints) {
        if (widgetList == null || widgetList.size() == 0) {
            return;
        }
        int margin = Scout.getMargin();
        ConstraintWidget widgets = new ConstraintWidget[widgetList.size()];
        widgets = widgetList.toArray((T[])widgets);
        switch (type) {
            case AlignHorizontallyCenter: 
            case AlignHorizontallyLeft: 
            case AlignHorizontallyRight: {
                Arrays.sort(widgets, sSortY);
                if (ScoutArrange.rootDistance(widgets[0]) <= ScoutArrange.rootDistance(widgets[((ConstraintWidget[])widgets).length - 1])) break;
                ScoutArrange.reverse((ConstraintWidget[])widgets);
                break;
            }
            case DistributeVertically: {
                Arrays.sort(widgets, sSortY);
                break;
            }
            case AlignVerticallyTop: 
            case AlignVerticallyMiddle: 
            case AlignBaseline: 
            case AlignVerticallyBottom: {
                Arrays.sort(widgets, sSortX);
                if (ScoutArrange.rootDistance(widgets[0]) <= ScoutArrange.rootDistance(widgets[((ConstraintWidget[])widgets).length - 1])) break;
                ScoutArrange.reverse((ConstraintWidget[])widgets);
                break;
            }
            case DistributeHorizontally: {
                Arrays.sort(widgets, sSortX);
            }
        }
        switch (type) {
            case CenterHorizontally: {
                Rectangle rectangle = new Rectangle();
                WidgetContainer parent = (WidgetContainer)widgets[0].getParent();
                ConstraintWidget[] pears = new ConstraintWidget[parent.getChildren().size()];
                pears = parent.getChildren().toArray(pears);
                for (ConstraintWidget widget : widgets) {
                    rectangle.x = widget.getX();
                    rectangle.y = widget.getY();
                    rectangle.width = widget.getWidth();
                    rectangle.height = widget.getHeight();
                    int westDistance = ScoutArrange.gap(Direction.WEST, rectangle, pears);
                    int eastDistance = ScoutArrange.gap(Direction.EAST, rectangle, pears);
                    int x = widget.getX();
                    if (applyConstraints) {
                        ConstraintWidget westConnect = ScoutArrange.gapWidget(Direction.WEST, rectangle, pears);
                        ConstraintWidget eastConnect = ScoutArrange.gapWidget(Direction.EAST, rectangle, pears);
                        ConstraintAnchor.Type dir = ConstraintAnchor.Type.RIGHT;
                        if (westConnect == parent) {
                            dir = ConstraintAnchor.Type.LEFT;
                        }
                        widget.connect(ConstraintAnchor.Type.LEFT, westConnect, dir, 0);
                        dir = ConstraintAnchor.Type.LEFT;
                        if (eastConnect == parent) {
                            dir = ConstraintAnchor.Type.RIGHT;
                        }
                        widget.connect(ConstraintAnchor.Type.RIGHT, eastConnect, dir, 0);
                        widget.setHorizontalBiasPercent(0.5f);
                        continue;
                    }
                    widget.setX(x + (eastDistance - westDistance) / 2);
                }
                break;
            }
            case CenterVertically: {
                Rectangle rectangle = new Rectangle();
                WidgetContainer parent = (WidgetContainer)widgets[0].getParent();
                ConstraintWidget[] pears = new ConstraintWidget[parent.getChildren().size()];
                pears = parent.getChildren().toArray(pears);
                for (ConstraintWidget widget : widgets) {
                    rectangle.x = widget.getX();
                    rectangle.y = widget.getY();
                    rectangle.width = widget.getWidth();
                    rectangle.height = widget.getHeight();
                    int northDistance = ScoutArrange.gap(Direction.NORTH, rectangle, pears);
                    int southDistance = ScoutArrange.gap(Direction.SOUTH, rectangle, pears);
                    int Y = widget.getY();
                    if (applyConstraints) {
                        ConstraintWidget northConnect = ScoutArrange.gapWidget(Direction.NORTH, rectangle, pears);
                        ConstraintWidget southConnect = ScoutArrange.gapWidget(Direction.SOUTH, rectangle, pears);
                        ConstraintAnchor.Type dir = ConstraintAnchor.Type.BOTTOM;
                        if (northConnect == parent) {
                            dir = ConstraintAnchor.Type.TOP;
                        }
                        widget.connect(ConstraintAnchor.Type.TOP, northConnect, dir, 0);
                        dir = ConstraintAnchor.Type.TOP;
                        if (southConnect == parent) {
                            dir = ConstraintAnchor.Type.BOTTOM;
                        }
                        widget.connect(ConstraintAnchor.Type.BOTTOM, southConnect, dir, 0);
                        widget.setVerticalBiasPercent(0.5f);
                        continue;
                    }
                    widget.setY(Y + (southDistance - northDistance) / 2);
                }
                break;
            }
            case CenterHorizontallyInParent: {
                for (ConstraintWidget widget : widgets) {
                    int parentWidth = widget.getParent().getWidth();
                    int width = widget.getWidth();
                    widget.setX((parentWidth - width) / 2);
                    if (!applyConstraints) continue;
                    widget.connect(ConstraintAnchor.Type.CENTER_X, widget.getParent(), ConstraintAnchor.Type.CENTER_X, 0);
                    widget.setHorizontalBiasPercent(0.5f);
                }
                break;
            }
            case CenterVerticallyInParent: {
                for (ConstraintWidget widget : widgets) {
                    int parentHeight = widget.getParent().getHeight();
                    int height = widget.getHeight();
                    widget.setY((parentHeight - height) / 2);
                    if (!applyConstraints) continue;
                    widget.connect(ConstraintAnchor.Type.CENTER_Y, widget.getParent(), ConstraintAnchor.Type.CENTER_Y, 0);
                    widget.setVerticalBiasPercent(0.5f);
                }
                break;
            }
            case AlignHorizontallyCenter: {
                int count = 0;
                float avg = 0.0f;
                for (ConstraintWidget widget : widgets) {
                    avg += (float)widget.getX() + (float)widget.getWidth() / 2.0f;
                    ++count;
                }
                avg /= (float)count;
                ConstraintWidget previousWidget = null;
                for (ConstraintWidget widget : widgets) {
                    float current = (float)widget.getWidth() / 2.0f;
                    widget.setX((int)(avg - current));
                    if (applyConstraints && previousWidget != null) {
                        widget.connect(ConstraintAnchor.Type.CENTER_X, previousWidget, ConstraintAnchor.Type.CENTER_X, 0);
                    }
                    previousWidget = widget;
                }
                break;
            }
            case AlignHorizontallyLeft: {
                int min = Integer.MAX_VALUE;
                for (ConstraintWidget widget : widgets) {
                    min = Math.min(min, widget.getX());
                }
                ConstraintWidget previousWidget = null;
                for (ConstraintWidget widget : widgets) {
                    widget.setX(min);
                    if (applyConstraints && previousWidget != null) {
                        widget.resetAnchor(widget.getAnchor(ConstraintAnchor.Type.RIGHT));
                        widget.connect(ConstraintAnchor.Type.LEFT, previousWidget, ConstraintAnchor.Type.LEFT, 0);
                    }
                    previousWidget = widget;
                }
                break;
            }
            case AlignHorizontallyRight: {
                int max = Integer.MIN_VALUE;
                for (ConstraintWidget widget : widgets) {
                    max = Math.max(max, widget.getX() + widget.getWidth());
                }
                ConstraintWidget previousWidget = null;
                for (ConstraintWidget widget : widgets) {
                    float current = widget.getWidth();
                    widget.setX((int)((float)max - current));
                    if (applyConstraints && previousWidget != null) {
                        widget.resetAnchor(widget.getAnchor(ConstraintAnchor.Type.LEFT));
                        widget.connect(ConstraintAnchor.Type.RIGHT, previousWidget, ConstraintAnchor.Type.RIGHT, 0);
                    }
                    previousWidget = widget;
                }
                break;
            }
            case AlignVerticallyTop: {
                int min = Integer.MAX_VALUE;
                for (ConstraintWidget widget : widgets) {
                    min = Math.min(min, widget.getY());
                }
                ConstraintWidget previousWidget = null;
                for (ConstraintWidget widget : widgets) {
                    widget.setY(min);
                    if (applyConstraints && previousWidget != null) {
                        widget.resetAnchor(widget.getAnchor(ConstraintAnchor.Type.BOTTOM));
                        widget.connect(ConstraintAnchor.Type.TOP, previousWidget, ConstraintAnchor.Type.TOP, 0);
                    }
                    previousWidget = widget;
                }
                break;
            }
            case AlignVerticallyMiddle: {
                int count = 0;
                float avg = 0.0f;
                for (ConstraintWidget widget : widgets) {
                    avg += (float)widget.getY() + (float)widget.getHeight() / 2.0f;
                    ++count;
                }
                avg /= (float)count;
                ConstraintWidget previousWidget = null;
                for (ConstraintWidget widget : widgets) {
                    float current = (float)widget.getHeight() / 2.0f;
                    widget.setY((int)(avg - current));
                    if (applyConstraints && previousWidget != null) {
                        widget.connect(ConstraintAnchor.Type.CENTER_Y, previousWidget, ConstraintAnchor.Type.CENTER_Y, 0);
                    }
                    previousWidget = widget;
                }
                break;
            }
            case AlignBaseline: {
                int count = 0;
                float avg = 0.0f;
                int number_of_constrained = 0;
                ConstraintWidget fixedWidget = null;
                for (ConstraintWidget widget : widgets) {
                    if (ScoutArrange.isVerticallyConstrained(widget)) {
                        ++number_of_constrained;
                        fixedWidget = widget;
                    }
                    avg += (float)(widget.getY() + widget.getBaselineDistance());
                    ++count;
                }
                avg /= (float)count;
                if (number_of_constrained == 1) {
                    avg = fixedWidget.getY() + fixedWidget.getBaselineDistance();
                }
                ConstraintWidget previousWidget = null;
                if (!applyConstraints || number_of_constrained == 0) {
                    for (ConstraintWidget widget : widgets) {
                        float baseline = widget.getBaselineDistance();
                        widget.setY((int)(avg - baseline));
                        if (applyConstraints && previousWidget != null) {
                            widget.connect(ConstraintAnchor.Type.BASELINE, previousWidget, ConstraintAnchor.Type.BASELINE, 0);
                        }
                        previousWidget = widget;
                    }
                } else {
                    ArrayList<ConstraintWidget> unconstrained = new ArrayList<ConstraintWidget>();
                    ArrayList<ConstraintWidget> constrained = new ArrayList<ConstraintWidget>();
                    for (Object widget : widgets) {
                        if (ScoutArrange.isVerticallyConstrained((ConstraintWidget)widget)) {
                            constrained.add((ConstraintWidget)widget);
                            continue;
                        }
                        unconstrained.add((ConstraintWidget)widget);
                    }
                    while (!unconstrained.isEmpty()) {
                        ConstraintWidget to = null;
                        ConstraintWidget from = null;
                        int min = Integer.MAX_VALUE;
                        for (ConstraintWidget fromCandidate : unconstrained) {
                            for (ConstraintWidget toCandidate : constrained) {
                                int fromLeft = fromCandidate.getX();
                                int fromRight = fromLeft + fromCandidate.getWidth();
                                int toLeft = toCandidate.getX();
                                int toRight = toLeft + toCandidate.getWidth();
                                int dist = Math.abs(toLeft - fromLeft);
                                dist = Math.min(dist, Math.abs(toLeft - fromRight));
                                dist = Math.min(dist, Math.abs(toRight - fromRight));
                                if ((dist = Math.min(dist, Math.abs(toRight - fromLeft))) >= min) continue;
                                min = dist;
                                to = toCandidate;
                                from = fromCandidate;
                            }
                        }
                        from.connect(ConstraintAnchor.Type.BASELINE, to, ConstraintAnchor.Type.BASELINE, 0);
                        constrained.add(from);
                        unconstrained.remove(from);
                    }
                }
                break;
            }
            case AlignVerticallyBottom: {
                int max = Integer.MIN_VALUE;
                for (ConstraintWidget widget : widgets) {
                    max = Math.max(max, widget.getY() + widget.getHeight());
                }
                ConstraintWidget previousWidget = null;
                for (ConstraintWidget widget : widgets) {
                    float current = widget.getHeight();
                    widget.setY((int)((float)max - current));
                    if (applyConstraints && previousWidget != null) {
                        widget.resetAnchor(widget.getAnchor(ConstraintAnchor.Type.TOP));
                        widget.connect(ConstraintAnchor.Type.BOTTOM, previousWidget, ConstraintAnchor.Type.BOTTOM, 0);
                    }
                    previousWidget = widget;
                }
                break;
            }
            case DistributeVertically: {
                int size;
                int count = 0;
                int sum = 0;
                int min = widgetList.get(0).getY();
                int max = widgetList.get(0).getY() + widgetList.get(0).getHeight();
                for (ConstraintWidget widget : widgets) {
                    int start = widget.getY();
                    size = widget.getHeight();
                    int end = start + size;
                    sum += size;
                    min = Math.min(min, start);
                    max = Math.max(max, end);
                    ++count;
                }
                int gaps = count - 1;
                int totalGap = max - min - sum;
                int lastY = min;
                boolean reverse = ScoutArrange.rootDistanceY(widgets[0]) > ScoutArrange.rootDistanceY(widgets[((ConstraintWidget)widgets).length - 1]);
                for (int i = 0; i < count; ++i) {
                    if (i <= 0) continue;
                    size = widgets[i - 1].getHeight();
                    int pos = (min += size) + totalGap * i / gaps;
                    widgets[i].setY(pos);
                    if (!applyConstraints) continue;
                    if (reverse) {
                        widgets[i - 1].connect(ConstraintAnchor.Type.BOTTOM, widgets[i], ConstraintAnchor.Type.TOP, pos - lastY - size);
                    } else {
                        widgets[i].connect(ConstraintAnchor.Type.TOP, widgets[i - 1], ConstraintAnchor.Type.BOTTOM, pos - lastY - size);
                    }
                    lastY = pos;
                }
                break;
            }
            case DistributeHorizontally: {
                int size;
                int count = 0;
                int sum = 0;
                int min = widgetList.get(0).getX();
                int max = widgetList.get(0).getX() + widgetList.get(0).getHeight();
                for (ConstraintWidget widget : widgets) {
                    int start = widget.getX();
                    size = widget.getWidth();
                    int end = start + size;
                    sum += size;
                    min = Math.min(min, start);
                    max = Math.max(max, end);
                    ++count;
                }
                int gaps = count - 1;
                int totalGap = max - min - sum;
                int lastX = min;
                boolean reverse = ScoutArrange.rootDistanceX(widgets[0]) > ScoutArrange.rootDistanceX(widgets[((ConstraintWidget)widgets).length - 1]);
                for (int i = 0; i < count; ++i) {
                    if (i <= 0) continue;
                    size = widgets[i - 1].getWidth();
                    int pos = (min += size) + totalGap * i / gaps;
                    widgets[i].setX(pos);
                    if (!applyConstraints) continue;
                    if (reverse) {
                        widgets[i - 1].connect(ConstraintAnchor.Type.RIGHT, widgets[i], ConstraintAnchor.Type.LEFT, pos - lastX - size);
                    } else {
                        widgets[i].connect(ConstraintAnchor.Type.LEFT, widgets[i - 1], ConstraintAnchor.Type.RIGHT, pos - lastX - size);
                    }
                    lastX = pos;
                }
                break;
            }
            case VerticalPack: {
                Rectangle original = ScoutArrange.getBoundingBox(widgetList);
                ConstraintWidget[] wArray = new ConstraintWidget[widgetList.size()];
                wArray = widgetList.toArray(wArray);
                Arrays.sort(wArray, (w1, w2) -> Integer.compare(w1.getY(), w2.getY()));
                ScoutWidget[] list = ScoutWidget.getWidgetArray((WidgetContainer)widgetList.get(0).getParent());
                for (ConstraintWidget cw : wArray) {
                    for (ScoutWidget scoutWidget : list) {
                        if (scoutWidget.mConstraintWidget != cw) continue;
                        int gapN = scoutWidget.gap(Direction.NORTH, list);
                        int newY = margin + scoutWidget.mConstraintWidget.getY() - gapN;
                        newY = Math.max(newY, original.y);
                        scoutWidget.setY(newY);
                    }
                }
                break;
            }
            case HorizontalPack: {
                Rectangle original = ScoutArrange.getBoundingBox(widgetList);
                ConstraintWidget[] wArray = new ConstraintWidget[widgetList.size()];
                wArray = widgetList.toArray(wArray);
                Arrays.sort(wArray, (w1, w2) -> Integer.compare(w1.getX(), w2.getX()));
                ScoutWidget[] list = ScoutWidget.getWidgetArray((WidgetContainer)widgetList.get(0).getParent());
                for (ConstraintWidget cw : wArray) {
                    for (ScoutWidget scoutWidget : list) {
                        if (scoutWidget.mConstraintWidget != cw) continue;
                        int gapW = scoutWidget.gap(Direction.WEST, list);
                        int newX = margin + scoutWidget.mConstraintWidget.getX() - gapW;
                        newX = Math.max(newX, original.x);
                        scoutWidget.setX(newX);
                    }
                }
                break;
            }
            case ExpandVertically: {
                ScoutArrange.expandVertically(widgetList, margin);
                break;
            }
            case ExpandHorizontally: {
                ScoutArrange.expandHorizontally(widgetList, margin);
            }
        }
    }

    private static void expandVertically(ArrayList<ConstraintWidget> widgetList, int margin) {
        WidgetContainer base = (WidgetContainer)widgetList.get(0).getParent();
        ConstraintWidget[] pears = new ConstraintWidget[base.getChildren().size()];
        pears = base.getChildren().toArray(pears);
        Rectangle selectBounds = ScoutArrange.getBoundingBox(widgetList);
        Rectangle clip = new Rectangle();
        int gapNorth = ScoutArrange.gap(Direction.NORTH, selectBounds, pears);
        int gapSouth = ScoutArrange.gap(Direction.SOUTH, selectBounds, pears);
        clip.y = selectBounds.y - gapNorth;
        clip.height = selectBounds.height + gapSouth + gapNorth;
        ArrayList<ConstraintWidget> selectedList = new ArrayList<ConstraintWidget>(widgetList);
        while (!selectedList.isEmpty()) {
            ConstraintWidget widget = selectedList.remove(0);
            ArrayList<ConstraintWidget> col = new ArrayList<ConstraintWidget>();
            col.add(widget);
            Iterator<ConstraintWidget> iterator = selectedList.iterator();
            while (iterator.hasNext()) {
                ConstraintWidget elem = iterator.next();
                if (!ScoutArrange.isSameColumn(widget, elem)) continue;
                if (!col.contains(elem)) {
                    col.add(elem);
                }
                iterator.remove();
            }
            ConstraintWidget[] colArray = new ConstraintWidget[col.size()];
            colArray = col.toArray(colArray);
            Arrays.sort(colArray, sSortY);
            int gaps = (colArray.length - 1) * margin;
            int totalHeight = clip.height - gaps - 2 * margin;
            for (int i = 0; i < colArray.length; ++i) {
                int y = margin * i + i * totalHeight / colArray.length;
                ConstraintWidget constraintWidget = colArray[i];
                constraintWidget.setY(y + clip.y + margin);
                int yend = margin * i + totalHeight * (i + 1) / colArray.length;
                constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.setHeight(yend - y);
            }
        }
    }

    public static void expandHorizontally(ArrayList<ConstraintWidget> widgetList, int margin) {
        WidgetContainer base = (WidgetContainer)widgetList.get(0).getParent();
        ConstraintWidget[] pears = new ConstraintWidget[base.getChildren().size()];
        pears = base.getChildren().toArray(pears);
        Rectangle selectBounds = ScoutArrange.getBoundingBox(widgetList);
        Rectangle clip = new Rectangle();
        int gapWest = ScoutArrange.gap(Direction.WEST, selectBounds, pears);
        int gapEast = ScoutArrange.gap(Direction.EAST, selectBounds, pears);
        clip.x = selectBounds.x - gapWest;
        clip.width = selectBounds.width + gapEast + gapWest;
        ArrayList<ConstraintWidget> selectedList = new ArrayList<ConstraintWidget>(widgetList);
        while (!selectedList.isEmpty()) {
            ConstraintWidget widget = selectedList.remove(0);
            ArrayList<ConstraintWidget> row = new ArrayList<ConstraintWidget>();
            row.add(widget);
            Iterator<ConstraintWidget> iterator = selectedList.iterator();
            while (iterator.hasNext()) {
                ConstraintWidget elem = iterator.next();
                if (!ScoutArrange.isSameRow(widget, elem)) continue;
                if (!row.contains(elem)) {
                    row.add(elem);
                }
                iterator.remove();
            }
            ConstraintWidget[] rowArray = new ConstraintWidget[row.size()];
            rowArray = row.toArray(rowArray);
            Arrays.sort(rowArray, sSortX);
            int gaps = (rowArray.length - 1) * margin;
            int totalWidth = clip.width - gaps - 2 * margin;
            for (int i = 0; i < rowArray.length; ++i) {
                int x = margin * i + i * totalWidth / rowArray.length;
                ConstraintWidget constraintWidget = rowArray[i];
                constraintWidget.setX(x + clip.x + margin);
                int xend = margin * i + totalWidth * (i + 1) / rowArray.length;
                constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.setWidth(xend - x);
            }
        }
    }

    static boolean isSameRow(ConstraintWidget a, ConstraintWidget b) {
        return Math.max(a.getY(), b.getY()) < Math.min(a.getY() + a.getHeight(), b.getY() + b.getHeight());
    }

    static boolean isSameColumn(ConstraintWidget a, ConstraintWidget b) {
        return Math.max(a.getX(), b.getX()) < Math.min(a.getX() + a.getWidth(), b.getX() + b.getWidth());
    }

    static Rectangle getRectangle(ConstraintWidget widget) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = widget.getX();
        rectangle.y = widget.getY();
        rectangle.width = widget.getWidth();
        rectangle.height = widget.getHeight();
        return rectangle;
    }

    public static ConstraintWidget gapWidget(Direction direction, Rectangle region, ConstraintWidget[] list) {
        int rootWidth = list[0].getParent().getWidth();
        int rootHeight = list[0].getParent().getHeight();
        Rectangle rect = new Rectangle();
        switch (direction) {
            case NORTH: {
                rect.y = 0;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = region.y;
                break;
            }
            case SOUTH: {
                rect.y = region.y + region.height + 1;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = rootHeight - rect.y;
                break;
            }
            case WEST: {
                rect.y = region.y + 1;
                rect.x = 0;
                rect.width = region.x;
                rect.height = region.height - 2;
                break;
            }
            case EAST: {
                rect.y = region.y + 1;
                rect.x = region.x + region.width + 1;
                rect.width = rootWidth - rect.x;
                rect.height = region.height - 2;
            }
        }
        int min = Integer.MAX_VALUE;
        ConstraintWidget minWidget = null;
        for (ConstraintWidget widget : list) {
            int dist;
            Rectangle r = ScoutArrange.getRectangle(widget);
            if (!r.intersects(rect) || min <= (dist = (int)ScoutArrange.distance(r, region))) continue;
            minWidget = widget;
            min = dist;
        }
        if (min > Math.max(rootHeight, rootWidth)) {
            return list[0].getParent();
        }
        return minWidget;
    }

    public static int gap(Direction direction, Rectangle region, ConstraintWidget[] list) {
        int rootWidth = list[0].getParent().getWidth();
        int rootHeight = list[0].getParent().getHeight();
        Rectangle rect = new Rectangle();
        switch (direction) {
            case NORTH: {
                rect.y = 0;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = region.y;
                break;
            }
            case SOUTH: {
                rect.y = region.y + region.height + 1;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = rootHeight - rect.y;
                break;
            }
            case WEST: {
                rect.y = region.y + 1;
                rect.x = 0;
                rect.width = region.x;
                rect.height = region.height - 2;
                break;
            }
            case EAST: {
                rect.y = region.y + 1;
                rect.x = region.x + region.width + 1;
                rect.width = rootWidth - rect.x;
                rect.height = region.height - 2;
            }
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < list.length; ++i) {
            int dist;
            ConstraintWidget widget = list[i];
            Rectangle r = ScoutArrange.getRectangle(widget);
            if (!r.intersects(rect) || min <= (dist = (int)ScoutArrange.distance(r, region))) continue;
            min = dist;
        }
        if (min > Math.max(rootHeight, rootWidth)) {
            switch (direction) {
                case NORTH: {
                    return region.y;
                }
                case SOUTH: {
                    return rootHeight - (region.y + region.height);
                }
                case WEST: {
                    return region.x;
                }
                case EAST: {
                    return rootWidth - (region.x + region.width);
                }
            }
        }
        return min;
    }

    static float distance(Rectangle a, Rectangle b) {
        float ax1 = a.x;
        float ax2 = a.x + a.width;
        float ay1 = a.y;
        float ay2 = a.y + a.height;
        float bx1 = b.x;
        float bx2 = b.x + b.width;
        float by1 = b.y;
        float by2 = b.y + b.height;
        float xdiff11 = Math.abs(ax1 - bx1);
        float xdiff12 = Math.abs(ax1 - bx2);
        float xdiff21 = Math.abs(ax2 - bx1);
        float xdiff22 = Math.abs(ax2 - bx2);
        float ydiff11 = Math.abs(ay1 - by1);
        float ydiff12 = Math.abs(ay1 - by2);
        float ydiff21 = Math.abs(ay2 - by1);
        float ydiff22 = Math.abs(ay2 - by2);
        float xmin = Math.min(Math.min(xdiff11, xdiff12), Math.min(xdiff21, xdiff22));
        float ymin = Math.min(Math.min(ydiff11, ydiff12), Math.min(ydiff21, ydiff22));
        boolean yOverlap = ay1 <= by2 && by1 <= ay2;
        boolean xOverlap = ax1 <= bx2 && bx1 <= ax2;
        float xReturn = yOverlap ? xmin : (float)Math.hypot(xmin, ymin);
        float yReturn = xOverlap ? ymin : (float)Math.hypot(xmin, ymin);
        return Math.min(xReturn, yReturn);
    }

    static int rootDistanceX(ConstraintWidget widget) {
        int rootWidth = widget.getParent().getWidth();
        int aX = widget.getX();
        int aWidth = widget.getWidth();
        return Math.min(aX, rootWidth - (aX + aWidth));
    }

    static int rootDistanceY(ConstraintWidget widget) {
        int rootHeight = widget.getParent().getHeight();
        int aY = widget.getY();
        int aHeight = widget.getHeight();
        return Math.min(aY, rootHeight - (aY + aHeight));
    }

    static Rectangle getBoundingBox(ArrayList<ConstraintWidget> widgets) {
        Rectangle all = null;
        Rectangle tmp = new Rectangle();
        for (ConstraintWidget widget : widgets) {
            if (widget instanceof Guideline) continue;
            tmp.x = widget.getX();
            tmp.y = widget.getY();
            tmp.width = widget.getWidth();
            tmp.height = widget.getHeight();
            if (all == null) {
                all = new Rectangle(tmp);
                continue;
            }
            all = all.union(tmp);
        }
        return all;
    }

    private static void reverse(ConstraintWidget[] widgets) {
        for (int i = 0; i < widgets.length / 2; ++i) {
            ConstraintWidget widget = widgets[i];
            widgets[i] = widgets[widgets.length - 1 - i];
            widgets[widgets.length - 1 - i] = widget;
        }
    }

    private static int rootDistance(ConstraintWidget widget) {
        int rootHeight = widget.getParent().getHeight();
        int rootWidth = widget.getParent().getWidth();
        int aX = widget.getX();
        int aY = widget.getY();
        int aWidth = widget.getWidth();
        int aHeight = widget.getHeight();
        int minx = Math.min(aX, rootWidth - (aX + aWidth));
        int miny = Math.min(aY, rootHeight - (aY + aHeight));
        return Math.min(minx, miny);
    }

    private static boolean isVerticallyConstrained(ConstraintWidget widget) {
        if (widget.getAnchor(ConstraintAnchor.Type.BOTTOM).isConnected()) {
            return true;
        }
        if (widget.getAnchor(ConstraintAnchor.Type.TOP).isConnected()) {
            return true;
        }
        return widget.getAnchor(ConstraintAnchor.Type.BASELINE).isConnected();
    }

    private static ConstraintWidget nearestHorizontal(ConstraintWidget nextTo, ArrayList<ConstraintWidget> list) {
        int min = Integer.MAX_VALUE;
        ConstraintWidget ret = null;
        int nextToLeft = nextTo.getX();
        int nextToRight = nextToLeft + nextTo.getWidth();
        for (ConstraintWidget widget : list) {
            if (widget == nextTo) continue;
            int left = widget.getX();
            int right = left + widget.getWidth();
            int dist = Math.abs(left - nextToLeft);
            dist = Math.min(dist, Math.abs(left - nextToRight));
            dist = Math.min(dist, Math.abs(right - nextToRight));
            if ((dist = Math.min(dist, Math.abs(right - nextToLeft))) >= min) continue;
            min = dist;
            ret = widget;
        }
        return ret;
    }
}

