/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import android.support.constraint.solver.widgets.ConstraintTableLayout;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.tools.sherpa.scout.ScoutArrange;
import com.android.tools.sherpa.scout.ScoutGroup;
import com.android.tools.sherpa.scout.ScoutGroupInference;
import com.android.tools.sherpa.scout.ScoutWidget;
import com.android.tools.sherpa.structure.WidgetsScene;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Scout {
    private static int sMargin = 8;

    public static int getMargin() {
        return sMargin;
    }

    public static void setMargin(int margin) {
        sMargin = margin;
    }

    public static void arrangeWidgets(Arrange type, ArrayList<ConstraintWidget> widgets, boolean applyConstraint) {
        ScoutArrange.align(type, widgets, applyConstraint);
    }

    public static void wrap(ConstraintWidgetContainer root) {
        ArrayList widgets = root.getChildren();
        Rectangle all = ScoutArrange.getBoundingBox(widgets);
        all.x -= sMargin;
        all.y -= sMargin;
        all.width += sMargin * 2;
        all.height += sMargin * 2;
        for (ConstraintWidget widget : widgets) {
            widget.setX(widget.getX() - all.x);
            widget.setY(widget.getY() - all.y);
        }
        root.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
        root.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
        root.setWidth(all.width);
        root.setHeight(all.height);
    }

    public static void inferConstraints(WidgetsScene list) {
        Scout.inferConstraints(list.getRoot());
    }

    private static void inferConstraints(WidgetContainer base) {
        if (base == null) {
            return;
        }
        if (base instanceof ConstraintWidgetContainer && ((ConstraintWidgetContainer)base).handlesInternalConstraints()) {
            return;
        }
        int preX = base.getX();
        int preY = base.getY();
        base.setX(0);
        base.setY(0);
        for (ConstraintWidget constraintWidget : base.getChildren()) {
            ConstraintWidgetContainer container;
            if (!(constraintWidget instanceof ConstraintWidgetContainer) || (container = (ConstraintWidgetContainer)constraintWidget).getChildren().isEmpty()) continue;
            Scout.inferConstraints((WidgetContainer)container);
        }
        ArrayList<WidgetContainer> list = new ArrayList<WidgetContainer>(base.getChildren());
        list.add(0, base);
        ConstraintWidget[] widgets = list.toArray(new ConstraintWidget[list.size()]);
        ScoutWidget.computeConstraints(ScoutWidget.create(widgets));
        base.setX(preX);
        base.setY(preY);
    }

    public static ConstraintWidget[] inferTableList(WidgetsScene list) {
        for (ConstraintWidget widget : list.getWidgets()) {
            widget.resetAnchors();
        }
        return Scout.inferTableList(list.getRoot());
    }

    private static ConstraintWidget[] inferTableList(WidgetContainer base) {
        if (base instanceof ConstraintWidgetContainer && ((ConstraintWidgetContainer)base).handlesInternalConstraints()) {
            return null;
        }
        for (ConstraintWidget constraintWidget : base.getChildren()) {
            if (!(constraintWidget instanceof ConstraintWidgetContainer)) continue;
            Scout.inferConstraints((WidgetContainer)((ConstraintWidgetContainer)constraintWidget));
        }
        ArrayList<WidgetContainer> list = new ArrayList<WidgetContainer>(base.getChildren());
        list.add(0, base);
        ConstraintWidget[] widgets = list.toArray(new ConstraintWidget[list.size()]);
        ConstraintWidget[] iw = ScoutGroupInference.computeGroups(ScoutWidget.create(widgets));
        if (iw != null && iw.length > 0) {
            return iw;
        }
        return null;
    }

    public static ConstraintTableLayout inferGroup(ArrayList<ConstraintWidget> widgets) {
        ScoutGroup group = new ScoutGroup(widgets.toArray(new ConstraintWidget[widgets.size()]));
        ConstraintTableLayout ret = new ConstraintTableLayout();
        if (group.mCols * group.mRows >= widgets.size()) {
            ret.setNumRows(group.mRows);
            ret.setNumCols(group.mCols);
        }
        if (group.mSupported) {
            for (int i = 0; i < group.mCols; ++i) {
                ret.setColumnAlignment(i, group.mColAlign[i]);
            }
        }
        return ret;
    }

    public static enum Arrange {
        AlignVerticallyTop,
        AlignVerticallyMiddle,
        AlignVerticallyBottom,
        AlignHorizontallyLeft,
        AlignHorizontallyCenter,
        AlignHorizontallyRight,
        DistributeVertically,
        DistributeHorizontally,
        VerticalPack,
        HorizontalPack,
        ExpandVertically,
        AlignBaseline,
        ExpandHorizontally,
        CenterHorizontallyInParent,
        CenterVerticallyInParent,
        CenterVertically,
        CenterHorizontally;

    }
}

