/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.circular.CircularLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.layout.orthogonal.DirectedOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.OrthogonalLayouter;
import com.intellij.openapi.graph.layout.tree.BalloonLayouter;
import com.intellij.openapi.graph.layout.tree.HVTreeLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public enum DiagramLayout {
    BALLOON,
    CIRCULAR,
    HIERARCHIC_GROUP,
    ORGANIC,
    ORTHOGONAL,
    DIRECTED_ORTHOGONAL,
    TREE;


    public static DiagramLayout getDefault() {
        return HIERARCHIC_GROUP;
    }

    @NotNull
    public Layouter getLayouter(@NotNull Graph2D graph, @NotNull Project project) {
        if (graph == null) {
            DiagramLayout.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DiagramLayout.$$$reportNull$$$0(1);
        }
        Layouter layouter = this.getLayouter(GraphSettingsProvider.getInstance((Project)project).getSettings((Graph)graph));
        if (layouter == null) {
            DiagramLayout.$$$reportNull$$$0(2);
        }
        return layouter;
    }

    @NotNull
    public Layouter getLayouter(@NotNull GraphSettings settings) {
        if (settings == null) {
            DiagramLayout.$$$reportNull$$$0(3);
        }
        switch (this) {
            case BALLOON: {
                BalloonLayouter balloonLayouter = settings.getBalloonLayouter();
                if (balloonLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(4);
                }
                return balloonLayouter;
            }
            case CIRCULAR: {
                CircularLayouter circularLayouter = settings.getCircularLayouter();
                if (circularLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(5);
                }
                return circularLayouter;
            }
            case DIRECTED_ORTHOGONAL: {
                DirectedOrthogonalLayouter directedOrthogonalLayouter = settings.getDirectedOrthogonalLayouter();
                if (directedOrthogonalLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(6);
                }
                return directedOrthogonalLayouter;
            }
            case HIERARCHIC_GROUP: {
                HierarchicGroupLayouter hierarchicGroupLayouter = settings.getGroupLayouter();
                if (hierarchicGroupLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(7);
                }
                return hierarchicGroupLayouter;
            }
            case ORGANIC: {
                SmartOrganicLayouter smartOrganicLayouter = settings.getOrganicLayouter();
                if (smartOrganicLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(8);
                }
                return smartOrganicLayouter;
            }
            case ORTHOGONAL: {
                OrthogonalLayouter orthogonalLayouter = settings.getOrthogonalLayouter();
                if (orthogonalLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(9);
                }
                return orthogonalLayouter;
            }
            case TREE: {
                HVTreeLayouter hVTreeLayouter = settings.getHVTreeLayouter();
                if (hVTreeLayouter == null) {
                    DiagramLayout.$$$reportNull$$$0(10);
                }
                return hVTreeLayouter;
            }
        }
        HierarchicGroupLayouter hierarchicGroupLayouter = settings.getGroupLayouter();
        if (hierarchicGroupLayouter == null) {
            DiagramLayout.$$$reportNull$$$0(11);
        }
        return hierarchicGroupLayouter;
    }

    public String getPresentableName() {
        return StringUtil.capitalizeWords((String)this.name().toLowerCase().replaceAll("_", " "), (boolean)true);
    }

    public static DiagramLayout fromString(Object obj) {
        if (obj == null) {
            return DiagramLayout.getDefault();
        }
        String name = obj.toString();
        try {
            return DiagramLayout.valueOf(name.toUpperCase().replaceAll(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            return DiagramLayout.getDefault();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/settings/DiagramLayout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/settings/DiagramLayout";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayouter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLayouter";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

