/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GrGspExprInjection;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterGroovyElement;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrMethodWrapper;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrailsPsiUtil {
    private GrailsPsiUtil() {
    }

    public static boolean processLogVariable(@NotNull PsiScopeProcessor processor, @NotNull PsiClass aClass, @Nullable String nameHint) {
        if (processor == null) {
            GrailsPsiUtil.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            GrailsPsiUtil.$$$reportNull$$$0(1);
        }
        if ((nameHint == null || nameHint.equals("log")) && ResolveUtil.shouldProcessProperties((ElementClassHint)((ElementClassHint)processor.getHint(ElementClassHint.KEY))) && aClass.findFieldByName("log", false) == null && !aClass.isInterface()) {
            GrLightField logField = new GrLightField(aClass, "log", "org.apache.commons.logging.Log");
            logField.getModifierList().setModifiers(26);
            return processor.execute((PsiElement)logField, ResolveState.initial());
        }
        return true;
    }

    public static boolean enhance(@NotNull PsiScopeProcessor processor, @NotNull PsiClass apiClass, @NotNull PsiType objectType) {
        if (processor == null) {
            GrailsPsiUtil.$$$reportNull$$$0(2);
        }
        if (apiClass == null) {
            GrailsPsiUtil.$$$reportNull$$$0(3);
        }
        if (objectType == null) {
            GrailsPsiUtil.$$$reportNull$$$0(4);
        }
        return GrailsPsiUtil.enhance(processor, apiClass, objectType, null);
    }

    public static boolean enhance(@NotNull PsiScopeProcessor processor, @NotNull PsiClass apiClass, @NotNull PsiType objectType, @Nullable Object methodKind) {
        String nameHint;
        if (processor == null) {
            GrailsPsiUtil.$$$reportNull$$$0(5);
        }
        if (apiClass == null) {
            GrailsPsiUtil.$$$reportNull$$$0(6);
        }
        if (objectType == null) {
            GrailsPsiUtil.$$$reportNull$$$0(7);
        }
        PsiMethod[] methods = (nameHint = ResolveUtil.getNameHint((PsiScopeProcessor)processor)) == null ? apiClass.getAllMethods() : apiClass.findMethodsByName(nameHint, true);
        for (PsiMethod method : methods) {
            if (!GrailsPsiUtil.isCandidateMethod(method, objectType)) continue;
            GrMethodWrapper builder = GrMethodWrapper.wrap((PsiMethod)method);
            if (!method.hasModifierProperty("static")) {
                builder.getParameterList().removeParameter(0);
            }
            builder.addModifier("public");
            builder.setMethodKind(methodKind);
            if (processor.execute((PsiElement)builder, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    private static boolean isCandidateMethod(PsiMethod method, @NotNull PsiType objectType) {
        if (objectType == null) {
            GrailsPsiUtil.$$$reportNull$$$0(8);
        }
        if (!method.hasModifierProperty("public") || method.hasModifierProperty("abstract") || method.getName().indexOf(36) != -1 || method.isConstructor()) {
            return false;
        }
        if (!method.hasModifierProperty("static")) {
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return false;
            }
            if (!TypesUtil.isAssignableByMethodCallConversion((PsiType)parameters[0].getType(), (PsiType)objectType, (PsiElement)method)) {
                return false;
            }
        }
        return true;
    }

    public static GrLightMethodBuilder substitute(PsiMethod method, PsiSubstitutor substitutor) {
        GrMethodWrapper res = GrMethodWrapper.wrap((PsiMethod)method);
        res.setReturnType(substitutor.substitute(res.getReturnType()));
        res.getParameterList().clear();
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            GrLightParameter p = new GrLightParameter(StringUtil.notNullize((String)parameter.getName()), substitutor.substitute(parameter.getType()), (PsiElement)res);
            if (parameter instanceof GrParameter) {
                p.setOptional(((GrParameter)parameter).isOptional());
            }
            res.addParameter((GrParameter)p);
        }
        return res;
    }

    public static boolean process(String className, PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass(className, place.getResolveScope());
        if (aClass != null) {
            return ResolveUtil.processClassDeclarations((PsiClass)aClass, (PsiScopeProcessor)processor, (ResolveState)state, null, (PsiElement)place);
        }
        return true;
    }

    @Nullable
    public static String getPlainLabelName(GrNamedArgument namedArgument) {
        GrArgumentLabel label = namedArgument.getLabel();
        if (label == null) {
            return null;
        }
        PsiElement labelElement = label.getNameElement();
        if (!(labelElement instanceof LeafElement)) {
            return null;
        }
        IElementType type = ((LeafElement)labelElement).getElementType();
        if (GroovyTokenTypes.mIDENT == type || TokenSets.KEYWORDS.contains(type)) {
            return labelElement.getText();
        }
        if (type == GroovyTokenTypes.mGSTRING_LITERAL || type == GroovyTokenTypes.mSTRING_LITERAL) {
            return (String)GrLiteralImpl.getLiteralValue((PsiElement)labelElement);
        }
        return null;
    }

    public static boolean isSimpleAttribute(@NotNull XmlAttributeValue value) {
        PsiElement leftQuote;
        if (value == null) {
            GrailsPsiUtil.$$$reportNull$$$0(9);
        }
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)(leftQuote = value.getFirstChild()), (IElementType)GspTokenTypes.GSP_ATTR_VALUE_START_DELIMITER)) {
            return false;
        }
        PsiElement textToken = leftQuote.getNextSibling();
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)textToken, (IElementType)XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN)) {
            return false;
        }
        PsiElement rightQuote = textToken.getNextSibling();
        if (!(rightQuote instanceof XmlToken) || ((XmlToken)rightQuote).getTokenType() != GspTokenTypes.GSP_ATTR_VALUE_END_DELIMITER) {
            return false;
        }
        return rightQuote.getNextSibling() == null;
    }

    @Nullable
    public static XmlAttributeValue getAttributeValue(@NotNull XmlTag tag, String attributeName) {
        XmlAttribute attribute;
        if (tag == null) {
            GrailsPsiUtil.$$$reportNull$$$0(10);
        }
        if ((attribute = tag.getAttribute(attributeName)) == null) {
            return null;
        }
        XmlAttributeValue value = attribute.getValueElement();
        if (value == null) {
            return null;
        }
        PsiElement firstChild = value.getFirstChild();
        if (PsiImplUtil.isLeafElementOfType((PsiElement)firstChild, (IElementType)GspTokenTypes.GSP_ATTR_VALUE_START_DELIMITER)) {
            PsiElement secondChild = firstChild.getNextSibling();
            if (PsiImplUtil.isLeafElementOfType((PsiElement)firstChild, (IElementType)GspTokenTypes.GSP_ATTR_VALUE_END_DELIMITER)) {
                return null;
            }
            if (PsiImplUtil.isLeafElementOfType((PsiElement)secondChild, (IElementType)XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) && PsiImplUtil.isLeafElementOfType((PsiElement)secondChild.getNextSibling(), (IElementType)GspTokenTypes.GSP_ATTR_VALUE_END_DELIMITER) && secondChild.getText().trim().isEmpty()) {
                return null;
            }
        }
        return value;
    }

    @Nullable
    public static PsiType getAttributeExpressionType(@NotNull XmlAttributeValue value) {
        PsiElement leftQuote;
        if (value == null) {
            GrailsPsiUtil.$$$reportNull$$$0(11);
        }
        if (!((leftQuote = value.getFirstChild()) instanceof XmlToken) || ((XmlToken)leftQuote).getTokenType() != GspTokenTypes.GSP_ATTR_VALUE_START_DELIMITER) {
            return null;
        }
        PsiElement firstElement = leftQuote.getNextSibling();
        if (!(firstElement instanceof LeafPsiElement)) {
            return null;
        }
        IElementType firstElementType = ((LeafPsiElement)firstElement).getElementType();
        if (firstElementType == GspTokenTypes.GSP_ATTR_VALUE_END_DELIMITER) {
            return null;
        }
        if (firstElementType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || firstElementType == GspTokenTypes.GSTRING_DOLLAR) {
            return PsiType.getJavaLangString((PsiManager)value.getManager(), (GlobalSearchScope)value.getResolveScope());
        }
        if (firstElement instanceof GspOuterGroovyElement) {
            PsiElement valueEndDelimiter = firstElement.getNextSibling();
            if (valueEndDelimiter instanceof XmlToken && ((XmlToken)valueEndDelimiter).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                return GrailsPsiUtil.getTypeByOuterElement((GspOuterGroovyElement)firstElement);
            }
            return PsiType.getJavaLangString((PsiManager)value.getManager(), (GlobalSearchScope)value.getResolveScope());
        }
        if (firstElementType == GspTokenTypes.GEXPR_BEGIN) {
            PsiElement groovyCodeElement = firstElement.getNextSibling();
            if (!(groovyCodeElement instanceof GspOuterGroovyElement)) {
                return null;
            }
            PsiElement closeBracket = groovyCodeElement.getNextSibling();
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)closeBracket, (IElementType)GspTokenTypes.GEXPR_END)) {
                return null;
            }
            assert (closeBracket != null);
            PsiElement valueEndDelimiter = closeBracket.getNextSibling();
            if (valueEndDelimiter instanceof XmlToken && ((XmlToken)valueEndDelimiter).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                return GrailsPsiUtil.getTypeByOuterElement((GspOuterGroovyElement)groovyCodeElement);
            }
            return PsiType.getJavaLangString((PsiManager)value.getManager(), (GlobalSearchScope)value.getResolveScope());
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByOuterElement(GspOuterGroovyElement outerElement) {
        GrConditionalExpression cExpr;
        PsiElement grInLeft = outerElement.getContainingFile().getViewProvider().findElementAt(outerElement.getTextOffset() - 1, (Language)GroovyLanguage.INSTANCE);
        if (!(grInLeft instanceof LeafPsiElement)) {
            return null;
        }
        IElementType elementType = ((LeafPsiElement)grInLeft).getElementType();
        if (elementType == GspTokenTypes.GSTRING_DOLLAR) {
            return PsiType.getJavaLangString((PsiManager)grInLeft.getManager(), (GlobalSearchScope)grInLeft.getResolveScope());
        }
        if (!(grInLeft instanceof OuterLanguageElement) && elementType != GspTokenTypes.GEXPR_BEGIN) {
            return null;
        }
        PsiElement grIn = grInLeft.getNextSibling();
        if (!(grIn instanceof GrGspExprInjection)) {
            return null;
        }
        GrExpression expression = ((GrGspExprInjection)grIn).getExpression();
        if (expression == null) {
            return null;
        }
        if (expression instanceof GrConditionalExpression && (cExpr = (GrConditionalExpression)expression).getThenBranch() == null && cExpr.getElseBranch() == null) {
            return cExpr.getCondition().getType();
        }
        return expression.getType();
    }

    @NotNull
    public static PsiType getElementTypeByCollectionType(@NotNull PsiType psiType, Project project, @NotNull GlobalSearchScope scope2) {
        if (psiType == null) {
            GrailsPsiUtil.$$$reportNull$$$0(12);
        }
        if (scope2 == null) {
            GrailsPsiUtil.$$$reportNull$$$0(13);
        }
        if (psiType instanceof PsiArrayType) {
            PsiType psiType2 = ((PsiArrayType)psiType).getComponentType();
            if (psiType2 == null) {
                GrailsPsiUtil.$$$reportNull$$$0(14);
            }
            return psiType2;
        }
        PsiType res = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)true);
        if (res != null) {
            PsiType psiType3 = res;
            if (psiType3 == null) {
                GrailsPsiUtil.$$$reportNull$$$0(15);
            }
            return psiType3;
        }
        if (!(psiType instanceof PsiClassType)) {
            PsiType psiType4 = psiType;
            if (psiType4 == null) {
                GrailsPsiUtil.$$$reportNull$$$0(16);
            }
            return psiType4;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = facade.getElementFactory();
        PsiClassType typeMap = factory.createTypeByFQClassName("java.util.Map", scope2);
        if (typeMap.isAssignableFrom(psiType)) {
            PsiClassType psiClassType = factory.createTypeByFQClassName("java.util.Map.Entry", scope2);
            if (psiClassType == null) {
                GrailsPsiUtil.$$$reportNull$$$0(17);
            }
            return psiClassType;
        }
        PsiType psiType5 = psiType;
        if (psiType5 == null) {
            GrailsPsiUtil.$$$reportNull$$$0(18);
        }
        return psiType5;
    }

    public static void removeValuesFromList(Collection<String> c, GrListOrMap listOrMap) {
        for (GrExpression expression : listOrMap.getInitializers()) {
            Object value;
            if (!(expression instanceof GrLiteralImpl) || !((value = ((GrLiteralImpl)expression).getValue()) instanceof String)) continue;
            String sValue = (String)value;
            c.remove(sValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiClass";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectType";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/util/GrailsPsiUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/util/GrailsPsiUtil";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypeByCollectionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processLogVariable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enhance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCandidateMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeExpressionType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getElementTypeByCollectionType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

