/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspAttributeValue;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GrailsPatterns {
    private static final InitialPatternCondition CONDITION = new InitialPatternCondition<GspAttributeValue>(GspAttributeValue.class){

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof GspAttributeValue;
        }
    };

    private GrailsPatterns() {
    }

    public static XmlAttributeValuePattern gspAttributeValue(ElementPattern<? extends XmlAttribute> attributePattern) {
        return (XmlAttributeValuePattern)GrailsPatterns.gspAttributeValue().withParent(attributePattern);
    }

    public static PsiFilePattern.Capture<PsiFile> buildConfig() {
        return new PsiFilePattern.Capture((InitialPatternCondition)new InitialPatternCondition<PsiFile>(PsiFile.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof GroovyFileBase && GrailsUtils.isBuildConfigFile((PsiFile)o);
            }
        });
    }

    public static PsiClassPattern artifact(final @NotNull GrailsArtifact artifact) {
        if (artifact == null) {
            GrailsPatterns.$$$reportNull$$$0(0);
        }
        return (PsiClassPattern)PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("Grails artifact"){

            public boolean accepts(@NotNull PsiClass aClass, ProcessingContext context) {
                if (aClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                return artifact.isInstance(aClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/util/GrailsPatterns$2", "accepts"));
            }
        });
    }

    public static XmlAttributeValuePattern gspAttributeValue() {
        return new XmlAttributeValuePattern(CONDITION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/plugins/grails/util/GrailsPatterns", "artifact"));
    }
}

