/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelegateReference
extends PsiReferenceBase<PsiElement> {
    private volatile boolean myDelegateInit;
    private volatile PsiReference myDelegate;
    private Boolean mySoft;

    public DelegateReference(PsiElement element, TextRange range) {
        super(element, range);
    }

    public DelegateReference(@NotNull PsiElement element) {
        if (element == null) {
            DelegateReference.$$$reportNull$$$0(0);
        }
        super(element);
    }

    public DelegateReference(@NotNull PsiElement element, boolean isSoft) {
        if (element == null) {
            DelegateReference.$$$reportNull$$$0(1);
        }
        super(element);
        this.mySoft = isSoft;
    }

    @Nullable
    protected abstract PsiReference createDelegate();

    private void ensureInit() {
        if (this.myDelegateInit) {
            return;
        }
        this.myDelegate = this.createDelegate();
        this.myDelegateInit = true;
    }

    public PsiElement resolve() {
        this.ensureInit();
        return this.myDelegate == null ? null : this.myDelegate.resolve();
    }

    @NotNull
    public Object[] getVariants() {
        this.ensureInit();
        Object[] objectArray = this.myDelegate == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : this.myDelegate.getVariants();
        if (objectArray == null) {
            DelegateReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.ensureInit();
        return this.myDelegate == null ? this.myElement : this.myDelegate.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            DelegateReference.$$$reportNull$$$0(3);
        }
        this.ensureInit();
        return this.myDelegate == null ? this.myElement : this.myDelegate.bindToElement(element);
    }

    public boolean isReferenceTo(PsiElement element) {
        this.ensureInit();
        return this.myDelegate != null && this.myDelegate.isReferenceTo(element);
    }

    public boolean isSoft() {
        if (this.mySoft != null) {
            return this.mySoft;
        }
        this.ensureInit();
        return this.myDelegate == null || this.myDelegate.isSoft();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/util/DelegateReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/util/DelegateReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

