/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.tests.runner;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationType;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.tests.runner.ByClassKt;
import org.jetbrains.plugins.grails.tests.runner.ByDirectoryKt;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrailsTestConfigurationProducer
extends RunConfigurationProducer<GrailsRunConfiguration> {
    public GrailsTestConfigurationProducer() {
        super((ConfigurationType)GrailsRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(GrailsRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElementRef) {
        String vmParameters;
        GrailsApplication application = GrailsApplicationManager.findApplication(context.getPsiLocation());
        if (application == null) {
            return false;
        }
        PsiElement sourceElement = this.setupConfigurationFromContext0(configuration, application, context);
        if (sourceElement == null) {
            return false;
        }
        configuration.setGrailsApplication(application);
        sourceElementRef.set((Object)sourceElement);
        if (application.getGrailsVersion().isAtLeast("1.3.0")) {
            String parameters = configuration.getProgramParameters();
            configuration.setProgramParameters(parameters == null ? null : parameters + " -echoOut");
        }
        if (StringUtil.isEmpty((String)(vmParameters = configuration.getVMParameters()))) {
            configuration.setVMParameters("-Dgrails.full.stacktrace=true");
        } else if (!vmParameters.contains("-Dgrails.full.stacktrace=true")) {
            configuration.setVMParameters(vmParameters + ' ' + "-Dgrails.full.stacktrace=true");
        }
        return true;
    }

    @Nullable
    protected PsiElement setupConfigurationFromContext0(@NotNull GrailsRunConfiguration configuration, @NotNull GrailsApplication application, @NotNull ConfigurationContext context) {
        PsiElement element;
        if (configuration == null) {
            GrailsTestConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (application == null) {
            GrailsTestConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GrailsTestConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((element = context.getPsiLocation()) == null) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            if (ByDirectoryKt.setupConfigurationByDir(configuration, application, (PsiDirectory)element)) {
                return element;
            }
            return null;
        }
        PsiClass psiClass = null;
        PsiFile file = element.getContainingFile();
        if (file instanceof GroovyFile) {
            PsiClass[] groovyFile = (PsiClass[])file;
            if (!groovyFile.isScript()) {
                for (GrTypeDefinition typeDefinition : groovyFile.getTypeDefinitions()) {
                    if (!(typeDefinition instanceof GrClassDefinition) || !GrailsTestConfigurationProducer.isGrailsTestClass((PsiClass)typeDefinition)) continue;
                    psiClass = typeDefinition;
                    break;
                }
            }
        } else if (file instanceof PsiJavaFile) {
            for (PsiClass aClass : ((PsiJavaFile)file).getClasses()) {
                if (!GrailsTestConfigurationProducer.isGrailsTestClass(aClass)) continue;
                psiClass = aClass;
                break;
            }
        }
        if (psiClass == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        return ByClassKt.setupConfigurationByClass(configuration, application, psiClass, method);
    }

    private static String cleanCmd(@Nullable String cmd) {
        return cmd == null ? null : cmd.replace("-echoOut", "").replaceAll("\\s+", " ").trim();
    }

    public boolean isConfigurationFromContext(GrailsRunConfiguration configuration, ConfigurationContext context) {
        GrailsApplication application = GrailsApplicationManager.findApplication(context.getPsiLocation());
        if (application == null || !application.equals(configuration.getGrailsApplicationNullable())) {
            return false;
        }
        if (configuration.getVMParameters() == null) {
            return false;
        }
        GrailsRunConfiguration tmp = new GrailsRunConfiguration(context.getProject(), this.getConfigurationFactory(), "tmp");
        if (this.setupConfigurationFromContext0(tmp, application, context) == null) {
            return false;
        }
        return Objects.equals(GrailsTestConfigurationProducer.cleanCmd(tmp.getProgramParameters()), GrailsTestConfigurationProducer.cleanCmd(configuration.getProgramParameters()));
    }

    public static boolean isGrailsTestClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GrailsTestConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!GrailsUtils.isInGrailsTests((PsiElement)psiClass)) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"grails.test.mixin.TestFor", (boolean)false, (boolean)true)) {
            return true;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"grails.buildtestdata.mixin.Build", (boolean)false, (boolean)true)) {
            return true;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"grails.test.mixin.TestMixin", (boolean)false, (boolean)true)) {
            return true;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"grails.test.mixin.Mock", (boolean)false, (boolean)true)) {
            return true;
        }
        String name = psiClass.getName();
        if (name == null) {
            return false;
        }
        if (name.matches(".+(Spec|Specification)")) {
            return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"spock.lang.Specification");
        }
        if (!name.matches(".+Tests?")) {
            return false;
        }
        if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"junit.framework.TestCase") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"spock.lang.Specification")) {
            return true;
        }
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (psiMethod.getModifierList().findAnnotation("org.junit.Test") == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isGrailsTestMethod(@NotNull PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            GrailsTestConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((aClass = method.getContainingClass()) == null) {
            return false;
        }
        Project project = aClass.getProject();
        return SpockUtils.isTestMethod((PsiElement)method) || JUnitUtil.isTestMethod((Location)new MethodLocation(project, method, (Location)new PsiLocation(project, (PsiElement)aClass)), (boolean)true, (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/tests/runner/GrailsTestConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext0";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isGrailsTestClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isGrailsTestMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

