/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.ui;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.ui.GrailsApplicationCombobox;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditorListener;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditorWithListener;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsRunConfigurationEditor
extends GrailsRunConfigurationEditorWithListener {
    private JPanel myMainPanel;
    private JBLabel myApplicationLabel;
    private GrailsApplicationCombobox myApplicationsCombo;
    private JBLabel myCommandLineLabel;
    private JTextField myCommandLine;
    private JBLabel myVMParametersLabel;
    private RawCommandLineEditor myVMParameters;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private JBCheckBox myLaunchBrowser;
    private JBTextField myLaunchBrowserUrl;
    private JBLabel myOptionsLabel;
    private JPanel myExtensionPanel;
    private final Collection<SettingsEditor<GrailsRunConfiguration>> myExtensionEditors;

    public GrailsRunConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        this.myExtensionEditors = ContainerUtil.newArrayList();
        this.myApplicationsCombo.setApplications(GrailsApplicationManager.getInstance(project).getApplications());
        this.myApplicationsCombo.addItemListener(e -> this.applicationChanged(this.getApplication()));
        this.myCommandLine.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GrailsRunConfigurationEditor.this.commandLineChanged(GrailsRunConfigurationEditor.this.getCommandLine());
            }
        });
        this.myVMParameters.setDialogCaption("VM Options");
        this.myLaunchBrowser.addChangeListener(e -> this.myLaunchBrowserUrl.setEnabled(this.myLaunchBrowser.isEnabled() && this.myLaunchBrowser.isSelected()));
        this.setAnchor();
    }

    private void setAnchor() {
        JBLabel[] components;
        double maxWidth = -1.0;
        JBLabel anchor = null;
        for (JBLabel candidate : components = (JBLabel[])ContainerUtil.ar((Object[])new JBLabel[]{this.myApplicationLabel, this.myCommandLineLabel, this.myVMParametersLabel, this.myEnvVariablesComponent.getLabel()})) {
            double width = candidate.getPreferredSize().getWidth();
            if (!(width > maxWidth)) continue;
            maxWidth = width;
            anchor = candidate;
        }
        if (anchor != null) {
            for (JBLabel component : components) {
                component.setAnchor((JComponent)anchor);
            }
        }
    }

    protected void resetEditorFrom(@NotNull GrailsRunConfiguration configuration) {
        if (configuration == null) {
            GrailsRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        GrailsApplication application = configuration.getGrailsApplicationNullable();
        this.myApplicationsCombo.setSelectedApplication(application);
        if (application == null) {
            this.applicationChanged(null);
        }
        this.myCommandLine.setText(configuration.getProgramParameters());
        this.myVMParameters.setText(configuration.getVMParameters());
        this.myEnvVariablesComponent.setEnvs(new HashMap(configuration.getEnvs()));
        this.myEnvVariablesComponent.setPassParentEnvs(configuration.isPassParentEnvs());
        this.myLaunchBrowser.setSelected(configuration.isLaunchBrowser());
        this.myLaunchBrowserUrl.setText(configuration.getLaunchBrowserUrl());
        this.myExtensionEditors.forEach(e -> {
            if (configuration == null) {
                GrailsRunConfigurationEditor.$$$reportNull$$$0(5);
            }
            e.resetFrom((Object)configuration);
        });
    }

    protected void applyEditorTo(@NotNull GrailsRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            GrailsRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        configuration.setGrailsApplication(this.getApplication());
        configuration.setVMParameters(this.myVMParameters.getText().trim());
        configuration.setProgramParameters(this.myCommandLine.getText().trim());
        configuration.setEnvs(this.myEnvVariablesComponent.getEnvs());
        configuration.setPassParentEnvs(this.myEnvVariablesComponent.isPassParentEnvs());
        configuration.setLaunchBrowser(this.myLaunchBrowser.isSelected());
        configuration.setLaunchBrowserUrl(this.myLaunchBrowserUrl.getText());
        for (SettingsEditor<GrailsRunConfiguration> editor : this.myExtensionEditors) {
            editor.applyTo((Object)configuration);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            GrailsRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    public void applicationChanged(GrailsApplication application) {
        for (SettingsEditor<GrailsRunConfiguration> editor : this.myExtensionEditors) {
            if (!(editor instanceof GrailsRunConfigurationEditorListener)) continue;
            ((GrailsRunConfigurationEditorListener)editor).applicationChanged(application);
        }
        this.checkExtensionPanel();
    }

    @Override
    public void commandLineChanged(String commandLine) {
        GrailsRunConfigurationEditor.setCBEnabled("run-app".equals(MvcCommand.parse((String)commandLine).getCommand()), (JCheckBox)this.myLaunchBrowser);
        for (SettingsEditor<GrailsRunConfiguration> editor : this.myExtensionEditors) {
            if (!(editor instanceof GrailsRunConfigurationEditorListener)) continue;
            ((GrailsRunConfigurationEditorListener)editor).commandLineChanged(commandLine);
        }
        this.checkExtensionPanel();
    }

    private void checkExtensionPanel() {
        boolean hasActiveExtensionEditors = this.hasActiveExtensionEditors();
        this.myOptionsLabel.setVisible(hasActiveExtensionEditors);
        this.myExtensionPanel.setVisible(hasActiveExtensionEditors);
    }

    private boolean hasActiveExtensionEditors() {
        for (Component component : this.myExtensionPanel.getComponents()) {
            if (!component.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void addExtension(@NotNull SettingsEditor<GrailsRunConfiguration> editor) {
        if (editor == null) {
            GrailsRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        Disposer.register((Disposable)this, editor);
        this.myExtensionEditors.add(editor);
        this.myExtensionPanel.add((Component)editor.getComponent(), "First");
    }

    @Nullable
    private GrailsApplication getApplication() {
        return this.myApplicationsCombo.getSelectedApplication();
    }

    @NotNull
    private String getCommandLine() {
        String commandLine = StringUtil.trim((String)this.myCommandLine.getText());
        String string = commandLine == null ? "" : commandLine;
        if (string == null) {
            GrailsRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void setCBEnabled(boolean enabled, JCheckBox checkBox) {
        boolean wasEnabled = checkBox.isEnabled();
        checkBox.setEnabled(enabled);
        if (wasEnabled && !enabled) {
            checkBox.setSelected(false);
        } else if (!wasEnabled && enabled) {
            checkBox.setSelected(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/runner/ui/GrailsRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/runner/ui/GrailsRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resetEditorFrom$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox;
        EnvironmentVariablesComponent environmentVariablesComponent;
        RawCommandLineEditor rawCommandLineEditor;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        GrailsApplicationCombobox grailsApplicationCombobox;
        JBLabel jBLabel4;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myApplicationLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Application:");
        jBLabel4.setDisplayedMnemonic('A');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplicationsCombo = grailsApplicationCombobox = new GrailsApplicationCombobox();
        jPanel2.add((Component)((Object)grailsApplicationCombobox), new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myCommandLineLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Command line:");
        jBLabel3.setDisplayedMnemonic('C');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBTextField jBTextField2 = new JBTextField();
        this.myCommandLine = jBTextField2;
        jPanel2.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myVMParametersLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("VM options:");
        jBLabel2.setDisplayedMnemonic('V');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myEnvVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        jPanel2.add((Component)environmentVariablesComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myLaunchBrowser = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Launch browser");
        jBCheckBox.setMnemonic('L');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLaunchBrowserUrl = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        this.myOptionsLabel = jBLabel = new JBLabel();
        jBLabel.setText("Options:");
        jBLabel.setDisplayedMnemonic('O');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        jBLabel4.setLabelFor((Component)((Object)grailsApplicationCombobox));
        jBLabel3.setLabelFor((Component)jBTextField2);
        jBLabel2.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

