/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.urlMappings;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspLinkElementDescriptor;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringContentImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class UrlMappingUtil {
    private static final Key<Pair<Long, Map<String, NamedUrlMapping>>> FILE_KEY = Key.create((String)"Url Mapping file key");
    public static final String GROUP = "group";

    private UrlMappingUtil() {
    }

    public static Map<String, NamedUrlMapping> getNamedUrlMappings(@NotNull Module module) {
        if (module == null) {
            UrlMappingUtil.$$$reportNull$$$0(0);
        }
        Project project = module.getProject();
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                UrlMappingUtil.$$$reportNull$$$0(9);
            }
            return CachedValueProvider.Result.create(UrlMappingUtil.calculateNamedUrlMappings(module), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static Map<String, NamedUrlMapping> calculateNamedUrlMappings(@NotNull Module module) {
        if (module == null) {
            UrlMappingUtil.$$$reportNull$$$0(1);
        }
        HashMap<String, NamedUrlMapping> res = new HashMap<String, NamedUrlMapping>();
        for (GrClassDefinition classDefinition : GrailsArtifact.URLMAPPINGS.getInstances(module).values()) {
            UrlMappingUtil.addMapping(res, (PsiClass)classDefinition);
        }
        return res;
    }

    private static void addMapping(Map<String, NamedUrlMapping> res, PsiClass aClass) {
        PsiFile file = aClass.getContainingFile().getOriginalFile();
        Pair pair = (Pair)file.getUserData(FILE_KEY);
        if (pair == null || ((Long)pair.first).longValue() != file.getModificationStamp()) {
            Map<String, NamedUrlMapping> map2 = UrlMappingUtil.loadMapping(aClass);
            pair = new Pair((Object)file.getModificationStamp(), map2);
            file.putUserData(FILE_KEY, (Object)pair);
        }
        res.putAll((Map)pair.second);
    }

    private static Map<String, NamedUrlMapping> loadMapping(PsiClass aClass) {
        HashMap<String, NamedUrlMapping> res = new HashMap<String, NamedUrlMapping>();
        PsiField field = aClass.findFieldByName("mappings", false);
        if (!(field instanceof GrField) || !field.hasModifierProperty("static")) {
            return Collections.emptyMap();
        }
        GrExpression initializer = ((GrField)field).getInitializerGroovy();
        if (!(initializer instanceof GrClosableBlock)) {
            return Collections.emptyMap();
        }
        for (PsiElement e = initializer.getFirstChild(); e != null; e = e.getNextSibling()) {
            GrExpression expr;
            GrNamedArgument na;
            GrArgumentLabel label;
            GrArgumentList arguments;
            GrNamedArgument[] namedArguments;
            GrMethodCall method;
            if (!(e instanceof GrMethodCall) || !PsiUtil.isReferenceWithoutQualifier((PsiElement)(method = (GrMethodCall)e).getInvokedExpression(), (String)"name") || (namedArguments = (arguments = method.getArgumentList()).getNamedArguments()).length != 1 || (label = (na = namedArguments[0]).getLabel()) == null || !((expr = na.getExpression()) instanceof GrMethodCall)) continue;
            GrMethodCall innerMethod = (GrMethodCall)expr;
            String name = label.getName();
            Map<String, Pair<PsiElement, Boolean>> params = UrlMappingUtil.getParamsByInvokedExpression(innerMethod.getInvokedExpression());
            if (params == null) continue;
            res.put(name, new NamedUrlMapping(name, (PsiElement)label, params));
        }
        return res;
    }

    @Nullable
    public static Map<String, Pair<PsiElement, Boolean>> getParamsByInvokedExpression(@Nullable GrExpression invokedExpression) {
        if (invokedExpression instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)invokedExpression).isQualified()) {
                return null;
            }
            PsiElement referenceNameElement = ((GrReferenceExpression)invokedExpression).getReferenceNameElement();
            if (referenceNameElement == null) {
                return null;
            }
            IElementType elementType = referenceNameElement.getNode().getElementType();
            if (!TokenSets.STRING_LITERAL_SET.contains(elementType)) {
                return null;
            }
            return Collections.emptyMap();
        }
        if (invokedExpression instanceof GrString) {
            HashMap<String, Pair<PsiElement, Boolean>> params = new HashMap<String, Pair<PsiElement, Boolean>>();
            for (PsiElement injection = invokedExpression.getFirstChild(); injection != null; injection = injection.getNextSibling()) {
                String param;
                if (!(injection instanceof GrStringInjection) || (param = UrlMappingUtil.extractName((GrStringInjection)injection)) == null) continue;
                PsiElement next = injection.getNextSibling();
                boolean optional = next instanceof GrStringContentImpl && next.getText().startsWith("?");
                params.put(param, (Pair<PsiElement, Boolean>)Pair.create((Object)injection, (Object)optional));
            }
            return params;
        }
        return null;
    }

    @Nullable
    private static String extractName(GrStringInjection injection) {
        PsiElement dollar = injection.getFirstChild();
        if (dollar == null) {
            return null;
        }
        PsiElement next = dollar.getNextSibling();
        if (next == null || next.getNextSibling() != null) {
            return null;
        }
        if (next instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)next).getQualifierExpression() != null) {
                return null;
            }
            return ((GrReferenceExpression)next).getReferenceName();
        }
        if (!(next instanceof GrClosableBlock)) {
            return null;
        }
        PsiElement closureStart = next.getFirstChild();
        if (closureStart == null) {
            return null;
        }
        PsiElement ref = closureStart.getNextSibling();
        if (ref instanceof GrParameterList) {
            ref = ref.getNextSibling();
        }
        if (!(ref instanceof GrReferenceExpression)) {
            return null;
        }
        PsiElement closureEnd = ref.getNextSibling();
        if (closureEnd == null || closureEnd.getNextSibling() != null) {
            return null;
        }
        if (((GrReferenceExpression)ref).getQualifierExpression() != null) {
            return null;
        }
        return ((GrReferenceExpression)ref).getReferenceName();
    }

    public static boolean isMappingDefinition(@NotNull GrMethodCall methodCall) {
        PsiElement parent;
        GrExpression invokedExpression;
        if (methodCall == null) {
            UrlMappingUtil.$$$reportNull$$$0(2);
        }
        if ((invokedExpression = methodCall.getInvokedExpression()) instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)invokedExpression).isQualified()) {
                return false;
            }
            PsiElement referenceNameElement = ((GrReferenceExpression)invokedExpression).getReferenceNameElement();
            if (referenceNameElement == null) {
                return false;
            }
            IElementType type = referenceNameElement.getNode().getElementType();
            if (!TokenSets.STRING_LITERAL_SET.contains(type)) {
                return false;
            }
        } else if (!(invokedExpression instanceof GrStringImpl)) {
            return false;
        }
        if (!((parent = methodCall.getParent()) instanceof GrClosableBlock)) {
            if (!(parent instanceof GrNamedArgument)) {
                return false;
            }
            GrMethodCall mc = PsiUtil.getMethodCallByNamedParameter((GrNamedArgument)((GrNamedArgument)parent));
            if (mc == null) {
                return false;
            }
            if (!PsiUtil.isReferenceWithoutQualifier((PsiElement)mc.getInvokedExpression(), (String)"name")) {
                return false;
            }
            parent = mc.getParent();
            if (!(parent instanceof GrClosableBlock)) {
                return false;
            }
        }
        parent = UrlMappingUtil.unwrapCloseableBlock((GrClosableBlock)parent);
        return UrlMappingUtil.isMappingField((GrClosableBlock)parent);
    }

    @NotNull
    private static GrClosableBlock unwrapCloseableBlock(@NotNull GrClosableBlock block) {
        PsiElement parent;
        if (block == null) {
            UrlMappingUtil.$$$reportNull$$$0(3);
        }
        if ((parent = block.getParent()) instanceof GrArgumentList) {
            parent = parent.getParent();
        }
        if (!(parent instanceof GrMethodCall)) {
            GrClosableBlock grClosableBlock = block;
            if (grClosableBlock == null) {
                UrlMappingUtil.$$$reportNull$$$0(4);
            }
            return grClosableBlock;
        }
        String methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)((GrMethodCall)parent));
        if (!GROUP.equals(methodName)) {
            GrClosableBlock grClosableBlock = block;
            if (grClosableBlock == null) {
                UrlMappingUtil.$$$reportNull$$$0(5);
            }
            return grClosableBlock;
        }
        PsiElement groupParent = parent.getParent();
        if (groupParent instanceof GrClosableBlock) {
            GrClosableBlock grClosableBlock = (GrClosableBlock)groupParent;
            if (grClosableBlock == null) {
                UrlMappingUtil.$$$reportNull$$$0(6);
            }
            return grClosableBlock;
        }
        GrClosableBlock grClosableBlock = block;
        if (grClosableBlock == null) {
            UrlMappingUtil.$$$reportNull$$$0(7);
        }
        return grClosableBlock;
    }

    public static boolean isMappingField(@NotNull GrClosableBlock closure) {
        PsiElement field;
        if (closure == null) {
            UrlMappingUtil.$$$reportNull$$$0(8);
        }
        if (!((field = closure.getParent()) instanceof GrField)) {
            return false;
        }
        if (!"mappings".equals(((GrField)field).getName())) {
            return false;
        }
        PsiClass aClass = ((GrField)field).getContainingClass();
        return GrailsArtifact.URLMAPPINGS.isInstance(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapCloseableBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamedUrlMappings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateNamedUrlMappings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMappingDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unwrapCloseableBlock";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMappingField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNamedUrlMappings$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NamedUrlMapping {
        private final String myName;
        private final PsiElement myElement;
        private final AtomicNotNullLazyValue<XmlElementDescriptor> myElementDescriptor;

        public NamedUrlMapping(String name, PsiElement element, Map<String, Pair<PsiElement, Boolean>> params) {
            this.myName = name;
            this.myElement = element;
            this.myElementDescriptor = AtomicNotNullLazyValue.createValue(() -> new GspLinkElementDescriptor(name, element, params));
        }

        public String getName() {
            return this.myName;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        @NotNull
        public XmlElementDescriptor getElementDescriptor() {
            XmlElementDescriptor xmlElementDescriptor = (XmlElementDescriptor)this.myElementDescriptor.getValue();
            if (xmlElementDescriptor == null) {
                NamedUrlMapping.$$$reportNull$$$0(0);
            }
            return xmlElementDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/urlMappings/UrlMappingUtil$NamedUrlMapping", "getElementDescriptor"));
        }
    }
}

