/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain.criteria;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.domain.criteria.CriteriaBuilderImplicitMemberContributor;
import org.jetbrains.plugins.grails.references.domain.criteria.CriteriaBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

public class CriteriaReturnTypeCalculator
implements GrTypeCalculator<GrMethodCall> {
    @Nullable
    public PsiType getType(@NotNull GrMethodCall callExpression) {
        if (callExpression == null) {
            CriteriaReturnTypeCalculator.$$$reportNull$$$0(0);
        }
        PsiMethod method = callExpression.resolveMethod();
        GrExpression[] arguments = PsiUtil.getAllArguments((GrCall)callExpression);
        if (arguments.length == 0) {
            return null;
        }
        int i = 0;
        if (arguments[0] == null || InheritanceUtil.isInheritor((PsiType)arguments[0].getType(), (String)"java.util.Map")) {
            ++i;
        }
        if (i != arguments.length - 1 || !(arguments[i] instanceof GrClosableBlock)) {
            return null;
        }
        GrClosableBlock closure = (GrClosableBlock)arguments[i];
        GrExpression invokedExpression = callExpression.getInvokedExpression();
        if (invokedExpression instanceof GrReferenceExpression && method != null) {
            if (CriteriaBuilderImplicitMemberContributor.isMine(method)) {
                PsiType returnType = method.getReturnType();
                assert (returnType != null);
                boolean isList = returnType.equalsToText("java.util.List");
                if (!isList && !returnType.equalsToText("java.lang.Object")) {
                    return null;
                }
                PsiClass domainClass = CriteriaBuilderUtil.findDomainClassByMethodCall(callExpression, true);
                if (domainClass == null) {
                    return null;
                }
                return CriteriaReturnTypeCalculator.createType(isList, domainClass, closure);
            }
            if (GrLightMethodBuilder.checkKind((PsiElement)method, (Object)DomainDescriptor.DOMAIN_DYNAMIC_METHOD) && "withCriteria".equals(method.getName())) {
                PsiClass domainClass = (PsiClass)((GrLightMethodBuilder)method).getData();
                if (!GormUtils.isGormBean(domainClass)) {
                    return null;
                }
                assert (domainClass != null);
                boolean isList = true;
                for (GrNamedArgument namedArgument : PsiUtil.getFirstMapNamedArguments((GrCall)callExpression)) {
                    if (!"uniqueResult".equals(namedArgument.getLabelName())) continue;
                    GrExpression expression = namedArgument.getExpression();
                    if (!(expression instanceof GrLiteralImpl) || !Boolean.TRUE.equals(((GrLiteralImpl)expression).getValue())) break;
                    isList = false;
                    break;
                }
                return CriteriaReturnTypeCalculator.createType(isList, domainClass, closure);
            }
            return null;
        }
        if (!InheritanceUtil.isInheritor((PsiType)invokedExpression.getType(), (String)"grails.orm.HibernateCriteriaBuilder")) {
            return null;
        }
        PsiClass domainClass = CriteriaBuilderUtil.findDomainClassByBuilderExpression(invokedExpression);
        if (domainClass == null) {
            return null;
        }
        return CriteriaReturnTypeCalculator.createType(true, domainClass, closure);
    }

    @Nullable
    private static PsiType createType(boolean isList, @NotNull PsiClass domainClass, @NotNull GrClosableBlock closure) {
        if (domainClass == null) {
            CriteriaReturnTypeCalculator.$$$reportNull$$$0(1);
        }
        if (closure == null) {
            CriteriaReturnTypeCalculator.$$$reportNull$$$0(2);
        }
        PsiType elementType = CriteriaBuilderUtil.getResultType(domainClass, closure);
        if (!isList) {
            return elementType;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)domainClass.getProject());
        PsiClass listClass = facade.findClass("java.util.List", domainClass.getResolveScope());
        if (listClass == null) {
            return null;
        }
        return facade.getElementFactory().createType(listClass, elementType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/references/domain/criteria/CriteriaReturnTypeCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

