/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.references.common.PluginSupportFileReferenceSet;

public class ContextPathReferenceProvider
extends PsiReferenceProvider {
    public static PsiReference[] createReferences(@NotNull PsiElement element) {
        if (element == null) {
            ContextPathReferenceProvider.$$$reportNull$$$0(0);
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        return ContextPathReferenceProvider.createReferences(element, text, offset);
    }

    public static PsiReference[] createReferences(@NotNull PsiElement element, @NotNull String text, int offset) {
        String trimedUrl;
        if (element == null) {
            ContextPathReferenceProvider.$$$reportNull$$$0(1);
        }
        if (text == null) {
            ContextPathReferenceProvider.$$$reportNull$$$0(2);
        }
        if ((trimedUrl = PathReference.trimPath((String)text)).trim().length() == 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        PluginSupportFileReferenceSet set = new PluginSupportFileReferenceSet(trimedUrl, element, offset, null, true, false, true){

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                VirtualFile root;
                if (!this.isAbsolutePathReference()) {
                    Set<PsiFileSystemItem> set = Collections.emptySet();
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }
                VirtualFile appDir = GrailsFramework.getInstance().findAppDirectory(this.getElement());
                if (appDir == null) {
                    Set<PsiFileSystemItem> set = Collections.emptySet();
                    if (set == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return set;
                }
                PsiManager manager = this.getElement().getManager();
                ArrayList<PsiFileSystemItem> res = new ArrayList<PsiFileSystemItem>(2);
                VirtualFile view = appDir.findChild("views");
                if (view != null) {
                    ContainerUtil.addIfNotNull(res, (Object)manager.findDirectory(view));
                }
                if ((root = appDir.getParent()) != null) {
                    ContainerUtil.addIfNotNull(res, (Object)manager.findDirectory(root));
                }
                ArrayList<PsiFileSystemItem> arrayList = res;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(2);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider$1", "computeDefaultContexts"));
            }
        };
        return set.getAllReferences();
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            ContextPathReferenceProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ContextPathReferenceProvider.$$$reportNull$$$0(4);
        }
        PsiReference[] psiReferenceArray = ContextPathReferenceProvider.createReferences(element);
        if (psiReferenceArray == null) {
            ContextPathReferenceProvider.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/common/ContextPathReferenceProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

