/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.pluginSupport.resources;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.ModuleCachedValue;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrRenamableLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GrailsResourcesUtil {
    private static final LightCacheKey<Map<String, PsiMethod>> ONE_RESOURCE_FILE_CACHE = LightCacheKey.createByFileModificationCount();
    public static final String MODULES_LIST_VARIABLE_IN_CONFIG = "grails.resources.modules";
    public static final String MODULE_BUILDER_CLASS = "org.grails.plugin.resource.module.ModuleBuilder";
    public static final String MODULE_METHOD_KIND = "grails:GrailsResourcesUtil:module";
    private static final ModuleCachedValue<Map<String, PsiMethod>> CACHED_VALUE = new ModuleCachedValue<Map<String, PsiMethod>>(PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT){

        @Override
        protected Map<String, PsiMethod> calculate(Module element) {
            return GrailsResourcesUtil.calculateResources(element);
        }
    };
    public static final String MODULES_LIST_VARIABLE = "modules";

    private GrailsResourcesUtil() {
    }

    private static void collectResourcesModules(Map<String, PsiMethod> result2, GrClosableBlock closure) {
        for (PsiElement e = closure.getFirstChild(); e != null; e = e.getNextSibling()) {
            GrMethodCall methodCall;
            GrClosableBlock closureArgument;
            if (!(e instanceof GrMethodCall) || (closureArgument = GrailsUtils.getClosureArgument(methodCall = (GrMethodCall)e)) == null) continue;
            GrExpression invokedExpression = methodCall.getInvokedExpression();
            if (!(invokedExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression ref = (GrReferenceExpression)invokedExpression;
            if (ref.isQualified()) {
                return;
            }
            String name = ref.getReferenceName();
            if (name == null) continue;
            GrRenamableLightMethodBuilder method = new GrRenamableLightMethodBuilder(closure.getManager(), name);
            method.addParameter("arg", "groovy.lang.Closure", false);
            method.setNavigationElement((PsiElement)methodCall);
            method.setMethodKind((Object)MODULE_METHOD_KIND);
            result2.put(name, (PsiMethod)method);
        }
    }

    public static boolean isModuleDefinition(GrMethodCall methodCall) {
        PsiElement parent = methodCall.getParent();
        if (!(parent instanceof GrClosableBlock)) {
            return false;
        }
        return GrailsResourcesUtil.isModuleListDefinitionClosure((GrClosableBlock)parent);
    }

    public static boolean isModuleListDefinitionClosure(GrClosableBlock closure) {
        PsiFile aFile;
        VirtualFile virtualFile;
        PsiElement parent = closure.getParent();
        if (!(parent instanceof GrAssignmentExpression)) {
            return false;
        }
        GrAssignmentExpression assExp = (GrAssignmentExpression)parent;
        if (!(assExp.getParent() instanceof GroovyFile)) {
            return false;
        }
        GrExpression lValue = assExp.getLValue();
        if (!(lValue instanceof GrReferenceExpression) || assExp.getOperationTokenType() != GroovyTokenTypes.mASSIGN) {
            return false;
        }
        String refText = lValue.getText();
        return !(refText.equals(MODULES_LIST_VARIABLE) ? !GrailsArtifact.RESOURCES.isInstance(virtualFile = (aFile = assExp.getContainingFile().getOriginalFile()).getVirtualFile(), aFile.getProject()) : refText.equals(MODULES_LIST_VARIABLE_IN_CONFIG) && !GrailsUtils.isConfigGroovyFile((PsiElement)(aFile = assExp.getContainingFile().getOriginalFile())));
    }

    private static void collectResourcesModules(Map<String, PsiMethod> result2, @NotNull VirtualFile virtualFile, @NotNull PsiManager manager, @NotNull String propertyName) {
        PsiFile psiFile;
        if (virtualFile == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(1);
        }
        if (propertyName == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(2);
        }
        if (!((psiFile = manager.findFile(virtualFile)) instanceof GroovyFile)) {
            return;
        }
        Map<String, PsiMethod> modules = GrailsResourcesUtil.extractResourcesModules((GroovyFile)psiFile, propertyName);
        result2.putAll(modules);
    }

    public static Map<String, PsiMethod> extractResourcesModules(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(3);
        }
        String propertyName = groovyFile.getName().equals("Config.groovy") ? MODULES_LIST_VARIABLE_IN_CONFIG : MODULES_LIST_VARIABLE;
        return GrailsResourcesUtil.extractResourcesModules(groovyFile, propertyName);
    }

    private static void collectResourcesModules(Map<String, PsiMethod> result2, @NotNull GrAssignmentExpression assExp, @NotNull String propertyName) {
        GrExpression rValue;
        if (assExp == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(4);
        }
        if (propertyName == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(5);
        }
        if ((rValue = assExp.getRValue()) instanceof GrClosableBlock && assExp.getLValue().getText().equals(propertyName) && assExp.getOperationTokenType() == GroovyTokenTypes.mASSIGN) {
            GrailsResourcesUtil.collectResourcesModules(result2, (GrClosableBlock)rValue);
        }
    }

    private static Map<String, PsiMethod> extractResourcesModules(@NotNull GroovyFile groovyFile, @NotNull String propertyName) {
        HashMap<String, PsiMethod> cachedValue;
        if (groovyFile == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(6);
        }
        if (propertyName == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(7);
        }
        if ((cachedValue = (HashMap)ONE_RESOURCE_FILE_CACHE.getCachedValue((PsiElement)groovyFile)) == null) {
            cachedValue = new HashMap();
            for (GrTopStatement topStatement : groovyFile.getTopStatements()) {
                GrClosableBlock envClosure;
                GrMethodCall methodCall;
                String methodName;
                if (topStatement instanceof GrAssignmentExpression) {
                    GrailsResourcesUtil.collectResourcesModules(cachedValue, (GrAssignmentExpression)topStatement, propertyName);
                    continue;
                }
                if (!(topStatement instanceof GrMethodCall) || !"environments".equals(methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)(methodCall = (GrMethodCall)topStatement))) || (envClosure = GrailsUtils.getClosureArgument(methodCall)) == null) continue;
                for (PsiElement envClosureChild = envClosure.getFirstChild(); envClosureChild != null; envClosureChild = envClosureChild.getNextSibling()) {
                    GrClosableBlock c;
                    GrMethodCall mc;
                    if (!(envClosureChild instanceof GrMethodCall) || !GrailsUtils.ENVIRONMENT_LIST.contains(PsiUtil.getUnqualifiedMethodName((GrMethodCall)(mc = (GrMethodCall)envClosureChild))) || (c = GrailsUtils.getClosureArgument(mc)) == null) continue;
                    for (PsiElement e = c.getFirstChild(); e != null; e = e.getNextSibling()) {
                        if (!(e instanceof GrAssignmentExpression)) continue;
                        GrailsResourcesUtil.collectResourcesModules(cachedValue, (GrAssignmentExpression)e, propertyName);
                    }
                }
            }
            cachedValue = (Map)ONE_RESOURCE_FILE_CACHE.putCachedValue((PsiElement)groovyFile, cachedValue);
        }
        return cachedValue;
    }

    @NotNull
    private static Map<String, PsiMethod> calculateResources(@NotNull Module module) {
        if (module == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(8);
        }
        HashMap<String, PsiMethod> res = new HashMap<String, PsiMethod>();
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        if (GrailsFramework.getInstance().isCommonPluginsModule(module)) {
            for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                VirtualFile configGroovy = VfsUtil.findRelativeFile((VirtualFile)virtualFile, (String[])new String[]{"grails-app", "conf", "Config.groovy"});
                if (configGroovy == null) continue;
                GrailsResourcesUtil.collectResourcesModules(res, configGroovy, manager, MODULES_LIST_VARIABLE_IN_CONFIG);
            }
        } else {
            VirtualFile configGroovy;
            VirtualFile confDirectory = GrailsUtils.findConfDirectory(module);
            if (confDirectory != null && (configGroovy = confDirectory.findChild("Config.groovy")) != null) {
                GrailsResourcesUtil.collectResourcesModules(res, configGroovy, manager, MODULES_LIST_VARIABLE_IN_CONFIG);
            }
        }
        for (VirtualFile virtualFile : GrailsArtifact.RESOURCES.getVirtualFileMap(module).values()) {
            GrailsResourcesUtil.collectResourcesModules(res, virtualFile, manager, MODULES_LIST_VARIABLE);
        }
        HashMap<String, PsiMethod> hashMap = res;
        if (hashMap == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    public static Map<String, PsiMethod> getResources(@NotNull Module module) {
        if (module == null) {
            GrailsResourcesUtil.$$$reportNull$$$0(10);
        }
        return (Map)CACHED_VALUE.get(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovyFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assExp";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateResources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectResourcesModules";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractResourcesModules";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateResources";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

