/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.xml.ui.Committable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassDependencyPresentation;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassesRelationsDataModel;

public class PerspectiveFileEditorComponent
extends JPanel
implements DataProvider,
Committable {
    private final GraphBuilder<DomainClassNode, DomainClassRelationsInfo> myBuilder;
    private final DomainClassesRelationsDataModel myDataModel;
    private final Project myProject;
    private final PsiTreeChangeAdapter myListener;
    @NonNls
    private static final String HELP_ID = "reference.persistencediagram";

    public PerspectiveFileEditorComponent(@Nullable VirtualFile domainDirectory, Project project) {
        this.myProject = project;
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
        this.myDataModel = new DomainClassesRelationsDataModel(domainDirectory, this.myProject);
        DomainClassDependencyPresentation presentationModel = new DomainClassDependencyPresentation((Graph)graph, this.myDataModel);
        this.myBuilder = GraphBuilderFactory.getInstance((Project)this.myProject).createGraphBuilder(graph, view, (GraphDataModel)this.myDataModel, (GraphPresentationModel)presentationModel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbarPanel(), "North");
        this.add(this.myBuilder.getView().getComponent(), "Center");
        this.myListener = new PsiTreeChangeAdapter(){

            public void childrenChanged(@NotNull PsiTreeChangeEvent psiTreeChangeEvent) {
                if (psiTreeChangeEvent == null) {
                    1.$$$reportNull$$$0(0);
                }
                PerspectiveFileEditorComponent.this.update();
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                PerspectiveFileEditorComponent.this.update();
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                PerspectiveFileEditorComponent.this.update();
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                PerspectiveFileEditorComponent.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiTreeChangeEvent";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/grails/perspectives/PerspectiveFileEditorComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this.myListener, (Disposable)this);
        Disposer.register((Disposable)this, this.myBuilder);
        this.myBuilder.initialize();
    }

    private void update() {
        if (this.isShowing()) {
            this.myBuilder.queueUpdate();
        }
    }

    private JComponent createToolbarPanel() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)GraphViewUtil.getBasicToolbar((Graph2D)this.myBuilder.getGraph()));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("GrailsPerspectives", (ActionGroup)actions, true);
        return actionToolbar.getComponent();
    }

    @Nullable
    public Object getData(@NonNls String s2) {
        if (DataKeys.HELP_ID.is(s2)) {
            return HELP_ID;
        }
        return null;
    }

    public void commit() {
    }

    public void reset() {
        this.myBuilder.updateGraph();
    }

    public void dispose() {
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this.myListener);
    }

    public Overview getOverview() {
        return GraphManager.getGraphManager().createOverview(this.myBuilder.getView());
    }

    public DomainClassesRelationsDataModel getDataModel() {
        return this.myDataModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    public GraphBuilder<DomainClassNode, DomainClassRelationsInfo> getBuilder() {
        return this.myBuilder;
    }
}

