/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi.groovy.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspGroovyFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspTag;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class GspPageSkeleton {
    private TIntArrayList defOffsets;
    private List<DefTagDescription> defTags;
    private final TIntArrayList offsetsEach = new TIntArrayList();
    private final List<TagDescription> eachTag = new ArrayList<TagDescription>();

    GspPageSkeleton(GspGroovyFile gspGroovyFile) {
        this.processTag(gspGroovyFile.getGspLanguageRoot().getRootTag(), 0, null);
    }

    public boolean processElementAtOffset(int offset, @NotNull PsiScopeProcessor processor, @Nullable String name, @NotNull ResolveState state) {
        if (processor == null) {
            GspPageSkeleton.$$$reportNull$$$0(0);
        }
        if (state == null) {
            GspPageSkeleton.$$$reportNull$$$0(1);
        }
        TagDescription tagDescription = this.getTagDescriptionByOffset(offset);
        while (tagDescription != null) {
            if (!tagDescription.process(processor, name, state)) {
                return false;
            }
            tagDescription = tagDescription.parent;
        }
        if (this.defTags != null) {
            int index = this.defOffsets.binarySearch(offset);
            if (index < 0) {
                index = -(index + 1);
            }
            for (int i = index - 1; i >= 0; --i) {
                DefTagDescription description = this.defTags.get(i);
                if (name != null && !name.equals(description.name) || processor.execute((PsiElement)description.getVariable(), state)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public PsiVariable getVariableByDefTag(GspTag tag) {
        if (this.defTags == null) {
            return null;
        }
        for (DefTagDescription description : this.defTags) {
            if (description.tag != tag) continue;
            return description.getVariable();
        }
        return null;
    }

    @Nullable
    public EachTagDescription getEachTagDescription(GspTag tag) {
        assert (tag.getName().equals("g:each"));
        for (TagDescription description : this.eachTag) {
            if (description == null || description.tag != tag) continue;
            return (EachTagDescription)description;
        }
        return null;
    }

    private void processTag(GspTag tag, int offset, TagDescription parentTagDescription) {
        String defName;
        XmlAttributeValue varAttr;
        PsiElement e;
        String tagName = tag.getName();
        TagDescription descr = parentTagDescription;
        if (tagName.equals("g:findAll") || tagName.equals("g:collect")) {
            descr = new NonEachTagDescription(tag, parentTagDescription);
            for (e = tag.getFirstChild(); e != null; e = e.getNextSibling()) {
                if (e instanceof XmlAttribute) {
                    if (!((XmlAttribute)e).getName().equals("expr")) continue;
                    int attrStart = offset + e.getStartOffsetInParent();
                    this.offsetsEach.add(attrStart);
                    this.eachTag.add(descr);
                    this.offsetsEach.add(attrStart + e.getTextLength() - 1);
                    this.eachTag.add(parentTagDescription);
                    continue;
                }
                if (!(e instanceof XmlToken) || ((XmlToken)e).getTokenType() != XmlTokenType.XML_TAG_END) continue;
                this.offsetsEach.add(offset + e.getStartOffsetInParent());
                this.eachTag.add(descr);
                break;
            }
        } else {
            boolean isEach = tagName.equals("g:each");
            if (isEach || tagName.equals("g:grep")) {
                TagDescription tagDescription = descr = isEach ? new EachTagDescription(tag, parentTagDescription) : new NonEachTagDescription(tag, parentTagDescription);
                while (e != null) {
                    if (e instanceof XmlToken && ((XmlToken)e).getTokenType() == XmlTokenType.XML_TAG_END) {
                        this.offsetsEach.add(offset + e.getStartOffsetInParent());
                        this.eachTag.add(descr);
                        break;
                    }
                    e = e.getNextSibling();
                }
            }
        }
        while (e != null) {
            if (e instanceof GspTag) {
                this.processTag((GspTag)e, offset + e.getStartOffsetInParent(), descr);
            }
            e = e.getNextSibling();
        }
        if (descr != parentTagDescription) {
            this.offsetsEach.add(offset + tag.getTextLength() - 1);
            this.eachTag.add(parentTagDescription);
        }
        if (tagName.equals("g:set") && (varAttr = GrailsPsiUtil.getAttributeValue(tag, "var")) != null && GrailsPsiUtil.isSimpleAttribute(varAttr) && StringUtil.isJavaIdentifier((String)(defName = varAttr.getValue().trim()))) {
            if (this.defTags == null) {
                this.defOffsets = new TIntArrayList();
                this.defTags = new ArrayList<DefTagDescription>();
            }
            this.defOffsets.add(offset + tag.getTextLength() - 1);
            this.defTags.add(new DefTagDescription(tag, defName));
        }
    }

    @Nullable
    private TagDescription getTagDescriptionByOffset(int offset) {
        int index = this.offsetsEach.binarySearch(offset);
        if (index >= 0) {
            return this.eachTag.get(index);
        }
        if ((index = -(index + 1) - 1) == -1) {
            return null;
        }
        return this.eachTag.get(index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/grails/lang/gsp/psi/groovy/impl/GspPageSkeleton";
        objectArray[2] = "processElementAtOffset";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class EachTagDescription
    extends TagDescription {
        private PsiVariable varVariable;
        private PsiVariable statusVariable;
        private volatile boolean isNameInit;
        private PsiElement varNavigationElement;
        private String varName;

        protected EachTagDescription(GspTag tag, TagDescription parent) {
            super(tag, parent);
        }

        private void ensureInit() {
            if (!this.isNameInit) {
                String nameStatus;
                String nameVar;
                XmlAttributeValue attrVar = GrailsPsiUtil.getAttributeValue(this.tag, "var");
                if (attrVar == null) {
                    this.varName = "it";
                } else if (GrailsPsiUtil.isSimpleAttribute(attrVar) && StringUtil.isJavaIdentifier((String)(nameVar = attrVar.getValue().trim()))) {
                    this.varName = nameVar;
                    this.varNavigationElement = attrVar;
                }
                XmlAttributeValue statusAttr = GrailsPsiUtil.getAttributeValue(this.tag, "status");
                if (statusAttr != null && GrailsPsiUtil.isSimpleAttribute(statusAttr) && StringUtil.isJavaIdentifier((String)(nameStatus = statusAttr.getValue().trim()))) {
                    this.statusVariable = new GrLightVariable(this.tag.getManager(), nameStatus, "java.lang.Integer", (PsiElement)statusAttr);
                }
                this.isNameInit = true;
            }
        }

        @Override
        public boolean process(@NotNull PsiScopeProcessor processor, @Nullable String name, @NotNull ResolveState state) {
            PsiVariable varVariable;
            if (processor == null) {
                EachTagDescription.$$$reportNull$$$0(0);
            }
            if (state == null) {
                EachTagDescription.$$$reportNull$$$0(1);
            }
            this.ensureInit();
            if (this.varName != null && (name == null || name.equals(this.varName)) && (varVariable = this.getVarVariable()) != null && !processor.execute((PsiElement)varVariable, state)) {
                return false;
            }
            PsiVariable statusVariable = this.getStatusVariable();
            return statusVariable == null || name != null && !name.equals(statusVariable.getName()) || processor.execute((PsiElement)statusVariable, state);
        }

        @Nullable
        public PsiVariable getVarVariable() {
            PsiType typeCollection;
            this.ensureInit();
            if (this.varVariable != null) {
                return this.varVariable;
            }
            if (this.varName == null) {
                return null;
            }
            PsiClassType typeElement = null;
            XmlAttributeValue attrIn = GrailsPsiUtil.getAttributeValue(this.tag, "in");
            if (attrIn != null && (typeCollection = GrailsPsiUtil.getAttributeExpressionType(attrIn)) != null) {
                typeElement = GrailsPsiUtil.getElementTypeByCollectionType(typeCollection, this.tag.getProject(), this.tag.getResolveScope());
            }
            if (typeElement == null) {
                typeElement = TypesUtil.getJavaLangObject((PsiElement)this.tag);
            }
            this.varVariable = new GrLightVariable(this.tag.getManager(), this.varName, (PsiType)typeElement, (PsiElement)(this.varNavigationElement != null ? this.varNavigationElement : (attrIn == null ? this.tag : attrIn)));
            return this.varVariable;
        }

        public PsiVariable getStatusVariable() {
            this.ensureInit();
            return this.statusVariable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/grails/lang/gsp/psi/groovy/impl/GspPageSkeleton$EachTagDescription";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NonEachTagDescription
    extends TagDescription {
        protected volatile boolean isVariableInit;
        protected PsiVariable variable;

        protected NonEachTagDescription(GspTag tag, TagDescription parent) {
            super(tag, parent);
        }

        @Override
        public boolean process(@NotNull PsiScopeProcessor processor, @Nullable String name, @NotNull ResolveState state) {
            if (processor == null) {
                NonEachTagDescription.$$$reportNull$$$0(0);
            }
            if (state == null) {
                NonEachTagDescription.$$$reportNull$$$0(1);
            }
            if (name == null || name.equals("it")) {
                if (!this.isVariableInit) {
                    XmlAttributeValue attrIn = GrailsPsiUtil.getAttributeValue(this.tag, "in");
                    if (attrIn != null) {
                        PsiClassType typeElement = null;
                        PsiType typeCollection = GrailsPsiUtil.getAttributeExpressionType(attrIn);
                        if (typeCollection != null) {
                            typeElement = GrailsPsiUtil.getElementTypeByCollectionType(typeCollection, this.tag.getProject(), this.tag.getResolveScope());
                        }
                        if (typeElement == null) {
                            typeElement = TypesUtil.getJavaLangObject((PsiElement)this.tag);
                        }
                        this.variable = new GrLightVariable(this.tag.getManager(), "it", (PsiType)typeElement, (PsiElement)attrIn);
                    }
                    this.isVariableInit = true;
                }
                if (this.variable != null && !processor.execute((PsiElement)this.variable, state)) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/grails/lang/gsp/psi/groovy/impl/GspPageSkeleton$NonEachTagDescription";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class TagDescription {
        public final GspTag tag;
        public final TagDescription parent;

        protected TagDescription(GspTag tag, TagDescription parent) {
            this.tag = tag;
            this.parent = parent;
        }

        public abstract boolean process(@NotNull PsiScopeProcessor var1, @Nullable String var2, @NotNull ResolveState var3);
    }

    static class DefTagDescription {
        public final GspTag tag;
        public final String name;
        private PsiVariable variable;

        DefTagDescription(GspTag tag, String name) {
            this.tag = tag;
            this.name = name;
        }

        public PsiVariable getVariable() {
            if (this.variable == null) {
                XmlAttributeValue valueAttr = GrailsPsiUtil.getAttributeValue(this.tag, "value");
                PsiType type = null;
                if (valueAttr != null) {
                    type = GrailsPsiUtil.getAttributeExpressionType(valueAttr);
                }
                if (type == null) {
                    type = PsiType.getJavaLangString((PsiManager)this.tag.getManager(), (GlobalSearchScope)this.tag.getResolveScope());
                }
                this.variable = new GrLightVariable(this.tag.getManager(), this.name, type, (PsiElement)GrailsPsiUtil.getAttributeValue(this.tag, "var"));
            }
            return this.variable;
        }
    }
}

