/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter.processors;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspXmlRootTag;

public class GspIndentProcessor
implements GspTokenTypesEx {
    private GspIndentProcessor() {
    }

    @NotNull
    public static Indent getGspChildIndent(@NotNull ASTNode parent, @NotNull ASTNode child, XmlFormattingPolicy policy) {
        if (parent == null) {
            GspIndentProcessor.$$$reportNull$$$0(0);
        }
        if (child == null) {
            GspIndentProcessor.$$$reportNull$$$0(1);
        }
        PsiElement parentPsi = parent.getPsi();
        PsiElement childPsi = child.getPsi();
        if (parentPsi instanceof GspXmlRootTag) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                GspIndentProcessor.$$$reportNull$$$0(2);
            }
            return indent;
        }
        if (parentPsi instanceof XmlTag) {
            if (GspTokenTypesEx.GSP_GROOVY_SEPARATORS.contains(child.getElementType())) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    GspIndentProcessor.$$$reportNull$$$0(3);
                }
                return indent;
            }
            if (childPsi instanceof XmlTag || childPsi instanceof XmlText || XML_DATA_CHARACTERS == child.getElementType()) {
                Indent indent = GspIndentProcessor.indentForHtmlTag(policy, (XmlTag)parent);
                if (indent == null) {
                    GspIndentProcessor.$$$reportNull$$$0(4);
                }
                return indent;
            }
            if (childPsi instanceof OuterLanguageElement) {
                if (JavaScriptIntegrationUtil.isJavaScriptInjection(childPsi)) {
                    Indent indent = Indent.getNormalIndent();
                    if (indent == null) {
                        GspIndentProcessor.$$$reportNull$$$0(5);
                    }
                    return indent;
                }
                Indent indent = parentPsi instanceof HtmlTag ? GspIndentProcessor.indentForHtmlTag(policy, (XmlTag)((HtmlTag)parentPsi)) : Indent.getNormalIndent();
                if (indent == null) {
                    GspIndentProcessor.$$$reportNull$$$0(6);
                }
                return indent;
            }
            if (childPsi instanceof XmlAttribute) {
                Indent indent = Indent.getContinuationIndent();
                if (indent == null) {
                    GspIndentProcessor.$$$reportNull$$$0(7);
                }
                return indent;
            }
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            GspIndentProcessor.$$$reportNull$$$0(8);
        }
        return indent;
    }

    public static Indent indentForHtmlTag(XmlFormattingPolicy policy, XmlTag parent) {
        return policy.indentChildrenOf(parent) ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/formatter/processors/GspIndentProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGspChildIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGspChildIndent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

