/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.i18n.GrailsI18nizeQuickFixDialog;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspElementTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspOuterGroovyElement;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspExpressionTag;

public class GrailsI18nQuickFixHandler
implements I18nQuickFixHandler {
    public static final GrailsI18nQuickFixHandler INSTANCE = new GrailsI18nQuickFixHandler();

    private GrailsI18nQuickFixHandler() {
    }

    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        final FileViewProvider viewProvider = psiFile.getViewProvider();
        PsiFile gspHtmlFile = viewProvider.getPsi(StdLanguages.HTML);
        assert (gspHtmlFile != null);
        final TextRange selectedRange = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)psiFile);
        assert (selectedRange != null);
        gspHtmlFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            private void throwError() {
                throw new IncorrectOperationException("Please select GSP text to I18nize.\nMake sure you have not selected any scriptlets, custom tags or other foreign languages elements.\nAlso, HTML tags inside selection must be balanced.");
            }

            public void visitElement(PsiElement element) {
                TextRange elementRange = element.getTextRange();
                if (elementRange.intersectsStrict(selectedRange)) {
                    if (GrailsI18nQuickFixHandler.isInapplicableOuterElement(element, elementRange, selectedRange, viewProvider)) {
                        this.throwError();
                    }
                    if (element instanceof XmlTag && !selectedRange.contains(elementRange)) {
                        XmlTag xmlTag;
                        if (!elementRange.contains(selectedRange)) {
                            this.throwError();
                        }
                        if (!(xmlTag = (XmlTag)element).getValue().getTextRange().contains(selectedRange) && !GrailsI18nQuickFixHandler.isAttributeValueSelected(xmlTag, selectedRange)) {
                            this.throwError();
                        }
                    }
                }
                super.visitElement(element);
            }
        });
    }

    private static boolean isAttributeValueSelected(XmlTag xmlTag, TextRange selectedRange) {
        for (XmlAttribute attribute : xmlTag.getAttributes()) {
            XmlAttributeValue valueElement = attribute.getValueElement();
            if (valueElement == null || !valueElement.getTextRange().contains(selectedRange) || !valueElement.getValueTextRange().contains(selectedRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInapplicableOuterElement(PsiElement element, TextRange elementRange, TextRange selectedRange, FileViewProvider viewProvider) {
        if (element instanceof OuterLanguageElement) {
            PsiElement gspElement = viewProvider.findElementAt(element.getTextOffset(), (Language)GspLanguage.INSTANCE);
            if (gspElement == null) {
                return true;
            }
            PsiElement exprTag = gspElement.getParent();
            if (!(exprTag instanceof GspExpressionTag)) {
                return true;
            }
            if (!exprTag.getTextRange().equals((Object)elementRange)) {
                return false;
            }
            return selectedRange.contains(elementRange);
        }
        return false;
    }

    public void performI18nization(PsiFile psiFile, Editor editor, PsiLiteralExpression literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, PsiExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
        Project project = psiFile.getProject();
        TextRange selectedText = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)psiFile);
        if (selectedText == null) {
            return;
        }
        propertyCreationHandler.createProperty(project, propertiesFiles, key, value, parameters);
        editor.getDocument().replaceString(selectedText.getStartOffset(), selectedText.getEndOffset(), (CharSequence)i18nizedText);
    }

    @Nullable
    public static Couple<String> calculatePropertyValue(Editor editor, PsiFile psiFile) {
        TextRange selectedRange = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)psiFile);
        if (selectedRange == null) {
            return null;
        }
        StringBuilder propertyValueText = new StringBuilder();
        StringBuilder argsText = new StringBuilder();
        int injectionCount = 0;
        PsiElement e = psiFile.getViewProvider().findElementAt(selectedRange.getStartOffset(), StdLanguages.HTML);
        while (e != null && e.getTextOffset() < selectedRange.getEndOffset()) {
            if (e instanceof OuterLanguageElement) {
                PsiElement firstChild;
                PsiElement gspElement = psiFile.getViewProvider().findElementAt(e.getTextOffset(), (Language)GspLanguage.INSTANCE);
                if (gspElement == null) {
                    return null;
                }
                PsiElement exprTag = gspElement.getParent();
                if (!(exprTag instanceof GspExpressionTag)) {
                    return null;
                }
                TextRange exprTagTextRange = exprTag.getTextRange();
                if (!selectedRange.contains(exprTagTextRange)) {
                    return null;
                }
                propertyValueText.append('{').append(injectionCount++).append('}');
                if (argsText.length() > 0) {
                    argsText.append(", ");
                }
                if (!PsiImplUtil.isLeafElementOfType((PsiElement)(firstChild = exprTag.getFirstChild()), (IElementType)GspElementTypes.JEXPR_BEGIN) && !PsiImplUtil.isLeafElementOfType((PsiElement)firstChild, (IElementType)GspElementTypes.GEXPR_BEGIN)) {
                    return null;
                }
                assert (firstChild != null);
                PsiElement expr = firstChild.getNextSibling();
                if (!(expr instanceof GspOuterGroovyElement)) {
                    return null;
                }
                PsiElement closedElement = expr.getNextSibling();
                if (closedElement == null || closedElement != exprTag.getLastChild()) {
                    return null;
                }
                argsText.append(expr.getText().trim());
                e = psiFile.getViewProvider().findElementAt(exprTagTextRange.getEndOffset(), StdLanguages.HTML);
                continue;
            }
            CharSequence chars = ((LeafPsiElement)e).getChars();
            int start = e.getTextOffset();
            propertyValueText.append(chars, Math.max(selectedRange.getStartOffset(), start) - start, Math.min(start + chars.length(), selectedRange.getEndOffset()) - start);
            e = PsiTreeUtil.nextLeaf((PsiElement)e);
        }
        return Couple.of((Object)propertyValueText.toString(), (Object)argsText.toString());
    }

    public JavaI18nizeQuickFixDialog createDialog(Project project, Editor editor, PsiFile psiFile) {
        final Couple<String> pair = GrailsI18nQuickFixHandler.calculatePropertyValue(editor, psiFile);
        if (pair == null) {
            return null;
        }
        TextRange selectedRange = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)psiFile);
        assert (selectedRange != null);
        PsiElement e = psiFile.getViewProvider().findElementAt(selectedRange.getStartOffset(), StdLanguages.HTML);
        XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttributeValue.class);
        if (attributeValue != null) {
            return new GrailsI18nizeQuickFixDialog(project, psiFile, (String)pair.first){

                @Override
                protected String getArgs() {
                    return (String)pair.second;
                }

                public String getI18nizedText() {
                    String nizedText = super.getI18nizedText();
                    return "${" + nizedText + "}";
                }

                @Override
                @NotNull
                protected String getTemplateName() {
                    String string = ((String)pair.second).length() > 0 ? "I18nized Groovy string with injections.gsp" : "I18nized Groovy string.gsp";
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nQuickFixHandler$2", "getTemplateName"));
                }
            };
        }
        return new GrailsI18nizeQuickFixDialog(project, psiFile, (String)pair.first){

            @Override
            protected String getArgs() {
                return (String)pair.second;
            }

            @Override
            @NotNull
            protected String getTemplateName() {
                String string = ((String)pair.second).length() > 0 ? "I18nized GSP Expression with injections.gsp" : "I18nized GSP Expression.gsp";
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nQuickFixHandler$3", "getTemplateName"));
            }
        };
    }
}

