/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;

public class UpdateGrailsSettingsAction
extends DumbAwareAction {
    public UpdateGrailsSettingsAction() {
        super("Synchronize Grails settings", "Refresh IntelliJ IDEA project structure so that it matches Grails build settings", AllIcons.Actions.Refresh);
    }

    public void update(AnActionEvent e) {
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(application instanceof OldGrailsApplication);
    }

    public void actionPerformed(AnActionEvent e) {
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        if (application instanceof OldGrailsApplication) {
            GrailsFramework.forceSynchronizationSetting(((OldGrailsApplication)application).getModule());
        }
    }
}

