/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModelImpl;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.RowHeaderView;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class RowHeaderMouseHandler<N> {
    private final DsmTableImpl<N> myDsmTable;
    private final RowHeaderView<N> myRowHeaderView;
    private final DsmSelectionModelImpl<N> mySelectionModel;

    public RowHeaderMouseHandler(DsmTableImpl<N> dsmTable, RowHeaderView<N> rowHeaderView) {
        this.myDsmTable = dsmTable;
        this.myRowHeaderView = rowHeaderView;
        this.mySelectionModel = this.myDsmTable.mySelectionModel;
    }

    public void processMouseEvent(@NotNull MouseEvent e) {
        if (e == null) {
            RowHeaderMouseHandler.$$$reportNull$$$0(0);
        }
        if (e.isConsumed() && !e.isPopupTrigger()) {
            return;
        }
        this.myDsmTable.updateCache();
        if (e.getID() == 501 && (e.getButton() == 1 || e.isPopupTrigger())) {
            this.processRowHeaderClick(e);
        }
    }

    private void processRowHeaderClick(MouseEvent e) {
        DsmTreeStructure.TreeNode<N> node = this.myRowHeaderView.locateRow(e.getX(), e.getY());
        e.consume();
        Rectangle nodeBounds = this.myDsmTable.myCache.rowHeaderBounds.get(node);
        if (node == null) {
            return;
        }
        if (e.getX() - nodeBounds.x < this.myDsmTable.myBoxSize && e.getY() - nodeBounds.y < this.myDsmTable.myBoxSize || e.getClickCount() == 2) {
            if (!node.isLeaf()) {
                if (!this.myDsmTable.isExpanded(node)) {
                    this.myDsmTable.expand(node);
                } else {
                    this.myDsmTable.collapse(node);
                }
            }
        } else {
            Map indices = this.myDsmTable.myCache.rowIndices;
            DsmTreeStructure.TreeNode<N> startNode = node;
            Integer startIndex = indices.get(node);
            while (!startNode.isLeaf() && startIndex == null) {
                DsmTreeStructure.TreeNode<N>[] children = startNode.getChildren();
                startNode = children[0];
                startIndex = indices.get(startNode);
            }
            Integer endIndex = indices.get(node);
            DsmTreeStructure.TreeNode<N> endNode = node;
            while (!endNode.isLeaf() && endIndex == null) {
                DsmTreeStructure.TreeNode<N>[] children = endNode.getChildren();
                endNode = children[children.length - 1];
                endIndex = indices.get(endNode);
            }
            if (startIndex == null || endIndex == null) {
                return;
            }
            DsmSelection<N> selection = DsmSelection.createRowSelection(Collections.singleton(node), startIndex, endIndex);
            if (e.isShiftDown()) {
                this.mySelectionModel.expandSelection(selection);
            } else {
                if (!e.isMetaDown() && !e.isControlDown() || e.isPopupTrigger() && !this.mySelectionModel.isSelected(node)) {
                    this.mySelectionModel.clear();
                }
                this.mySelectionModel.addSelection(selection);
            }
        }
        this.myRowHeaderView.showRowHint(node);
        this.myDsmTable.update();
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (this.myDsmTable.myCache == null) {
            return;
        }
        DsmTreeStructure.TreeNode<N> node = this.myRowHeaderView.locateRow(e.getX(), e.getY());
        if (e.getID() == 506 && e.getButton() == 1) {
            Map indices = this.myDsmTable.myCache.rowIndices;
            Integer rowIndex = indices.get(node);
            if (rowIndex == null) {
                return;
            }
            DsmSelection<N> selection = DsmSelection.createRowSelection(node, rowIndex);
            this.mySelectionModel.expandSelection(selection);
        } else {
            this.myRowHeaderView.showRowHint(node);
            this.myDsmTable.update();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dsm/ui/RowHeaderMouseHandler", "processMouseEvent"));
    }
}

