/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.And;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.Nullable;

class ModuleSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    private final ModuleGrouper myGrouper;

    public ModuleSplitter(@Nullable ModuleGrouper grouper) {
        this.myGrouper = grouper;
    }

    @Override
    public List<Pair<Predicate<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, Predicate<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        ArrayList<Pair<Predicate<ClassNode>, TopToBottomTreeStructure.NodeData>> result = new ArrayList<Pair<Predicate<ClassNode>, TopToBottomTreeStructure.NodeData>>();
        if (parentData instanceof MyNodeData) {
            result.add(new Pair(memberFunction, null));
            return result;
        }
        HashSet<ClassNode> globalClasses = new HashSet<ClassNode>();
        HashSet<Couple> moduleNamesSet = new HashSet<Couple>();
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode2 = dataGraph.getNode(i);
            if (!memberFunction.test(classNode2)) continue;
            if (classNode2.module != null) {
                String moduleName = classNode2.module.getName();
                moduleNamesSet.add(Couple.of((Object)moduleName, (Object)(this.myGrouper != null ? this.myGrouper.getShortenedName(classNode2.module) : moduleName)));
                continue;
            }
            globalClasses.add(classNode2);
        }
        result.addAll(moduleNamesSet.stream().sorted(Comparator.comparing(pair -> (String)pair.first)).map(pair -> new Pair(new And<ClassNode>(memberFunction, classNode -> classNode.getModuleName().equals(pair.first)), (Object)new MyNodeData((String)pair.first, (String)pair.second))).collect(Collectors.toList()));
        if (!globalClasses.isEmpty()) {
            result.add((Pair<Predicate<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> globalClasses.contains(classNode), null));
        }
        return result;
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        public MyNodeData(String moduleName, String presentableName) {
            super(presentableName, moduleName, AllIcons.Nodes.Module);
        }
    }
}

