/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleGroupSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    private final ModuleGrouper myGrouper;
    private final Map<Module, List<String>> myCache = new THashMap();

    public ModuleGroupSplitter(ModuleGrouper grouper) {
        this.myGrouper = grouper;
    }

    @Override
    public List<Pair<Predicate<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, Predicate<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        List currentPath = parentData instanceof MyNodeData ? ((MyNodeData)parentData).myGroups : Collections.emptyList();
        HashSet<String> subGroupsSet = new HashSet<String>();
        boolean modulesInsideFound = false;
        boolean classedOutOfModulesFound = false;
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode2 = dataGraph.getNode(i);
            if (!memberFunction.test(classNode2)) continue;
            Module module = classNode2.module;
            if (module == null && currentPath.isEmpty()) {
                classedOutOfModulesFound = true;
                continue;
            }
            List<String> p = this.getGroupPath(module);
            if (ModuleGroupSplitter.equal(currentPath, p)) {
                modulesInsideFound = true;
                continue;
            }
            if (!ContainerUtil.startsWith(p, currentPath)) continue;
            subGroupsSet.add(p.get(currentPath.size()));
        }
        SmartList result = new SmartList();
        Object[] groups = ArrayUtil.toStringArray(subGroupsSet);
        Arrays.sort(groups);
        for (Object group : groups) {
            List subPath = ContainerUtil.append(currentPath, (Object[])new String[]{group});
            result.add(new Pair(classNode -> ContainerUtil.startsWith(this.getGroupPath(classNode.module), (List)subPath), (Object)new MyNodeData((String)group, StringUtil.join((Collection)subPath, (String)"."), AllIcons.Nodes.ModuleGroup, subPath)));
        }
        if (modulesInsideFound) {
            result.add(new Pair(classNode -> ModuleGroupSplitter.equal(currentPath, this.getGroupPath(classNode.module)), null));
        }
        if (classedOutOfModulesFound) {
            result.add(new Pair(classNode -> classNode.module == null, null));
        }
        return result;
    }

    private static <T> boolean equal(@Nullable List<T> list1, @Nullable List<T> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        int size = list1.size();
        if (size != list2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (Objects.equals(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private List<String> getGroupPath(Module module) {
        List<String> path = this.myCache.get(module);
        if (path != null) {
            List<String> list = path;
            if (list == null) {
                ModuleGroupSplitter.$$$reportNull$$$0(0);
            }
            return list;
        }
        List newPath = this.myGrouper.getGroupPath(module);
        this.myCache.put(module, newPath);
        List list = newPath;
        if (list == null) {
            ModuleGroupSplitter.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dsm/model/classes/ModuleGroupSplitter", "getGroupPath"));
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        final List<String> myGroups;

        public MyNodeData(String shortName, String fullName, Icon icon, List<String> groups) {
            super(shortName, fullName, icon);
            this.myGroups = groups;
        }
    }
}

