/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.split;

import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class SplitTextEditorProvider
implements AsyncFileEditorProvider,
DumbAware {
    private static final String FIRST_EDITOR = "first_editor";
    private static final String SECOND_EDITOR = "second_editor";
    private static final String SPLIT_LAYOUT = "split_layout";
    @NotNull
    protected final FileEditorProvider myFirstProvider;
    @NotNull
    protected final FileEditorProvider mySecondProvider;
    @NotNull
    private final String myEditorTypeId;

    public SplitTextEditorProvider(@NotNull FileEditorProvider firstProvider, @NotNull FileEditorProvider secondProvider) {
        if (firstProvider == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(0);
        }
        if (secondProvider == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(1);
        }
        this.myFirstProvider = firstProvider;
        this.mySecondProvider = secondProvider;
        this.myEditorTypeId = "split-provider[" + this.myFirstProvider.getEditorTypeId() + ";" + this.mySecondProvider.getEditorTypeId() + "]";
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(3);
        }
        return this.myFirstProvider.accept(project, file) && this.mySecondProvider.accept(project, file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(5);
        }
        FileEditor fileEditor = this.createEditorAsync(project, file).build();
        if (fileEditor == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(6);
        }
        return fileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        String string = this.myEditorTypeId;
        if (string == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public AsyncFileEditorProvider.Builder createEditorAsync(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(8);
        }
        if (file == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(9);
        }
        final AsyncFileEditorProvider.Builder firstBuilder = SplitTextEditorProvider.getBuilderFromEditorProvider(this.myFirstProvider, project, file);
        final AsyncFileEditorProvider.Builder secondBuilder = SplitTextEditorProvider.getBuilderFromEditorProvider(this.mySecondProvider, project, file);
        AsyncFileEditorProvider.Builder builder = new AsyncFileEditorProvider.Builder(){

            public FileEditor build() {
                return SplitTextEditorProvider.this.createSplitEditor(firstBuilder.build(), secondBuilder.build());
            }
        };
        if (builder == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(10);
        }
        return builder;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Attribute attribute;
        if (sourceElement == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(11);
        }
        if (project == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(12);
        }
        if (file == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(13);
        }
        Element child = sourceElement.getChild(FIRST_EDITOR);
        FileEditorState firstState = null;
        if (child != null) {
            firstState = this.myFirstProvider.readState(child, project, file);
        }
        child = sourceElement.getChild(SECOND_EDITOR);
        FileEditorState secondState = null;
        if (child != null) {
            secondState = this.mySecondProvider.readState(child, project, file);
        }
        String layoutName = (attribute = sourceElement.getAttribute(SPLIT_LAYOUT)) != null ? attribute.getValue() : null;
        SplitFileEditor.MyFileEditorState myFileEditorState = new SplitFileEditor.MyFileEditorState(layoutName, firstState, secondState);
        if (myFileEditorState == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(14);
        }
        return myFileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(15);
        }
        if (project == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(16);
        }
        if (targetElement == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(17);
        }
        if (!(state instanceof SplitFileEditor.MyFileEditorState)) {
            return;
        }
        SplitFileEditor.MyFileEditorState compositeState = (SplitFileEditor.MyFileEditorState)state;
        Element child = new Element(FIRST_EDITOR);
        if (compositeState.getFirstState() != null) {
            this.myFirstProvider.writeState(compositeState.getFirstState(), project, child);
            targetElement.addContent(child);
        }
        child = new Element(SECOND_EDITOR);
        if (compositeState.getSecondState() != null) {
            this.mySecondProvider.writeState(compositeState.getSecondState(), project, child);
            targetElement.addContent(child);
        }
        if (compositeState.getSplitLayout() != null) {
            targetElement.setAttribute(SPLIT_LAYOUT, compositeState.getSplitLayout());
        }
    }

    protected abstract FileEditor createSplitEditor(@NotNull FileEditor var1, @NotNull FileEditor var2);

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(18);
        }
        return fileEditorPolicy;
    }

    @NotNull
    private static AsyncFileEditorProvider.Builder getBuilderFromEditorProvider(final @NotNull FileEditorProvider provider, final @NotNull Project project, final @NotNull VirtualFile file) {
        if (provider == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(19);
        }
        if (project == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(20);
        }
        if (file == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(21);
        }
        if (provider instanceof AsyncFileEditorProvider) {
            AsyncFileEditorProvider.Builder builder = ((AsyncFileEditorProvider)provider).createEditorAsync(project, file);
            if (builder == null) {
                SplitTextEditorProvider.$$$reportNull$$$0(22);
            }
            return builder;
        }
        AsyncFileEditorProvider.Builder builder = new AsyncFileEditorProvider.Builder(){

            public FileEditor build() {
                return provider.createEditor(project, file);
            }
        };
        if (builder == null) {
            SplitTextEditorProvider.$$$reportNull$$$0(23);
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondProvider";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/split/SplitTextEditorProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorAsync";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderFromEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 23: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEditorAsync";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderFromEditorProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

