/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.lobo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.Range;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.lobo.MarkdownHtmlRendererContext;
import org.intellij.plugins.markdown.ui.preview.lobo.ScrollPreservingHtmlBlockPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.NodeVisitor;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.gui.HtmlBlockPanel;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.w3c.dom.Node;

final class LoboHtmlPanel
extends MarkdownHtmlPanel {
    private static final int FOCUS_ELEMENT_DY = 100;
    @NotNull
    private final HtmlPanel myPanel = new HtmlPanel(){

        protected HtmlBlockPanel createHtmlBlockPanel(UserAgentContext ucontext, HtmlRendererContext rcontext) {
            return new ScrollPreservingHtmlBlockPanel((Color)JBColor.WHITE, true, ucontext, rcontext, (FrameContext)this);
        }
    };
    @NotNull
    private final MarkdownHtmlRendererContext myHtmlRendererContext = new MarkdownHtmlRendererContext(this.myPanel);
    @NotNull
    private String myLastRenderedHtml = "";
    @Nullable
    private String myCssInlineText = null;

    public LoboHtmlPanel() {
        this.myPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LoboHtmlPanel.this.adjustBrowserSize();
            }
        });
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        HtmlPanel htmlPanel = this.myPanel;
        if (htmlPanel == null) {
            LoboHtmlPanel.$$$reportNull$$$0(0);
        }
        return htmlPanel;
    }

    @Override
    public void setCSS(@Nullable String inlineCss, String ... fileUris) {
        if (fileUris == null) {
            LoboHtmlPanel.$$$reportNull$$$0(1);
        }
        this.myCssInlineText = StringUtil.notNullize((String)inlineCss);
        if (fileUris.length > 0 && fileUris[0] != null) {
            try {
                URL url = URI.create(fileUris[0]).toURL();
                String cssText = StreamUtil.readText((InputStream)url.openStream(), (String)"UTF-8");
                this.myCssInlineText = cssText + "\n" + this.myCssInlineText;
                this.myCssInlineText = this.myCssInlineText + "body {\n  font-size: " + JBUI.scale((int)100) + "%;\n}";
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setHtml(@NotNull String html) {
        if (html == null) {
            LoboHtmlPanel.$$$reportNull$$$0(2);
        }
        this.myLastRenderedHtml = html;
        String htmlToRender = html.replace("<head>", "<head>" + LoboHtmlPanel.getCssLines(this.myCssInlineText, new String[0]));
        this.myPanel.setHtml(htmlToRender, "file://a.html", (HtmlRendererContext)this.myHtmlRendererContext);
    }

    @Override
    public void render() {
        this.setHtml(this.myLastRenderedHtml);
    }

    private void adjustBrowserSize() {
    }

    @Override
    public void scrollToMarkdownSrcOffset(final int offset) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            DOMNodeImpl root = this.myPanel.getRootNode();
            final Ref resultY = new Ref();
            root.visit(new NodeVisitor(){

                public void visit(Node node) {
                    Node child = node.getFirstChild();
                    while (child != null) {
                        Range range = LoboHtmlPanel.nodeToSrcRange(child);
                        if (range != null && child instanceof DOMNodeImpl) {
                            int currentDist = Math.min(Math.abs((Integer)range.getFrom() - offset), Math.abs((Integer)range.getTo() - 1 - offset));
                            if (resultY.get() == null || (Integer)((Pair)resultY.get()).getSecond() > currentDist) {
                                resultY.set((Object)Pair.create((Object)child, (Object)currentDist));
                            }
                        }
                        if (range == null || (Integer)range.getTo() <= offset) {
                            child = child.getNextSibling();
                            continue;
                        }
                        if ((Integer)range.getFrom() > offset) break;
                        if ((Integer)range.getTo() <= offset) continue;
                        this.visit(child);
                        break;
                    }
                }
            });
            if (resultY.get() != null) {
                this.myPanel.scrollTo((Node)((Pair)resultY.get()).getFirst());
                RBlockViewport viewport = ((RBlock)this.myPanel.getBlockRenderable()).getRBlockViewport();
                Rectangle renderBounds = this.myPanel.getBlockRenderable().getBounds();
                if ((double)(viewport.getY() + viewport.getHeight()) - renderBounds.getHeight() > 0.0) {
                    this.myPanel.scrollBy(0, -100);
                }
                this.myPanel.repaint();
            }
        }, ModalityState.NON_MODAL);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/lobo/LoboHtmlPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUris";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/lobo/LoboHtmlPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCSS";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

