/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownLAFListener;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="MarkdownApplicationSettings", storages={@Storage(value="markdown.xml")})
public class MarkdownApplicationSettings
implements PersistentStateComponent<State>,
MarkdownCssSettings.Holder,
MarkdownPreviewSettings.Holder {
    private State myState = new State();

    public MarkdownApplicationSettings() {
        MarkdownLAFListener lafListener = new MarkdownLAFListener();
        LafManager.getInstance().addLafManagerListener((LafManagerListener)lafListener);
        ApplicationManager.getApplication().invokeLater(() -> lafListener.updateCssSettingsForced(UIUtil.isUnderDarcula()));
    }

    @NotNull
    public static MarkdownApplicationSettings getInstance() {
        MarkdownApplicationSettings markdownApplicationSettings = (MarkdownApplicationSettings)ServiceManager.getService(MarkdownApplicationSettings.class);
        if (markdownApplicationSettings == null) {
            MarkdownApplicationSettings.$$$reportNull$$$0(0);
        }
        return markdownApplicationSettings;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    @Override
    public void setMarkdownCssSettings(@NotNull MarkdownCssSettings settings) {
        if (settings == null) {
            MarkdownApplicationSettings.$$$reportNull$$$0(1);
        }
        ((SettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SettingsChangedListener.TOPIC)).beforeSettingsChanged(this);
        this.myState.myCssSettings = settings;
    }

    @Override
    @NotNull
    public MarkdownCssSettings getMarkdownCssSettings() {
        if (MarkdownCssSettings.DARCULA.getStylesheetUri().equals(this.myState.myCssSettings.getStylesheetUri()) || MarkdownCssSettings.DEFAULT.getStylesheetUri().equals(this.myState.myCssSettings.getStylesheetUri())) {
            MarkdownCssSettings markdownCssSettings = new MarkdownCssSettings(false, "", this.myState.myCssSettings.isTextEnabled(), this.myState.myCssSettings.getStylesheetText());
            if (markdownCssSettings == null) {
                MarkdownApplicationSettings.$$$reportNull$$$0(2);
            }
            return markdownCssSettings;
        }
        MarkdownCssSettings markdownCssSettings = this.myState.myCssSettings;
        if (markdownCssSettings == null) {
            MarkdownApplicationSettings.$$$reportNull$$$0(3);
        }
        return markdownCssSettings;
    }

    @Override
    public void setMarkdownPreviewSettings(@NotNull MarkdownPreviewSettings settings) {
        if (settings == null) {
            MarkdownApplicationSettings.$$$reportNull$$$0(4);
        }
        ((SettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SettingsChangedListener.TOPIC)).beforeSettingsChanged(this);
        this.myState.myPreviewSettings = settings;
    }

    @Override
    @NotNull
    public MarkdownPreviewSettings getMarkdownPreviewSettings() {
        MarkdownPreviewSettings markdownPreviewSettings = this.myState.myPreviewSettings;
        if (markdownPreviewSettings == null) {
            MarkdownApplicationSettings.$$$reportNull$$$0(5);
        }
        return markdownPreviewSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownApplicationSettings";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownApplicationSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkdownCssSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkdownPreviewSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMarkdownCssSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMarkdownPreviewSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SettingsChangedListener {
        public static final Topic<SettingsChangedListener> TOPIC = Topic.create((String)"MarkdownApplicationSettingsChanged", SettingsChangedListener.class);

        public void beforeSettingsChanged(@NotNull MarkdownApplicationSettings var1);
    }

    public static class State {
        @Property(surroundWithTag=false)
        @NotNull
        private MarkdownCssSettings myCssSettings = MarkdownCssSettings.DEFAULT;
        @Property(surroundWithTag=false)
        @NotNull
        private MarkdownPreviewSettings myPreviewSettings = MarkdownPreviewSettings.DEFAULT;
    }
}

