/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;

public class JavaElementVisitor
extends PsiElementVisitor {
    public void visitReferenceExpression(PsiReferenceExpression psiReferenceExpression) {
    }

    public void visitClass(PsiClass psiClass) {
        this.checkElement((PsiElement)psiClass);
        this.visitModifierListOwner((PsiModifierListOwner)psiClass);
    }

    public void visitField(PsiField psiField) {
        this.checkElement((PsiElement)psiField);
        this.visitModifierListOwner((PsiModifierListOwner)psiField);
    }

    public void visitMethod(PsiMethod psiMethod) {
        this.checkElement((PsiElement)psiMethod);
        this.visitModifierListOwner((PsiModifierListOwner)psiMethod);
    }

    public void visitParameter(PsiParameter parameter) {
        this.checkElement((PsiElement)parameter);
        this.visitModifierListOwner((PsiModifierListOwner)parameter);
    }

    private void visitModifierListOwner(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                this.visitAnnotationValue(pair.getValue());
            }
        }
    }

    public void visitAnnotationValue(PsiAnnotationMemberValue value) {
        if (value instanceof PsiArrayInitializerMemberValue) {
            for (PsiAnnotationMemberValue memberValue : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                this.visitAnnotationValue(memberValue);
            }
        } else {
            this.checkElement((PsiElement)value);
        }
    }

    public void checkElement(PsiElement element) {
    }

    public void visitElement(PsiElement element) {
        if (element instanceof PsiClass) {
            this.visitClass((PsiClass)element);
        } else if (element instanceof PsiMethod) {
            this.visitMethod((PsiMethod)element);
        } else if (element instanceof PsiField) {
            this.visitField((PsiField)element);
        } else if (element instanceof PsiParameter) {
            this.visitParameter((PsiParameter)element);
        }
    }
}

