/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.action;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActionNameCustomReferenceConverter
implements CustomReferenceConverter<String> {
    @NonNls
    private static final String ACTION_SUFFIX = "action";
    private final Function<String, Object> ACTION_NAME_FUNCTION = s -> StringUtil.endsWithIgnoreCase((String)s, (String)ACTION_SUFFIX) ? StringUtil.replaceIgnoreCase((String)s, (String)ACTION_SUFFIX, (String)"") : s;

    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<String> genericDomValue, PsiElement psiElement, final ConvertContext convertContext) {
        PsiReferenceBase<PsiElement> ref = new PsiReferenceBase<PsiElement>(psiElement){

            public PsiElement resolve() {
                return genericDomValue.getParent().getXmlTag();
            }

            public boolean isSoft() {
                return true;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return this.getElement();
            }

            @NotNull
            public Object[] getVariants() {
                DomElement invocationElement = convertContext.getInvocationElement();
                Action action = (Action)invocationElement.getParentOfType(Action.class, true);
                assert (action != null);
                PsiClass psiClass = action.searchActionClass();
                if (psiClass == null) {
                    if (EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return EMPTY_ARRAY;
                }
                Project project = psiClass.getProject();
                PsiClassType classType = PsiTypesUtil.getClassType((PsiClass)psiClass);
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, (PsiType)classType);
                HashSet<String> variants = new HashSet<String>(Arrays.asList(info.names));
                variants.remove(ActionNameCustomReferenceConverter.ACTION_SUFFIX);
                List<Action> actions = action.getStrutsPackage().getActions();
                ContainerUtil.process(actions, action1 -> {
                    variants.remove(action1.getName().getStringValue());
                    return true;
                });
                Object[] objectArray = ContainerUtil.map2Array(variants, (Function)ActionNameCustomReferenceConverter.this.ACTION_NAME_FUNCTION);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/action/ActionNameCustomReferenceConverter$1", "getVariants"));
            }
        };
        PsiReference[] psiReferenceArray = new PsiReference[]{ref};
        if (psiReferenceArray == null) {
            ActionNameCustomReferenceConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/action/ActionNameCustomReferenceConverter", "createReferences"));
    }
}

