/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.annotations.concurrency.GuardedBy;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.inspections.klint.AndroidLintGlobalInspectionContext;
import org.jetbrains.android.inspections.klint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.klint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.klint.ProblemData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintInspectionBase
extends GlobalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.AndroidLintInspectionBase");
    private static final Object ISSUE_MAP_LOCK = new Object();
    @GuardedBy(value="ISSUE_MAP_LOCK")
    private static volatile Map<Issue, String> ourIssue2InspectionShortName;
    protected final Issue myIssue;
    private final String[] myGroupPath;
    private final String myDisplayName;

    protected AndroidLintInspectionBase(@NotNull String displayName, @NotNull Issue issue) {
        this.myIssue = issue;
        Category category = issue.getCategory();
        this.myGroupPath = ArrayUtil.mergeArrays((String[])new String[]{AndroidBundle.message((String)"android.inspections.group.name", (Object[])new Object[0]), AndroidBundle.message((String)"android.lint.inspections.subgroup.name", (Object[])new Object[0])}, (String[])AndroidLintInspectionBase.computeAllNames(category));
        this.myDisplayName = displayName;
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        return this.getQuickFixes(message);
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public IntentionAction[] getIntentions(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return IntentionAction.EMPTY_ARRAY;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    private LocalQuickFix[] getLocalQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        AndroidLintQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message);
        LocalQuickFix[] result = new LocalQuickFix[fixes.length];
        for (int i = 0; i < fixes.length; ++i) {
            if (!fixes[i].isApplicable(startElement, endElement, AndroidQuickfixContexts.BatchContext.TYPE)) continue;
            result[i] = new MyLocalQuickFix(fixes[i]);
        }
        return result;
    }

    public void runInspection(@NotNull AnalysisScope scope, final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        AndroidLintGlobalInspectionContext androidLintContext = (AndroidLintGlobalInspectionContext)globalContext.getExtension(AndroidLintGlobalInspectionContext.ID);
        if (androidLintContext == null) {
            return;
        }
        Map<Issue, Map<File, List<ProblemData>>> problemMap = androidLintContext.getResults();
        if (problemMap == null) {
            return;
        }
        Map<File, List<ProblemData>> file2ProblemList = problemMap.get(this.myIssue);
        if (file2ProblemList == null) {
            return;
        }
        for (final Map.Entry<File, List<ProblemData>> entry : file2ProblemList.entrySet()) {
            File file = entry.getKey();
            final VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ProblemDescriptor[] descriptors;
                    PsiDirectory psiDirectory;
                    PsiManager psiManager = PsiManager.getInstance((Project)globalContext.getProject());
                    PsiFile psiFile = psiManager.findFile(vFile);
                    if (psiFile != null) {
                        ProblemDescriptor[] descriptors2 = AndroidLintInspectionBase.this.computeProblemDescriptors((PsiElement)psiFile, manager, (List)entry.getValue());
                        if (descriptors2.length > 0) {
                            problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiFile), (CommonProblemDescriptor[])descriptors2);
                        }
                    } else if (vFile.isDirectory() && (psiDirectory = psiManager.findDirectory(vFile)) != null && (descriptors = AndroidLintInspectionBase.this.computeProblemDescriptors((PsiElement)psiDirectory, manager, (List)entry.getValue())).length > 0) {
                        problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiDirectory), (CommonProblemDescriptor[])descriptors);
                    }
                }
            });
        }
    }

    @NotNull
    private ProblemDescriptor[] computeProblemDescriptors(@NotNull PsiElement psiFile, @NotNull InspectionManager manager, @NotNull List<ProblemData> problems) {
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (ProblemData problemData : problems) {
            String originalMessage = problemData.getMessage();
            String formattedMessage = "<html>" + TextFormat.RAW.convertTo(originalMessage, TextFormat.HTML_WITH_UNICODE) + "</html>";
            TextRange range = problemData.getTextRange();
            if (range.getStartOffset() == range.getEndOffset()) {
                if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiDirectory) {
                    LocalQuickFix[] fixes = this.getLocalQuickFixes(psiFile, psiFile, originalMessage);
                    result.add(new NonTextFileProblemDescriptor((PsiFileSystemItem)psiFile, formattedMessage, fixes));
                    continue;
                }
                if (this.isSuppressedFor(psiFile)) continue;
                result.add(manager.createProblemDescriptor(psiFile, formattedMessage, false, this.getLocalQuickFixes(psiFile, psiFile, originalMessage), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiElement startElement = psiFile.findElementAt(range.getStartOffset());
            PsiElement endElement = psiFile.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || this.isSuppressedFor(startElement)) continue;
            result.add(manager.createProblemDescriptor(startElement, endElement, formattedMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getLocalQuickFixes(startElement, endElement, originalMessage)));
        }
        return result.toArray(new ProblemDescriptor[result.size()]);
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        return new SuppressQuickFix[0];
    }

    public static void invalidateInspectionShortName2IssueMap() {
        ourIssue2InspectionShortName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInspectionShortNameByIssue(@NotNull Project project, @NotNull Issue issue) {
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            if (ourIssue2InspectionShortName == null) {
                ourIssue2InspectionShortName = new HashMap();
                InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
                for (InspectionToolWrapper e : profile.getInspectionTools(null)) {
                    InspectionProfileEntry entry;
                    String shortName = e.getShortName();
                    if (!shortName.startsWith("AndroidKLint") || !((entry = e.getTool()) instanceof AndroidLintInspectionBase)) continue;
                    Issue s = ((AndroidLintInspectionBase)entry).getIssue();
                    ourIssue2InspectionShortName.put(s, shortName);
                }
            }
            return ourIssue2InspectionShortName.get(issue);
        }
    }

    @NotNull
    private static String[] computeAllNames(@NotNull Category category) {
        ArrayList<String> result = new ArrayList<String>();
        for (Category c = category; c != null; c = c.getParent()) {
            String name = c.getName();
            if (name == null) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            result.add(name);
        }
        return (String[])ArrayUtil.reverseArray((Object[])ArrayUtil.toStringArray(result));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return AndroidBundle.message((String)"android.lint.inspections.group.name", (Object[])new Object[0]);
    }

    @NotNull
    public String[] getGroupPath() {
        return this.myGroupPath;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getStaticDescription() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<html><body>");
        sb.append(this.myIssue.getBriefDescription(TextFormat.HTML));
        sb.append("<br><br>");
        sb.append(this.myIssue.getExplanation(TextFormat.HTML));
        List<String> urls = this.myIssue.getMoreInfo();
        if (!urls.isEmpty()) {
            boolean separated = false;
            for (String url : urls) {
                if (this.myIssue.getExplanation(TextFormat.RAW).contains(url)) continue;
                if (!separated) {
                    sb.append("<br><br>");
                    separated = true;
                } else {
                    sb.append("<br>");
                }
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\">");
                sb.append(url);
                sb.append("</a>");
            }
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isEnabledByDefault() {
        return this.myIssue.isEnabledByDefault();
    }

    @NotNull
    public String getShortName() {
        return InspectionProfileEntry.getShortName((String)((Object)((Object)this)).getClass().getSimpleName());
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        Severity defaultSeverity = this.myIssue.getDefaultSeverity();
        if (defaultSeverity == null) {
            return HighlightDisplayLevel.WARNING;
        }
        HighlightDisplayLevel displayLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(defaultSeverity);
        return displayLevel != null ? displayLevel : HighlightDisplayLevel.WARNING;
    }

    @Nullable
    static HighlightDisplayLevel toHighlightDisplayLevel(@NotNull Severity severity) {
        switch (severity) {
            case ERROR: {
                return HighlightDisplayLevel.ERROR;
            }
            case FATAL: {
                return HighlightDisplayLevel.ERROR;
            }
            case WARNING: {
                return HighlightDisplayLevel.WARNING;
            }
            case INFORMATIONAL: {
                return HighlightDisplayLevel.WEAK_WARNING;
            }
            case IGNORE: {
                return null;
            }
        }
        LOG.error("Unknown severity " + (Object)((Object)severity));
        return null;
    }

    private static boolean isSingleFileScope(EnumSet<Scope> scopes) {
        if (scopes.size() != 1) {
            return false;
        }
        Scope scope = (Scope)((Object)scopes.iterator().next());
        return scope == Scope.JAVA_FILE || scope == Scope.RESOURCE_FILE || scope == Scope.MANIFEST || scope == Scope.PROGUARD_FILE || scope == Scope.OTHER;
    }

    public boolean worksInBatchModeOnly() {
        Implementation implementation = this.myIssue.getImplementation();
        if (AndroidLintInspectionBase.isSingleFileScope(implementation.getScope())) {
            return false;
        }
        for (EnumSet<Scope> scopes : implementation.getAnalysisScopes()) {
            if (!AndroidLintInspectionBase.isSingleFileScope(scopes)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Issue getIssue() {
        return this.myIssue;
    }

    private static class NonTextFileProblemDescriptor
    implements ProblemDescriptor {
        private final PsiFileSystemItem myFile;
        private final String myMessage;
        private final LocalQuickFix[] myFixes;
        private ProblemGroup myGroup;

        public NonTextFileProblemDescriptor(@NotNull PsiFileSystemItem file, @NotNull String message, @NotNull LocalQuickFix[] fixes) {
            this.myFile = file;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        public PsiElement getPsiElement() {
            return this.myFile;
        }

        public PsiElement getStartElement() {
            return this.myFile;
        }

        public PsiElement getEndElement() {
            return this.myFile;
        }

        public TextRange getTextRangeInElement() {
            return new TextRange(0, 0);
        }

        public int getLineNumber() {
            return 0;
        }

        @NotNull
        public ProblemHighlightType getHighlightType() {
            return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }

        public boolean isAfterEndOfLine() {
            return false;
        }

        public void setTextAttributes(TextAttributesKey key) {
        }

        @Nullable
        public ProblemGroup getProblemGroup() {
            return this.myGroup;
        }

        public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
            this.myGroup = problemGroup;
        }

        public boolean showTooltip() {
            return false;
        }

        @NotNull
        public String getDescriptionTemplate() {
            return this.myMessage;
        }

        @Nullable
        public QuickFix[] getFixes() {
            return this.myFixes;
        }
    }

    static class MyLocalQuickFix
    implements LocalQuickFix {
        private final AndroidLintQuickFix myLintQuickFix;

        MyLocalQuickFix(@NotNull AndroidLintQuickFix lintQuickFix) {
            this.myLintQuickFix = lintQuickFix;
        }

        @NotNull
        public String getName() {
            return this.myLintQuickFix.getName();
        }

        @NotNull
        public String getFamilyName() {
            return AndroidBundle.message((String)"android.lint.quickfixes.family", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            this.myLintQuickFix.apply(descriptor.getStartElement(), descriptor.getEndElement(), AndroidQuickfixContexts.BatchContext.getInstance());
        }
    }
}

