/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class StringAuthLeakDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue AUTH_LEAK = Issue.create("AuthLeak", "Code might contain an auth leak", "Strings in java apps can be discovered by decompiling apps, this lint check looks for code which looks like it may contain an url with a username and password", Category.SECURITY, 6, Severity.WARNING, new Implementation(StringAuthLeakDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(ULiteralExpression.class);
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        return new AuthLeakChecker(context);
    }

    private static class AuthLeakChecker
    extends AbstractUastVisitor {
        private static final String LEGAL_CHARS = "([\\w_.!~*'()%;&=+$,-]+)";
        private static final Pattern AUTH_REGEXP = Pattern.compile("([\\w+.-]+)://([\\w_.!~*'()%;&=+$,-]+):([\\w_.!~*'()%;&=+$,-]+)@([\\w_.!~*'()%;&=+$,-]+)");
        private final JavaContext mContext;

        private AuthLeakChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitLiteralExpression(ULiteralExpression node) {
            Matcher matcher;
            if (node.getValue() instanceof String && (matcher = AUTH_REGEXP.matcher((String)node.getValue())).find()) {
                String password = matcher.group(3);
                if (password == null || password.startsWith("%") && password.endsWith("s")) {
                    return super.visitLiteralExpression(node);
                }
                Location location = this.mContext.getUastLocation((UElement)node);
                this.mContext.report(AUTH_LEAK, (UElement)node, location, "Possible credential leak");
            }
            return super.visitLiteralExpression(node);
        }
    }
}

