/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class SecureRandomDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("SecureRandom", "Using a fixed seed with `SecureRandom`", "Specifying a fixed seed will cause the instance to return a predictable sequence of numbers. This may be useful for testing but it is not appropriate for secure use.", Category.SECURITY, 9, Severity.WARNING, new Implementation(SecureRandomDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/java/security/SecureRandom.html");
    private static final String SET_SEED = "setSeed";
    public static final String JAVA_SECURITY_SECURE_RANDOM = "java.security.SecureRandom";
    public static final String JAVA_UTIL_RANDOM = "java.util.Random";

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(SET_SEED);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression call, @NonNull UMethod method) {
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        UExpression seedArgument = (UExpression)arguments.get(0);
        JavaEvaluator evaluator = context.getEvaluator();
        if (JavaEvaluator.isMemberInClass((PsiMember)method, JAVA_SECURITY_SECURE_RANDOM) || evaluator.isMemberInSubClassOf((PsiMember)method, JAVA_UTIL_RANDOM, false) && SecureRandomDetector.isSecureRandomReceiver(context, call)) {
            Object seed = ConstantEvaluator.evaluate(context, (UElement)seedArgument);
            if (seed != null) {
                context.report(ISSUE, (UElement)call, context.getUastLocation((UElement)call), "Do not call `setSeed()` on a `SecureRandom` with a fixed seed: it is not secure. Use `getSeed()`.");
            } else {
                PsiMethod seedMethod;
                String methodName2;
                PsiElement resolvedArgument = UastUtils.tryResolve((UElement)seedArgument);
                if (resolvedArgument instanceof PsiMethod && ((methodName2 = (seedMethod = (PsiMethod)resolvedArgument).getName()).equals("currentTimeMillis") || methodName2.equals("nanoTime"))) {
                    context.report(ISSUE, (UElement)call, context.getUastLocation((UElement)call), "It is dangerous to seed `SecureRandom` with the current time because that value is more predictable to an attacker than the default seed.");
                }
            }
        }
    }

    private static boolean isSecureRandomReceiver(@NonNull JavaContext context, @NonNull UCallExpression call) {
        UExpression operand2 = call.getReceiver();
        return operand2 != null && SecureRandomDetector.isSecureRandomType(context, (UElement)operand2);
    }

    private static boolean isSecureRandomType(@NonNull JavaContext context, @NonNull UElement node) {
        PsiType type2 = TypeEvaluator.evaluate(context, node);
        return type2 != null && JAVA_SECURITY_SECURE_RANDOM.equals(type2.getCanonicalText());
    }
}

